/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.gemalto;

import es.gob.jmulticard.apdu.CommandApdu;

public final class MseSetSignatureKeyApduCommand
extends CommandApdu {
    private static final byte INS_MANAGE_ENVIROMENT = 34;
    private static final byte SET_FOR_SIGN = 65;
    private static final byte SIGN_TEMPLATE = -74;
    private static final byte PRIVATE_KEY_REFERENCE = -124;
    private static final byte CRYPTOGRAPHIC_MECHANISM = -128;

    public MseSetSignatureKeyApduCommand(byte by, CryptographicMechanism cryptographicMechanism, byte by2) {
        super(by, (byte)34, (byte)65, (byte)-74, MseSetSignatureKeyApduCommand.buidData(cryptographicMechanism, by2), null);
    }

    private static byte[] buidData(CryptographicMechanism cryptographicMechanism, byte by) {
        if (cryptographicMechanism == null) {
            throw new IllegalArgumentException("El mecanismo criptografico no puede ser nulo");
        }
        return new byte[]{-128, 1, cryptographicMechanism.getValue(), -124, 1, by};
    }

    public static enum CryptographicMechanism {
        RSASSA_PSS_SHA1(1),
        RSASSA_PKCS1v1_5_SHA1(2),
        RSASSA_PKCS1v1_5_MD5(4);

        private final byte value;

        private CryptographicMechanism(byte by) {
            this.value = by;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

