/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardConnectionListener;
import es.gob.jmulticard.apdu.connection.cwa14890.ApduEncrypter;
import es.gob.jmulticard.apdu.connection.cwa14890.CipheredApdu;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksum;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.card.cwa14890.Cwa14890Card;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class Cwa14890OneConnection
implements ApduConnection {
    private static final StatusWord INVALID_CRYPTO_CHECKSUM = new StatusWord(102, -120);
    private static final byte MSB_INCORRECT_LE = 108;
    private static final byte[] SECURE_CHANNEL_KENC_AUX = new byte[]{0, 0, 0, 1};
    private static final byte[] SECURE_CHANNEL_KMAC_AUX = new byte[]{0, 0, 0, 2};
    private static final String SHA1_ALGORITHM_NAME = "SHA1";
    private final CryptoHelper cryptoHelper;
    private final Cwa14890Card card;
    private final ApduConnection subConnection;
    private byte[] kenc = null;
    private byte[] kmac = null;
    private byte[] ssc = null;
    private boolean openState = false;

    public Cwa14890OneConnection(Cwa14890Card cwa14890Card, ApduConnection apduConnection, CryptoHelper cryptoHelper) {
        if (cwa14890Card == null) {
            throw new IllegalArgumentException("No se ha proporcionado la tarjeta CWA-14890 con la que abrir el canal seguro");
        }
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("CryptoHelper no puede ser nulo");
        }
        this.card = cwa14890Card;
        this.subConnection = apduConnection;
        this.cryptoHelper = cryptoHelper;
    }

    @Override
    public void open() throws ApduConnectionException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        RSAPublicKey rSAPublicKey;
        ApduConnection apduConnection = this.subConnection;
        if (!(apduConnection instanceof Cwa14890OneConnection)) {
            if (apduConnection.isOpen()) {
                apduConnection.reset();
            } else {
                apduConnection.open();
            }
        }
        byte[] byArray4 = this.getPaddedSerial();
        try {
            this.card.verifyCaIntermediateIcc();
            this.card.verifyIcc();
        }
        catch (SecurityException securityException) {
            apduConnection.close();
            throw new IllegalStateException("Condicion de seguridad no satisfecha en la validacion de los certificados CWA-14890: " + securityException);
        }
        catch (CertificateException certificateException) {
            apduConnection.close();
            throw new IllegalStateException("No se han podido tratar los certificados CWA-14890: " + certificateException);
        }
        catch (IOException iOException) {
            apduConnection.close();
            throw new IllegalStateException("No se han podido validar los certificados CWA-14890: " + iOException);
        }
        try {
            rSAPublicKey = (RSAPublicKey)this.cryptoHelper.generateCertificate(this.card.getIccCertEncoded()).getPublicKey();
        }
        catch (CertificateException certificateException) {
            apduConnection.close();
            throw new ApduConnectionException("No se pudo obtener la clave publica del certificado de componente", certificateException);
        }
        catch (IOException iOException) {
            apduConnection.close();
            throw new ApduConnectionException("No se pudo leer certificado de componente", iOException);
        }
        try {
            this.card.verifyIfdCertificateChain();
        }
        catch (Exception exception) {
            apduConnection.close();
            throw new ApduConnectionException("Error al verificar la cadena de certificados del controlador", exception);
        }
        try {
            byArray3 = this.cryptoHelper.generateRandomBytes(8);
        }
        catch (IOException iOException) {
            apduConnection.close();
            throw new SecureChannelException("No se pudo generar el array de aleatorios", iOException);
        }
        try {
            byArray2 = this.internalAuthentication(byArray3, rSAPublicKey);
        }
        catch (Exception exception) {
            apduConnection.close();
            throw new ApduConnectionException("Error durante el proceso de autenticacion interna de la tarjeta", exception);
        }
        byte[] byArray5 = this.card.getChallenge();
        try {
            byArray = this.externalAuthentication(byArray4, byArray5, rSAPublicKey);
        }
        catch (Exception exception) {
            apduConnection.close();
            throw new ApduConnectionException("Error durante el proceso de autenticacion externa de la tarjeta", exception);
        }
        byte[] byArray6 = HexUtils.xor(byArray2, byArray);
        try {
            this.kenc = this.generateKenc(byArray6);
        }
        catch (IOException iOException) {
            apduConnection.close();
            throw new ApduConnectionException("Error al generar la clave KEnc para el tratamiento del canal seguro", iOException);
        }
        try {
            this.kmac = this.generateKmac(byArray6);
        }
        catch (IOException iOException) {
            apduConnection.close();
            throw new ApduConnectionException("Error al generar la clave KMac para el tratamiento del canal seguro", iOException);
        }
        this.ssc = Cwa14890OneConnection.generateSsc(byArray3, byArray5);
        this.openState = true;
    }

    private byte[] generateKenc(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length + SECURE_CHANNEL_KENC_AUX.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(SECURE_CHANNEL_KENC_AUX, 0, byArray2, byArray.length, SECURE_CHANNEL_KENC_AUX.length);
        byte[] byArray3 = new byte[16];
        System.arraycopy(this.cryptoHelper.digest(SHA1_ALGORITHM_NAME, byArray2), 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private byte[] generateKmac(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length + SECURE_CHANNEL_KMAC_AUX.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(SECURE_CHANNEL_KMAC_AUX, 0, byArray2, byArray.length, SECURE_CHANNEL_KMAC_AUX.length);
        byte[] byArray3 = new byte[16];
        System.arraycopy(this.cryptoHelper.digest(SHA1_ALGORITHM_NAME, byArray2), 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private static byte[] generateSsc(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, 4, byArray3, 0, 4);
        System.arraycopy(byArray, 4, byArray3, 4, 4);
        return byArray3;
    }

    public byte[] internalAuthentication(byte[] byArray, RSAPublicKey rSAPublicKey) throws SecureChannelException, ApduConnectionException, IOException {
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        try {
            this.card.setKeysToAuthentication(this.card.getChrCCvIfd(), this.card.getRefIccPrivateKey());
        }
        catch (Exception exception) {
            throw new SecureChannelException("Error durante el establecimiento de la clave publica de Terminal y la privada de componente para su atenticacion", exception);
        }
        byte[] byArray5 = this.card.getInternalAuthenticateMessage(byArray, this.card.getChrCCvIfd());
        byte[] byArray6 = byArray4 = this.cryptoHelper.rsaDecrypt(byArray5, this.card.getIfdPrivateKey());
        byte[] byArray7 = this.cryptoHelper.rsaEncrypt(byArray6, rSAPublicKey);
        if (byArray7[0] != 106 || byArray7[byArray7.length - 1] != -68) {
            byArray3 = rSAPublicKey.getModulus().subtract(new BigInteger(byArray4)).toByteArray();
            byArray2 = new byte[128];
            if (byArray3.length > 128 && byArray3[0] == 0) {
                System.arraycopy(byArray3, 1, byArray2, 0, byArray3.length - 1);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            }
            byArray7 = this.cryptoHelper.rsaEncrypt(byArray2, rSAPublicKey);
            if (byArray7[0] != 106 || byArray7[byArray7.length - 1] != -68) {
                throw new SecureChannelException("Error en la autenticacion interna para el establecimiento del canal seguro. El mensaje descifrado es: " + HexUtils.hexify(byArray7, true));
            }
        }
        byArray3 = new byte[74];
        System.arraycopy(byArray7, 1, byArray3, 0, byArray3.length);
        byArray2 = new byte[32];
        System.arraycopy(byArray7, 75, byArray2, 0, byArray2.length);
        byte[] byArray8 = new byte[20];
        System.arraycopy(byArray7, 107, byArray8, 0, byArray8.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(this.card.getChrCCvIfd());
        byte[] byArray9 = this.cryptoHelper.digest(SHA1_ALGORITHM_NAME, byteArrayOutputStream.toByteArray());
        if (!HexUtils.arrayEquals(byArray8, byArray9)) {
            throw new SecureChannelException("Error en la comprobacion de la clave de autenticacion interna. Se obtuvo el hash '" + HexUtils.hexify(byArray9, false) + "' cuando se esperaba:" + HexUtils.hexify(byArray8, false));
        }
        return byArray2;
    }

    private byte[] externalAuthentication(byte[] byArray, byte[] byArray2, RSAPublicKey rSAPublicKey) throws IOException {
        byte[] byArray3 = this.cryptoHelper.generateRandomBytes(74);
        byte[] byArray4 = this.cryptoHelper.generateRandomBytes(32);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray4);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        byte[] byArray5 = this.cryptoHelper.digest(SHA1_ALGORITHM_NAME, byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(106);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray4);
        byteArrayOutputStream.write(byArray5);
        byteArrayOutputStream.write(-68);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        RSAPrivateKey rSAPrivateKey = this.card.getIfdPrivateKey();
        byte[] byArray7 = this.cryptoHelper.rsaDecrypt(byArray6, rSAPrivateKey);
        BigInteger bigInteger = new BigInteger(1, byArray7);
        byte[] byArray8 = rSAPrivateKey.getModulus().subtract(bigInteger).min(bigInteger).toByteArray();
        byte[] byArray9 = this.cryptoHelper.rsaEncrypt(byArray8, rSAPublicKey);
        boolean bl = this.card.externalAuthentication(byArray9);
        if (!bl) {
            throw new SecureChannelException("Error durante la autenticacion externa del canal seguro");
        }
        return byArray4;
    }

    private byte[] getPaddedSerial() throws ApduConnectionException {
        byte[] byArray = this.card.getSerialNumber();
        byte[] byArray2 = byArray;
        if (byArray2.length < 8) {
            int n;
            byArray2 = new byte[8];
            for (n = 0; n < 8 - byArray.length; ++n) {
                byArray2[n] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        }
        return byArray2;
    }

    @Override
    public void close() throws ApduConnectionException {
        if (this.openState) {
            this.subConnection.close();
            this.openState = false;
        }
    }

    @Override
    public ResponseApdu transmit(CommandApdu commandApdu) throws ApduConnectionException {
        CipheredApdu cipheredApdu;
        try {
            this.ssc = Cwa14890OneConnection.increment(this.ssc);
            cipheredApdu = ApduEncrypter.protectAPDU(commandApdu, this.kenc, this.kmac, this.ssc, this.cryptoHelper);
        }
        catch (IOException iOException) {
            throw new SecureChannelException("Error en la encriptacion de la APDU para su envio por el canal seguro", iOException);
        }
        ResponseApdu responseApdu = this.subConnection.transmit(cipheredApdu);
        if (INVALID_CRYPTO_CHECKSUM.equals(responseApdu.getStatusWord())) {
            throw new InvalidCryptographicChecksum();
        }
        if (!responseApdu.isOk()) {
            throw new SecureChannelException("Error en la APDU de respuesta cifrada con el codigo " + responseApdu.getStatusWord());
        }
        try {
            this.ssc = Cwa14890OneConnection.increment(this.ssc);
            ResponseApdu responseApdu2 = ApduEncrypter.decryptResponseApdu(responseApdu, this.kenc, this.ssc, this.kmac, this.cryptoHelper);
            if (responseApdu2.getStatusWord().getMsb() == 108) {
                commandApdu.setLe(responseApdu2.getStatusWord().getLsb());
                return this.transmit(commandApdu);
            }
            return responseApdu2;
        }
        catch (Exception exception) {
            throw new ApduConnectionException("Error en la desencriptacion de la APDU de respuesta recibida por el canal seguro", exception);
        }
    }

    @Override
    public byte[] reset() throws ApduConnectionException {
        this.openState = false;
        byte[] byArray = this.subConnection.reset();
        this.open();
        return byArray;
    }

    @Override
    public void addCardConnectionListener(CardConnectionListener cardConnectionListener) {
        this.subConnection.addCardConnectionListener(cardConnectionListener);
    }

    @Override
    public void removeCardConnectionListener(CardConnectionListener cardConnectionListener) {
        this.subConnection.removeCardConnectionListener(cardConnectionListener);
    }

    @Override
    public long[] getTerminals(boolean bl) throws ApduConnectionException {
        return this.subConnection.getTerminals(bl);
    }

    @Override
    public String getTerminalInfo(int n) throws ApduConnectionException {
        return this.subConnection.getTerminalInfo(n);
    }

    @Override
    public void setTerminal(int n) {
        this.subConnection.setTerminal(n);
    }

    @Override
    public boolean isOpen() {
        return this.openState && this.subConnection.isOpen();
    }

    private static byte[] increment(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = (bigInteger = bigInteger.add(BigInteger.ONE)).toByteArray();
        if (byArray2.length > 8) {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, byArray2.length - byArray3.length, byArray3, 0, byArray3.length);
            return byArray3;
        }
        if (byArray2.length < 8) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray2, 0, byArray4, byArray4.length - byArray2.length, byArray2.length);
            return byArray4;
        }
        return byArray2;
    }

    public ApduConnection getSubConnection() {
        return this.subConnection;
    }
}

