/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.apdu.CommandApdu;

final class CipheredApdu
extends CommandApdu {
    private static final byte TAG_CRYPTOGRAPHIC_CHECKSUM = -114;
    private final byte[] mac;
    private final byte[] data;

    byte[] getMac() {
        byte[] byArray = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, byArray, 0, this.mac.length);
        return byArray;
    }

    byte[] getCryptogramData() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    CipheredApdu(byte by, byte by2, byte by3, byte by4, byte[] byArray, byte[] byArray2) {
        super(by, by2, by3, by4, CipheredApdu.buildData(byArray, byArray2), null);
        this.mac = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.mac, 0, byArray2.length);
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    private static byte[] buildData(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("Ni los datos (TLV) ni el MAC pueden ser nulos");
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("El MAC debe medir exactamente cuatro octetos");
        }
        int n = byArray.length + byArray2.length + 2;
        byte[] byArray3 = new byte[n];
        if (byArray.length > 0) {
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        }
        byArray3[byArray3.length - 1] = byArray2[3];
        byArray3[byArray3.length - 2] = byArray2[2];
        byArray3[byArray3.length - 3] = byArray2[1];
        byArray3[byArray3.length - 4] = byArray2[0];
        byArray3[byArray3.length - 5] = 4;
        byArray3[byArray3.length - 6] = -114;
        return byArray3;
    }

    @Override
    public void setLe(int n) {
        throw new UnsupportedOperationException("No se puede establecer el Le en una APDU cifrada");
    }
}

