/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.CipheredApdu;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksum;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.bertlv.BerTlv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class ApduEncrypter {
    private static final byte ISO7816_PADDING_PREFIX = -128;
    private static final byte TLV_VALUE_PREFIX_TO_MAC = 1;
    private static final byte TAG_DATA_TLV = -121;
    private static final byte TAG_LE_TLV = -105;
    private static final byte TAG_SW_TLV = -103;
    private static final byte TAG_MAC_TLV = -114;
    private static final byte CLA_OF_PROTECTED_APDU = 12;

    private ApduEncrypter() {
    }

    static CipheredApdu protectAPDU(CommandApdu commandApdu, byte[] byArray, byte[] byArray2, byte[] byArray3, CryptoHelper cryptoHelper) throws IOException {
        byte[] byArray4;
        byte by = commandApdu.getCla();
        byte by2 = commandApdu.getIns();
        byte by3 = commandApdu.getP1();
        byte by4 = commandApdu.getP2();
        byte[] byArray5 = commandApdu.getData();
        Integer n = commandApdu.getLe();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray6 = new byte[]{};
        if (byArray5 != null && byArray5.length > 0) {
            int n2;
            byteArrayOutputStream.write(1);
            byArray4 = ApduEncrypter.addPadding7816(byArray5);
            byteArrayOutputStream.write(cryptoHelper.desedeEncrypt(byArray4, byArray));
            for (n2 = 0; n2 < byArray4.length; ++n2) {
                byArray4[n2] = 0;
            }
            for (n2 = 0; n2 < byArray5.length; ++n2) {
                byArray5[n2] = 0;
            }
            byArray6 = new Tlv(-121, byteArrayOutputStream.toByteArray()).getBytes();
        }
        byArray4 = new byte[]{};
        if (n != null) {
            byArray4 = new Tlv(-105, new byte[]{n.byteValue()}).getBytes();
        }
        byte[] byArray7 = new byte[byArray6.length + byArray4.length];
        System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        System.arraycopy(byArray4, 0, byArray7, byArray6.length, byArray4.length);
        by = (byte)(by | 0xC);
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(ApduEncrypter.addPadding7816(new byte[]{by, by2, by3, by4}));
        byteArrayOutputStream.write(byArray7);
        byte[] byArray8 = ApduEncrypter.addPadding7816(byteArrayOutputStream.toByteArray());
        byte[] byArray9 = ApduEncrypter.generateMac(byArray8, byArray3, byArray2, cryptoHelper);
        return new CipheredApdu(by, by2, by3, by4, byArray7, byArray9);
    }

    private static byte[] addPadding7816(byte[] byArray) {
        byte[] byArray2 = new byte[(byArray.length / 8 + 1) * 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = -128;
        for (int i = byArray.length + 1; i < byArray2.length; ++i) {
            byArray2[i] = 0;
        }
        return byArray2;
    }

    private static byte[] removePadding7816(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == -128) {
                if (i == 0) {
                    return new byte[0];
                }
                return HexUtils.subArray(byArray, 0, i);
            }
            if (byArray[i] == 0) continue;
            return byArray;
        }
        return byArray;
    }

    private static byte[] generateMac(byte[] byArray, byte[] byArray2, byte[] byArray3, CryptoHelper cryptoHelper) throws IOException {
        int n;
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray3, 0, byArray4, 0, 8);
        byte[] byArray5 = cryptoHelper.desEncrypt(byArray2, byArray4);
        for (n = 0; n < byArray.length - 8; n += 8) {
            byArray5 = cryptoHelper.desEncrypt(HexUtils.xor(byArray5, HexUtils.subArray(byArray, n, 8)), byArray4);
        }
        byte[] byArray6 = new byte[24];
        System.arraycopy(byArray3, 0, byArray6, 0, 16);
        System.arraycopy(byArray3, 0, byArray6, 16, 8);
        byte[] byArray7 = HexUtils.subArray(cryptoHelper.desedeEncrypt(HexUtils.xor(byArray5, HexUtils.subArray(byArray, n, 8)), byArray6), 0, 4);
        return byArray7;
    }

    static ResponseApdu decryptResponseApdu(ResponseApdu responseApdu, byte[] byArray, byte[] byArray2, byte[] byArray3, CryptoHelper cryptoHelper) throws IOException {
        if (!responseApdu.isOk()) {
            return new ResponseApdu(responseApdu.getStatusWord().getBytes());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseApdu.getData());
        BerTlv berTlv = null;
        BerTlv berTlv2 = null;
        BerTlv berTlv3 = null;
        try {
            BerTlv berTlv4 = BerTlv.getInstance(byteArrayInputStream);
            if (berTlv4.getTag().getTagValue() == -121) {
                berTlv = berTlv4;
                berTlv4 = BerTlv.getInstance(byteArrayInputStream);
            }
            if (berTlv4.getTag().getTagValue() == -103) {
                berTlv2 = berTlv4;
                berTlv4 = BerTlv.getInstance(byteArrayInputStream);
            }
            if (berTlv4.getTag().getTagValue() == -114) {
                berTlv3 = berTlv4;
            }
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new ApduConnectionException("Error en el formato de la respuesta remitida por el canal seguro", negativeArraySizeException);
        }
        if (berTlv3 == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del MAC en la APDU");
        }
        if (berTlv2 == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del StatusWord en la APDU cifrada");
        }
        int n = (berTlv != null ? 2 + berTlv.getValue().length / 128 + berTlv.getValue().length : 0) + 1 + 1 + berTlv2.getValue().length;
        ApduEncrypter.verifyMac(HexUtils.subArray(responseApdu.getData(), 0, n), berTlv3.getValue(), byArray2, byArray3, cryptoHelper);
        if (berTlv == null) {
            return new ResponseApdu(berTlv2.getValue());
        }
        byte[] byArray4 = ApduEncrypter.removePadding7816(cryptoHelper.desedeDecrypt(HexUtils.subArray(berTlv.getValue(), 1, berTlv.getValue().length - 1), byArray));
        byte[] byArray5 = new byte[byArray4.length + berTlv2.getValue().length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(berTlv2.getValue(), 0, byArray5, byArray4.length, berTlv2.getValue().length);
        return new ResponseApdu(byArray5);
    }

    private static void verifyMac(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, CryptoHelper cryptoHelper) {
        byte[] byArray5;
        try {
            byArray5 = ApduEncrypter.generateMac(ApduEncrypter.addPadding7816(byArray), byArray3, byArray4, cryptoHelper);
        }
        catch (IOException iOException) {
            throw new SecurityException("No se pudo calcular el MAC teorico de la respuesta del DNIe para su verificacion");
        }
        if (!HexUtils.arrayEquals(byArray2, byArray5)) {
            throw new InvalidCryptographicChecksum();
        }
    }
}

