/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu;

import es.gob.jmulticard.apdu.Apdu;
import java.io.ByteArrayOutputStream;

public class CommandApdu
extends Apdu {
    private final byte cla;
    private final byte ins;
    private final byte p1;
    private final byte p2;
    private Integer le;
    private final byte[] body;

    public CommandApdu(byte by, byte by2, byte by3, byte by4, byte[] byArray, Integer n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.cla = by;
        byteArrayOutputStream.write(by);
        this.ins = by2;
        byteArrayOutputStream.write(by2);
        this.p1 = by3;
        byteArrayOutputStream.write(by3);
        this.p2 = by4;
        byteArrayOutputStream.write(by4);
        if (byArray == null) {
            this.body = null;
        } else {
            this.body = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.body, 0, byArray.length);
            byteArrayOutputStream.write(Integer.valueOf(String.valueOf(this.body.length)).byteValue());
            if (this.body.length > 0) {
                try {
                    byteArrayOutputStream.write(this.body);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("No se pueden tratar los datos de la APDU: " + exception);
                }
            }
        }
        this.le = n;
        if (n != null) {
            byteArrayOutputStream.write(n.byteValue());
        }
        this.setBytes(byteArrayOutputStream.toByteArray());
    }

    public byte getCla() {
        return this.cla;
    }

    public byte[] getData() {
        if (this.body == null) {
            return null;
        }
        byte[] byArray = new byte[this.body.length];
        System.arraycopy(this.body, 0, byArray, 0, this.body.length);
        return byArray;
    }

    public byte getIns() {
        return this.ins;
    }

    public Integer getLe() {
        return this.le;
    }

    public byte getP1() {
        return this.p1;
    }

    public byte getP2() {
        return this.p2;
    }

    public void setLe(int n) {
        this.le = Integer.valueOf(String.valueOf(n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.cla);
        byteArrayOutputStream.write(this.ins);
        byteArrayOutputStream.write(this.p1);
        byteArrayOutputStream.write(this.p2);
        if (this.body != null && this.body.length > 0) {
            try {
                byteArrayOutputStream.write(this.body);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("No se pueden tratar los datos de la APDU: " + exception);
            }
        }
        byteArrayOutputStream.write(n);
        this.setBytes(byteArrayOutputStream.toByteArray());
    }
}

