/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard;

import java.math.BigInteger;

public final class HexUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtils() {
    }

    public static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        return HexUtils.arrayEquals(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static boolean arrayEquals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4 || byArray.length < n + n2 || byArray2.length < n3 + n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)HexUtils.getUnsignedInt(byArray, n);
    }

    public static int getUnsignedInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static String hexify(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        for (byte by : byArray) {
            if (bl && n > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(HEX_CHARS[by >> 4 & 0xF]);
            stringBuffer.append(HEX_CHARS[by & 0xF]);
            if (++n != 16) continue;
            if (bl) {
                stringBuffer.append('\n');
            }
            n = 0;
        }
        return stringBuffer.toString();
    }

    public static byte[] subArray(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        if (byArray.length < n + n2) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byArray3 = new BigInteger(1, byArray).xor(new BigInteger(1, byArray2)).toByteArray();
        if (byArray3.length >= (byArray4 = new byte[byArray.length]).length) {
            System.arraycopy(byArray3, byArray3.length - byArray4.length, byArray4, 0, byArray4.length);
        } else {
            System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
        }
        return byArray4;
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[3 - i] = (byte)(n >>> n2 & 0xFF);
        }
        return byArray;
    }
}

