/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.ui.AOUIManager;
import es.gob.afirma.ui.core.jse.CertificateSelectionDialog;
import es.gob.afirma.ui.core.jse.FileExtensionFilter;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JSEUIManager
implements AOUIManager {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int ASCII_LOWER_INDEX = 32;
    private static final int ASCII_HIGHER_INDEX = 126;

    @Override
    public final char[] getPassword(String string, Object object) {
        return this.getPassword(string, null, null, false, object);
    }

    @Override
    public final char[] getPassword(String string, Object object, String string2, boolean bl, Object object2) {
        final JPasswordField jPasswordField = new JPasswordField(10);
        if (string2 != null) {
            jPasswordField.setDocument(new JTextFieldFilter(string2, bl));
        }
        JLabel jLabel = new JLabel(string != null ? string : JSEUIMessages.getString("JSEUIManager.24"));
        jLabel.setMinimumSize(new Dimension(jLabel.getFontMetrics(jLabel.getFont()).stringWidth(string), jLabel.getSize().height));
        jLabel.setLabelFor(jPasswordField);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPasswordField, gridBagConstraints);
        Icon icon = null;
        if (object instanceof Icon) {
            icon = (Icon)object;
        }
        JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2, icon){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                jPasswordField.requestFocusInWindow();
            }
        };
        Component component = null;
        if (object2 instanceof Component) {
            component = (Component)object2;
        }
        jOptionPane.createDialog(component, JSEUIMessages.getString("JSEUIManager.24")).setVisible(true);
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return new char[0];
        }
        if ((Integer)object3 == 0) {
            return jPasswordField.getPassword();
        }
        throw new AOCancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    @Override
    public final Object showInputDialog(Object object, Object object2, String string, int n, Object object3, Object[] objectArray, Object object4) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        Icon icon = null;
        if (object3 instanceof Icon) {
            icon = (Icon)object3;
        }
        if (objectArray == null) {
            return JOptionPane.showInputDialog(component, object2, string, n);
        }
        return JOptionPane.showInputDialog(component, object2, string, n, icon, objectArray, object4);
    }

    @Override
    public final Object showCertificateSelectionDialog(Object object, NameCertificateBean[] nameCertificateBeanArray) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        return new CertificateSelectionDialog(nameCertificateBeanArray, component).showDialog();
    }

    @Override
    public final int showConfirmDialog(Object object, Object object2, String string, int n, int n2) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        return JOptionPane.showConfirmDialog(component, object2, string, n, n2);
    }

    @Override
    public void showMessageDialog(Object object, Object object2, String string, int n) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        JOptionPane.showMessageDialog(component, object2, string, n);
    }

    @Override
    public final int getPlainMessageCode() {
        return -1;
    }

    @Override
    public final int getYesNoOptionCode() {
        return 0;
    }

    @Override
    public final int getWarningMessageCode() {
        return 2;
    }

    @Override
    public final int getYesOptionCode() {
        return 0;
    }

    @Override
    public final int getNoOptionCode() {
        return 1;
    }

    @Override
    public final int getOkCancelOptionCode() {
        return 2;
    }

    @Override
    public final int getOkOptionCode() {
        return 0;
    }

    @Override
    public final int getInformationMessageCode() {
        return 1;
    }

    @Override
    public final int getErrorMessageCode() {
        return 0;
    }

    @Override
    public final int getQuestionMessageCode() {
        return 3;
    }

    @Override
    public File[] getLoadFiles(String string, String string2, String string3, String[] stringArray, String string4, boolean bl, boolean bl2, Object object) {
        int n;
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        if (string3 != null) {
            if (string2 != null) {
                jFileChooser.setSelectedFile(new File(string2, string3));
            } else {
                jFileChooser.setSelectedFile(new File(string3));
            }
        }
        jFileChooser.setMultiSelectionEnabled(bl2);
        if (string != null && string.length() > 0) {
            jFileChooser.setDialogTitle(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            jFileChooser.setFileFilter(new ExtFilter(stringArray, string4));
        }
        if ((n = jFileChooser.showOpenDialog(component)) == 0) {
            File[] fileArray = bl2 ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            return fileArray;
        }
        throw new AOCancelledOperationException();
    }

    @Override
    public File saveDataToFile(byte[] byArray, String string, String string2, String string3, String[] stringArray, String string4, Object object) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se introdujeron datos que almacenar");
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        File file = null;
        boolean bl = true;
        block6: while (bl) {
            bl = false;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.getAccessibleContext().setAccessibleName(JSEUIMessages.getString("JSEUIManager.81"));
            jFileChooser.getAccessibleContext().setAccessibleDescription(JSEUIMessages.getString("JSEUIManager.82"));
            jFileChooser.setToolTipText(JSEUIMessages.getString("JSEUIManager.81"));
            if (string != null) {
                jFileChooser.setDialogTitle(string);
            }
            if (string3 != null && string2 != null) {
                jFileChooser.setSelectedFile(new File(string2, string3));
            } else if (string3 != null) {
                jFileChooser.setSelectedFile(new File(string3));
            } else if (string2 != null) {
                jFileChooser.setCurrentDirectory(new File(string2));
            }
            if (stringArray != null && stringArray.length > 0) {
                jFileChooser.setFileFilter(new FileExtensionFilter(stringArray, string4));
            }
            int n = 0;
            int n2 = jFileChooser.showSaveDialog(component);
            switch (n2) {
                case 1: {
                    throw new AOCancelledOperationException();
                }
                case 0: {
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2.exists() && (n = JOptionPane.showConfirmDialog(component, JSEUIMessages.getString("JSEUIManager.77", file2.getAbsolutePath()), JSEUIMessages.getString("JSEUIManager.85"), 1)) == 2) {
                        LOGGER.info("Se ha cancelado la operacion de guardado.");
                        return null;
                    }
                    if (n == 1) {
                        bl = true;
                        continue block6;
                    }
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        fileOutputStream.write(byArray);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No se pudo guardar la informacion en el fichero indicado: " + exception);
                        JOptionPane.showMessageDialog(component, JSEUIMessages.getString("JSEUIManager.88"), JSEUIMessages.getString("JSEUIManager.89"), 0);
                        bl = true;
                    }
                    return file2;
                }
            }
            throw new IOException("Error al seleccionar el fichero: " + n2);
        }
        return file;
    }

    private static final class ExtFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final String[] extensions;
        private final String description;

        public ExtFilter(String[] stringArray, String string) {
            if (stringArray == null || stringArray.length < 1) {
                throw new IllegalArgumentException("No se puede crear un filtro vacio");
            }
            this.extensions = (String[])stringArray.clone();
            this.description = string != null ? string : JSEUIMessages.getString("JSEUIManager.0");
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = ExtFilter.getExtension(file);
            for (String string2 : this.extensions) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return "";
        }
    }

    public static final class JTextFieldASCIIFilter
    extends PlainDocument {
        private static final long serialVersionUID = 1979726487852842735L;
        private boolean beep = false;

        public JTextFieldASCIIFilter(boolean bl) {
            this.beep = bl;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) >= ' ' && string.charAt(i) <= '~') continue;
                if (this.beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    private static final class JTextFieldFilter
    extends PlainDocument {
        private static final long serialVersionUID = -5746396042117084830L;
        private String acceptedChars = null;
        private boolean beep = false;

        JTextFieldFilter(String string, boolean bl) {
            this.beep = bl;
            this.acceptedChars = string;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (this.acceptedChars.indexOf(String.valueOf(string.charAt(i))) != -1) continue;
                if (this.beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

