/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import com.sun.jndi.toolkit.dir.SearchFilter;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.ui.core.jse.CertificateUtils;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class CertificateSelectionPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 6288294705582545804L;
    private static final String VERDANA_FONT_NAME = "Verdana";
    private static final Font TITLE_FONT = new Font("Verdana", 1, 14);
    private static final Font TEXT_FONT = new Font("Verdana", 0, 12);
    private static final int CERT_LIST_ELEMENT_HEIGHT = 86;
    private JList certList;
    private int selectedIndex;
    private final NameCertificateBean[] certificateBeans;

    CertificateSelectionPanel(NameCertificateBean[] nameCertificateBeanArray) {
        this.certificateBeans = nameCertificateBeanArray == null ? new NameCertificateBean[]{} : (NameCertificateBean[])nameCertificateBeanArray.clone();
        this.createUI();
    }

    private void createUI() {
        JComponent jComponent;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(13, 15, 8, 15);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(JSEUIMessages.getString("CertificateSelectionPanel.0"));
        jLabel.setFont(TITLE_FONT);
        jLabel.setForeground(Color.decode("0x0033BC"));
        this.add((Component)jLabel, gridBagConstraints);
        if (this.certificateBeans.length == 1) {
            gridBagConstraints.insets = new Insets(0, 15, 4, 15);
            ++gridBagConstraints.gridy;
            jComponent = new JTextPane();
            ((JEditorPane)jComponent).setText(JSEUIMessages.getString("CertificateSelectionPanel.1"));
            jComponent.setFont(TEXT_FONT);
            jComponent.setBorder(null);
            jComponent.setPreferredSize(new Dimension(370, 40));
            this.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(4, 15, 8, 15);
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(8, 18, 13, 18);
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        Vector<JComponent> vector = new Vector<JComponent>();
        for (NameCertificateBean nameCertificateBean : this.certificateBeans) {
            try {
                jComponent = CertificateSelectionPanel.createCertLine(nameCertificateBean.getName(), nameCertificateBean.getCertificate());
            }
            catch (Exception exception) {
                continue;
            }
            jComponent.setPreferredSize(new Dimension(0, 86));
            vector.add(jComponent);
        }
        this.certList = new JList();
        this.certList.setCellRenderer(new CertListCellRendered());
        this.certList.setListData(vector);
        this.certList.setVisibleRowCount(Math.max(Math.min(4, vector.size()), 1));
        if (vector.size() > 0) {
            this.certList.setSelectedIndex(0);
        }
        JScrollPane jScrollPane = new JScrollPane(this.certList, 20, 31);
        this.certList.addListSelectionListener(this);
        CertLinkMouseListener certLinkMouseListener = new CertLinkMouseListener();
        this.certList.addMouseMotionListener(certLinkMouseListener);
        this.certList.addMouseListener(certLinkMouseListener);
        this.certList.setSelectedIndex(0);
        this.selectedIndex = 0;
        jScrollPane.setBorder(null);
        jScrollPane.setPreferredSize(new Dimension(435, 86 * this.certList.getVisibleRowCount()));
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    void selectCertificateList() {
        this.certList.requestFocusInWindow();
    }

    String getSelectedCertificate() {
        return this.selectedIndex == -1 ? null : this.certificateBeans[this.selectedIndex].getAlias();
    }

    void addCertificateListMouseListener(MouseListener mouseListener) {
        this.certList.addMouseListener(mouseListener);
    }

    private static CertificateLine createCertLine(String string, X509Certificate x509Certificate) {
        CertificateLine certificateLine = new CertificateLine(string, x509Certificate);
        certificateLine.setFocusable(true);
        return certificateLine;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedIndex = this.certList.getSelectedIndex();
    }

    private final class CertLinkMouseListener
    extends MouseAdapter {
        private boolean entered = false;

        CertLinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && ((CertificateLine)((JList)mouseEvent.getSource()).getSelectedValue()).getCertificateLinkBounds().contains(mouseEvent.getX(), mouseEvent.getY() % 86)) {
                try {
                    CertificateUtils.openCert(CertificateSelectionPanel.this, ((CertificateLine)((JList)mouseEvent.getSource()).getSelectedValue()).getCertificate());
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (((CertificateLine)((JList)mouseEvent.getSource()).getSelectedValue()).getCertificateLinkBounds().contains(mouseEvent.getX(), mouseEvent.getY() % 86)) {
                if (!this.entered) {
                    ((JList)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                    this.entered = true;
                }
            } else if (this.entered) {
                ((JList)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.entered = false;
            }
        }
    }

    private static final class CertListCellRendered
    implements ListCellRenderer {
        CertListCellRendered() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CertificateLine certificateLine = (CertificateLine)object;
            if (bl) {
                certificateLine.setBackground(Color.decode("0xD9EAFF"));
                certificateLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.WHITE, 1), BorderFactory.createLineBorder(Color.decode("0x84ACDD"), 1)));
            } else {
                certificateLine.setBackground(Color.WHITE);
                certificateLine.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
            }
            return certificateLine;
        }
    }

    private static class CertificateLine
    extends JPanel {
        private static final long serialVersionUID = 5012625058876812352L;
        private static final Font SUBJECT_FONT = new Font("Verdana", 1, 14);
        private static final Font DETAILS_FONT = new Font("Verdana", 0, 11);
        private JLabel propertiesLink = null;
        private final String friendlyName;
        private final X509Certificate cert;

        CertificateLine(String string, X509Certificate x509Certificate) {
            this.friendlyName = string;
            this.cert = x509Certificate;
            this.createUI();
        }

        private static boolean isDNIeCert(X509Certificate x509Certificate) {
            try {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                for (Rdn rdn : new LdapName(x509Certificate.getIssuerDN().toString()).getRdns()) {
                    basicAttributes.put(rdn.getType(), rdn.getValue());
                }
                return new SearchFilter("(&(cn=AC DNIE *)(ou=DNIE)(o=DIRECCION GENERAL DE LA POLICIA)(c=ES))").check(basicAttributes);
            }
            catch (Exception exception) {
                return false;
            }
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        @Override
        public String toString() {
            return this.friendlyName;
        }

        private void createUI() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 4;
            URL uRL = CertificateLine.isDNIeCert(this.cert) ? CertificateSelectionPanel.class.getClassLoader().getResource("resources/dnieicon.png") : CertificateSelectionPanel.class.getClassLoader().getResource("resources/certicon.png");
            JLabel jLabel = uRL != null ? new JLabel(new ImageIcon(uRL)) : new JLabel();
            gridBagConstraints.insets = new Insets(2, 2, 2, 5);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            JLabel jLabel2 = new JLabel(this.friendlyName);
            jLabel2.setFont(SUBJECT_FONT);
            this.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            JLabel jLabel3 = new JLabel(JSEUIMessages.getString("CertificateSelectionPanel.2") + AOUtil.getCN(this.cert.getIssuerDN().toString()));
            jLabel3.setFont(DETAILS_FONT);
            this.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            JLabel jLabel4 = new JLabel(JSEUIMessages.getString("CertificateSelectionPanel.3", new String[]{CertificateLine.formatDate(this.cert.getNotBefore()), CertificateLine.formatDate(this.cert.getNotAfter())}));
            jLabel4.setFont(DETAILS_FONT);
            this.add((Component)jLabel4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.propertiesLink = new JLabel("<html><u>" + JSEUIMessages.getString("CertificateSelectionPanel.5") + "</u></html>");
            this.propertiesLink.setFont(DETAILS_FONT);
            this.add((Component)this.propertiesLink, gridBagConstraints);
        }

        private static String formatDate(Date date) {
            return new SimpleDateFormat("dd/MM/yyyy").format(date);
        }

        Rectangle getCertificateLinkBounds() {
            return this.propertiesLink.getBounds();
        }
    }
}

