/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.ui.core.jse.CertificateSelectionPanel;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

final class CertificateSelectionDialog
extends MouseAdapter {
    private final CertificateSelectionPanel csd;
    private final JOptionPane optionPane;
    private final Component parent;

    CertificateSelectionDialog(NameCertificateBean[] nameCertificateBeanArray, Component component) {
        if (nameCertificateBeanArray == null || nameCertificateBeanArray.length == 0) {
            throw new IllegalArgumentException("El listado de certificados no puede ser nulo ni vacio");
        }
        this.csd = new CertificateSelectionPanel((NameCertificateBean[])nameCertificateBeanArray.clone());
        this.parent = component;
        this.optionPane = nameCertificateBeanArray.length > 1 ? new CertOptionPane(this.csd) : new JOptionPane();
        this.csd.addCertificateListMouseListener(this);
        this.optionPane.setMessage(this.csd);
        this.optionPane.setMessageType(-1);
        this.optionPane.setOptionType(2);
    }

    String showDialog() {
        JDialog jDialog = this.optionPane.createDialog(this.parent, JSEUIMessages.getString("CertificateSelectionDialog.0"));
        jDialog.setBackground(Color.WHITE);
        jDialog.setModal(true);
        jDialog.setVisible(true);
        if (this.optionPane.getValue() == null || (Integer)this.optionPane.getValue() != 0) {
            jDialog.dispose();
            return null;
        }
        String string = this.csd.getSelectedCertificate();
        jDialog.dispose();
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.optionPane != null) {
            this.optionPane.setValue(0);
        }
    }

    private static final class CertOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1L;
        private final CertificateSelectionPanel selectionPanel;

        CertOptionPane(CertificateSelectionPanel certificateSelectionPanel) {
            this.selectionPanel = certificateSelectionPanel;
        }

        @Override
        public void selectInitialValue() {
            this.selectionPanel.selectCertificateList();
        }
    }
}

