/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.ui.core.jse.JSEUIManager;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;

public final class AWTUIManager
extends JSEUIManager {
    @Override
    public File saveDataToFile(byte[] byArray, String string, String string2, String string3, final String[] stringArray, String string4, Object object) throws IOException {
        FileDialog fileDialog = new FileDialog(object instanceof Frame ? (Frame)object : null, string, 1);
        if (string3 != null && string2 != null && Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            fileDialog.setFile(new File(string2, string3).getAbsolutePath());
        } else {
            if (string3 != null) {
                fileDialog.setFile(string3);
            }
            if (string2 != null) {
                fileDialog.setDirectory(string2);
            }
        }
        if (stringArray != null) {
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    for (String string2 : stringArray) {
                        if (!string.endsWith(string2)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
        return file;
    }

    @Override
    public File[] getLoadFiles(String string, String string2, String string3, final String[] stringArray, String string4, boolean bl, boolean bl2, Object object) {
        Object object2;
        FileDialog fileDialog = new FileDialog(object instanceof Frame ? (Frame)object : null, string);
        fileDialog.setMode(0);
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        if (bl2) {
            try {
                object2 = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
                object2.invoke((Object)fileDialog, bl2);
            }
            catch (Exception exception) {
                LOGGER.warning("No es posible utilizar la seleccion multiple de ficheros con los dialogos del sistema con versiones anteriores de Java 7, se utilizara Swing");
                return super.getLoadFiles(string, string2, string3, stringArray, string4, bl, bl2, object);
            }
        }
        if (string3 != null) {
            fileDialog.setFile(string3);
        }
        if (stringArray != null && stringArray.length > 0) {
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                object2 = stringArray[0];
                if (!object2.startsWith("*.")) {
                    object2 = object2.startsWith(".") ? "*" + (String)object2 : "*." + (String)object2;
                }
                fileDialog.setFile((String)object2);
            } else {
                fileDialog.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        for (String string2 : stringArray) {
                            if (!string.endsWith(string2)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        if (bl2 && AWTUIManager.isJava7()) {
            try {
                Method method = FileDialog.class.getMethod("getFiles", new Class[0]);
                object2 = (File[])method.invoke((Object)fileDialog, new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.warning("Error de reflexion al recuperar la seleccion multiple del dialogo de carga, se devolvera un unico fichero: " + exception);
                object2 = new File[]{new File(fileDialog.getFile())};
            }
            if (object2 == null) {
                object2 = new File[]{};
            }
            return object2;
        }
        return new File[]{new File(fileDialog.getDirectory(), fileDialog.getFile())};
    }

    private static boolean isJava7() {
        return System.getProperty("java.version").startsWith("1.7");
    }
}

