/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xmldsig;

import com.sun.org.apache.xerces.internal.dom.DOMOutputImpl;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.xml.CustomUriDereferencer;
import es.gob.afirma.signers.xml.InvalidXMLException;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyle;
import es.gob.afirma.signers.xmldsig.XmlDSigUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class AOXMLDSigSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String XADESNS = "http://uri.etsi.org/01903#";
    private static final String OBJURI = "http://www.w3.org/2000/09/xmldsig#Object";
    private static final String SIGNATURE_STR = "Signature";
    private static final String MIMETYPE_STR = "MimeType";
    private static final String ENCODING_STR = "Encoding";
    private static final String REFERENCE_STR = "Reference";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String STYLE_REFERENCE_PREFIX = "StyleReference-";
    private static final String CSURI = "http://uri.etsi.org/01903#CountersignedSignature";
    private static final String AFIRMA = "AFIRMA";
    private static final String XML_SIGNATURE_PREFIX = "ds";
    private static final String DETACHED_CONTENT_ELEMENT_NAME = "CONTENT";
    private static final String DETACHED_STYLE_ELEMENT_NAME = "STYLE";
    private static final String DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String algo;
    private Document doc;

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] sign(byte[] var1_1, String var2_2, PrivateKey var3_3, Certificate[] var4_4, Properties var5_5) throws AOException {
        var6_6 = XMLConstants.SIGN_ALGOS_URI.get(var2_2);
        if (var6_6 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + var2_2 + "'");
        }
        var7_7 = var5_5 != null ? var5_5 : new Properties();
        var8_8 = var7_7.getProperty("format", "XMLDSig Enveloping");
        var9_9 = var7_7.getProperty("mode", "implicit");
        var10_10 = var7_7.getProperty("referencesDigestMethod", "http://www.w3.org/2000/09/xmldsig#sha1");
        var11_11 = var7_7.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        var12_12 = Boolean.parseBoolean(var7_7.getProperty("ignoreStyleSheets", Boolean.FALSE.toString()));
        var13_13 = Boolean.parseBoolean(var7_7.getProperty("avoidBase64Transforms", Boolean.FALSE.toString()));
        var14_14 = Boolean.parseBoolean(var7_7.getProperty("headLess", Boolean.TRUE.toString()));
        var15_15 = var7_7.getProperty("mimeType");
        var16_16 = var7_7.getProperty("encoding");
        if ("base64".equalsIgnoreCase(var16_16)) {
            var16_16 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        var17_17 = var7_7.getProperty("xmlSignaturePrefix", "ds");
        var18_18 = null;
        try {
            var18_18 = AOUtil.createURI(var7_7.getProperty("uri"));
        }
        catch (Exception var19_19) {
            // empty catch block
        }
        var19_20 = var7_7.getProperty("precalculatedHashAlgorithm");
        Utils.checkIllegalParams(var8_8, var9_9, var18_18, var19_20, false);
        if (!(var1_1 != null && var1_1.length != 0 || var8_8.equals("XMLDSig Externally Detached") && var18_18 != null)) {
            throw new AOException("No se han podido leer los datos a firmar");
        }
        var20_21 = new Hashtable<String, String>();
        var21_22 = DocumentBuilderFactory.newInstance();
        var21_22.setNamespaceAware(true);
        var23_23 = "CONTENT-" + UUID.randomUUID().toString() + "-" + "CONTENT";
        var24_24 = "STYLE-" + UUID.randomUUID().toString() + "-" + "STYLE";
        var25_25 = false;
        var26_26 = false;
        var27_27 = new XmlStyle();
        if (var9_9.equals("implicit")) {
            try {
                var28_28 = var21_22.newDocumentBuilder().parse(new ByteArrayInputStream(var1_1));
                if (!var12_12) {
                    try {
                        var27_27 = new XmlStyle(var1_1, var14_14);
                    }
                    catch (IsInnerlException var29_30) {
                        AOXMLDSigSigner.LOGGER.info("La hoja de estilo esta referenciada internamente, por lo que no se necesita dereferenciar");
                    }
                    catch (ReferenceIsNotXmlException var29_31) {
                        AOXMLDSigSigner.LOGGER.warning("La hoja de estilo referenciada no es XML o no se ha dereferenciado apropiadamente");
                    }
                    catch (CannotDereferenceException var29_32) {
                        AOXMLDSigSigner.LOGGER.warning("La hoja de estilo no ha podido dereferenciar, probablemente sea un enlace relativo local");
                    }
                    catch (Exception var29_33) {
                        AOXMLDSigSigner.LOGGER.severe("Error intentando dereferenciar la hoja de estilo: " + var29_33);
                    }
                }
                if (var15_15 == null || "application/octet-stream".equals(var15_15)) {
                    var15_15 = "text/xml";
                }
                if (var16_16 == null) {
                    var16_16 = var28_28.getXmlEncoding();
                }
                if (var16_16 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equals(var16_16)) {
                    var20_21.put("encoding", var16_16);
                }
                if ((var29_34 = (Object)var28_28.getXmlVersion()) != null) {
                    var20_21.put("version", (String)var29_34);
                }
                if ((var30_37 = var28_28.getDoctype()) != null && (var29_34 = var30_37.getSystemId()) != null) {
                    var20_21.put("doctype-system", (String)var29_34);
                }
                if (var8_8.equals("XMLDSig Detached")) {
                    var22_41 = var28_28.createElement("CONTENT");
                    var22_41.setAttributeNS(null, "Id", var23_23);
                    var22_41.setAttributeNS(null, "MimeType", (String)var15_15);
                    var22_41.setAttributeNS(null, "Encoding", var16_16);
                    var22_41.appendChild(var28_28.getDocumentElement());
                    if (var27_27.getStyleElement() == null) ** GOTO lbl173
                    try {
                        var31_42 = var28_28.createElement("STYLE");
                        var31_42.setAttributeNS(null, "Id", var24_24);
                        if (var27_27.getStyleType() != null) {
                            var31_42.setAttributeNS(null, "MimeType", var27_27.getStyleType());
                        }
                        var31_42.setAttributeNS(null, "Encoding", var27_27.getStyleEncoding());
                        var31_42.appendChild(var28_28.adoptNode(var27_27.getStyleElement().cloneNode(true)));
                        var27_27.setStyleElement((Element)var31_42);
                    }
                    catch (Exception var31_43) {
                        AOXMLDSigSigner.LOGGER.warning("No ha sido posible crear el elemento DOM para incluir la hoja de estilo del XML como Internally Detached: " + var31_43);
                        var27_27.setStyleElement(null);
                    }
                }
                var22_41 = var28_28.getDocumentElement();
            }
            catch (Exception var28_29) {
                if (var8_8.equals("XMLDSig Enveloped")) {
                    throw new InvalidXMLException(var28_29);
                }
                try {
                    AOXMLDSigSigner.LOGGER.info("El documento no es un XML valido. Se convertira a Base64: " + var28_29);
                    var29_34 = var21_22.newDocumentBuilder().newDocument();
                    var22_41 = var29_34.createElement("CONTENT");
                    var18_18 = null;
                    var16_16 = "http://www.w3.org/2000/09/xmldsig#base64";
                    if (var15_15 == null) {
                        var15_15 = "application/octet-stream";
                    }
                    var22_41.setAttributeNS(null, "Id", var23_23);
                    if (AOUtil.isBase64(var1_1) && ("http://www.w3.org/2000/09/xmldsig#base64".equals(var16_16) || (var16_16 != null ? var16_16 : "").toLowerCase().equals("base64"))) {
                        AOXMLDSigSigner.LOGGER.info("El documento se ha indicado como Base64, se insertara como tal en el XML");
                        var30_37 = Base64.decode(new String(var1_1));
                        var31_42 = new MimeHelper((byte[])var30_37);
                        var32_45 = var31_42.getMimeType();
                        var15_15 = var32_45 != null ? var32_45 : "application/octet-stream";
                        var22_41.setAttributeNS(null, "MimeType", (String)var15_15);
                        var22_41.setTextContent(new String(var1_1));
                    } else {
                        if ("http://www.w3.org/2000/09/xmldsig#base64".equals(var16_16)) {
                            AOXMLDSigSigner.LOGGER.info("El documento se ha indicado como Base64, pero no es un Base64 valido. Se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        } else {
                            AOXMLDSigSigner.LOGGER.info("El documento se considera binario, se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        }
                        if ("application/octet-stream".equals(var15_15)) {
                            var30_37 = new MimeHelper(var1_1);
                            var31_42 = var30_37.getMimeType();
                            var15_15 = var31_42 != null ? var31_42 : "application/octet-stream";
                        }
                        var22_41.setAttributeNS(null, "MimeType", (String)var15_15);
                        var22_41.setTextContent(Base64.encode(var1_1));
                        var26_26 = true;
                    }
                    var25_25 = true;
                    var16_16 = "http://www.w3.org/2000/09/xmldsig#base64";
                    var22_41.setAttributeNS(null, "Encoding", var16_16);
                }
                catch (Exception var29_35) {
                    throw new AOException("Error al convertir los datos a base64", var29_35);
                }
            }
        } else {
            var28_28 = null;
            if (var18_18 != null) {
                var29_34 = null;
                try {
                    var29_34 = AOUtil.getDataFromInputStream(AOUtil.loadFile(var18_18));
                }
                catch (Exception var30_38) {
                    throw new AOException("No se han podido obtener los datos de la URI externa", var30_38);
                }
                if (var29_34 != null && ((byte[])var29_34).length > 0) {
                    try {
                        var28_28 = MessageDigest.getInstance("SHA1").digest((byte[])var29_34);
                    }
                    catch (Exception var30_39) {
                        throw new AOException("No se ha podido obtener el SHA1 de los datos de la URI externa", var30_39);
                    }
                }
            } else if (var19_20 != null) {
                var28_28 = var1_1;
            } else {
                try {
                    var28_28 = MessageDigest.getInstance("SHA1").digest(var1_1);
                }
                catch (Exception var29_36) {
                    throw new AOException("No se ha podido obtener el SHA1 de los datos proporcionados", var29_36);
                }
            }
            if (var28_28 == null || ((byte[])var28_28).length < 1) {
                throw new AOException("Error al obtener la huella SHA1 de los datos");
            }
            try {
                var29_34 = var21_22.newDocumentBuilder().newDocument();
            }
            catch (Exception var30_40) {
                throw new AOException("No se ha podido crear el documento XML contenedor", var30_40);
            }
            var22_41 = var29_34.createElement("CONTENT");
            var16_16 = "http://www.w3.org/2000/09/xmldsig#base64";
            if (var19_20 != null) {
                var15_15 = "hash/" + var19_20.toLowerCase();
                var30_37 = XMLConstants.MESSAGEDIGEST_ALGOS_URI.get(var19_20.toLowerCase());
            } else {
                var15_15 = "hash/sha1";
                var30_37 = XMLConstants.MESSAGEDIGEST_ALGOS_URI.get("sha1");
            }
            var22_41.setAttributeNS(null, "Id", var23_23);
            var22_41.setAttributeNS(null, "MimeType", (String)var15_15);
            var22_41.setAttributeNS(null, "Encoding", var16_16);
            if (var30_37 != null) {
                var22_41.setAttributeNS(null, "hashAlgorithm", (String)var30_37);
            }
            var22_41.setTextContent(Base64.encode((byte[])var28_28));
            var25_25 = true;
        }
lbl173:
        // 6 sources

        var28_28 = "#" + var23_23;
        var29_34 = "#" + var24_24;
        var30_37 = null;
        try {
            var30_37 = var21_22.newDocumentBuilder().newDocument();
            if (var8_8.equals("XMLDSig Enveloped")) {
                var30_37.appendChild(var30_37.adoptNode(var22_41));
            } else {
                var30_37.appendChild(var30_37.createElement("AFIRMA"));
            }
        }
        catch (Exception var31_44) {
            throw new AOException("Error al crear la firma en formato " + var8_8 + ", modo " + var9_9, var31_44);
        }
        var31_42 = new ArrayList<Reference>();
        var32_45 = Utils.getDOMFactory();
        try {
            var33_46 = var32_45.newDigestMethod(var10_10, null);
        }
        catch (Exception var34_47) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + var10_10 + "'", var34_47);
        }
        var34_48 = "Reference-" + UUID.randomUUID().toString();
        var35_49 = "StyleReference-" + UUID.randomUUID().toString();
        var36_50 = new ArrayList<Transform>();
        Utils.addCustomTransforms(var36_50, var7_7, var17_17);
        if (!var25_25) {
            try {
                var36_50.add(var32_45.newTransform(var11_11, (TransformParameterSpec)null));
            }
            catch (Exception var37_51) {
                AOXMLDSigSigner.LOGGER.severe("No se puede encontrar el algoritmo de canonicalizacion, la referencia no se canonicalizara: " + var37_51);
            }
        } else if (var26_26 && !var13_13) {
            try {
                var36_50.add(var32_45.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null));
            }
            catch (Exception var37_52) {
                AOXMLDSigSigner.LOGGER.severe("No se puede encontrar el algoritmo transformacion Base64, esta no se declarara: " + var37_52);
            }
        }
        var37_53 = null;
        var38_54 = null;
        if (var8_8.equals("XMLDSig Enveloping")) {
            try {
                var39_55 = new ArrayList<DOMStructure>(1);
                if (var25_25) {
                    var39_55.add(new DOMStructure(var22_41.getFirstChild()));
                } else {
                    var39_55.add(new DOMStructure(var22_41));
                }
                var40_62 = "Object-" + UUID.randomUUID().toString();
                var37_53 = var32_45.newXMLObject((List<? extends XMLStructure>)var39_55, (String)var40_62, (String)var15_15, var16_16);
                var31_42.add(var32_45.newReference("#" + (String)var40_62, var33_46, var36_50, "http://www.w3.org/2000/09/xmldsig#Object", var34_48));
                if (var27_27.getStyleElement() != null) {
                    var41_66 = "StyleObject-" + UUID.randomUUID().toString();
                    var38_54 = var32_45.newXMLObject(Collections.singletonList(new DOMStructure(var27_27.getStyleElement())), (String)var41_66, var27_27.getStyleType(), var27_27.getStyleEncoding());
                    var31_42.add(var32_45.newReference("#" + (String)var41_66, var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), "http://www.w3.org/2000/09/xmldsig#Object", var35_49));
                }
            }
            catch (Exception var39_56) {
                throw new AOException("Error al generar la firma en formato enveloping", var39_56);
            }
            if (var27_27.getStyleHref() != null && var27_27.getStyleElement() == null && (var27_27.getStyleHref().startsWith("http://") || var27_27.getStyleHref().startsWith("https://"))) {
                try {
                    var31_42.add(var32_45.newReference(var27_27.getStyleHref(), var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                }
                catch (Exception var39_57) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + var39_57);
                }
            }
        } else if (var8_8.equals("XMLDSig Detached")) {
            try {
                if (var22_41 != null) {
                    var30_37.getDocumentElement().appendChild(var30_37.adoptNode(var22_41));
                    var31_42.add(var32_45.newReference((String)var28_28, var33_46, var36_50, null, var34_48));
                }
                if (var27_27.getStyleElement() != null) {
                    var30_37.getDocumentElement().appendChild(var30_37.adoptNode(var27_27.getStyleElement()));
                    var31_42.add(var32_45.newReference((String)var29_34, var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                }
            }
            catch (Exception var39_58) {
                throw new AOException("Error al generar la firma en formato detached implicito", var39_58);
            }
            if (var27_27.getStyleHref() != null && var27_27.getStyleElement() == null && (var27_27.getStyleHref().startsWith("http://") || var27_27.getStyleHref().startsWith("https://"))) {
                try {
                    var31_42.add(var32_45.newReference(var27_27.getStyleHref(), var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                }
                catch (Exception var39_59) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + var39_59);
                }
            }
        } else if (var8_8.equals("XMLDSig Externally Detached")) {
            var39_55 = null;
            if (var19_20 != null && (var18_18 == null || var18_18.getScheme().equals("") || var18_18.getScheme().equals("file"))) {
                var40_62 = null;
                try {
                    if (AOSignConstants.getDigestAlgorithmName(var19_20).equalsIgnoreCase("SHA1")) {
                        var40_62 = var32_45.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var19_20).equalsIgnoreCase("SHA-256")) {
                        var40_62 = var32_45.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var19_20).equalsIgnoreCase("SHA-512")) {
                        var40_62 = var32_45.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var19_20).equalsIgnoreCase("RIPEMD160")) {
                        var40_62 = var32_45.newDigestMethod("http://www.w3.org/2001/04/xmlenc#ripemd160", null);
                    }
                }
                catch (Exception var41_67) {
                    throw new AOException("No se ha podido crear el metodo de huella digital para la referencia Externally Detached", var41_67);
                }
                if (var40_62 == null) {
                    throw new AOException("Metodo de Message Digest para la referencia Externally Detached no soportado: " + var19_20);
                }
                var39_55 = var32_45.newReference("", (DigestMethod)var40_62, null, null, var34_48, var1_1);
            } else {
                if (var18_18 != null && var18_18.getScheme().equals("file")) {
                    try {
                        var39_55 = var32_45.newReference("", var33_46, null, null, var34_48, MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(var10_10)).digest(AOUtil.getDataFromInputStream(AOUtil.loadFile(var18_18))));
                    }
                    catch (Exception var40_63) {
                        throw new AOException("No se ha podido crear la referencia XML a partir de la URI local (" + var18_18.toASCIIString() + ")", var40_63);
                    }
                }
                if (var18_18 != null) {
                    try {
                        var39_55 = var32_45.newReference(var18_18.toASCIIString(), var33_46);
                    }
                    catch (Exception var40_64) {
                        throw new AOException("No se ha podido crear la referencia Externally Detached, probablemente por no obtenerse el metodo de digest", var40_64);
                    }
                }
            }
            if (var39_55 == null) {
                throw new AOException("Error al generar la firma Externally Detached, no se ha podido crear la referencia externa");
            }
            var31_42.add(var39_55);
            if (var27_27.getStyleHref() != null && var27_27.getStyleElement() == null) {
                if (var27_27.getStyleHref().startsWith("http://") || var27_27.getStyleHref().startsWith("https://")) {
                    try {
                        var31_42.add(var32_45.newReference(var27_27.getStyleHref(), var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                    }
                    catch (Exception var40_65) {
                        AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + var40_65);
                    }
                } else {
                    AOXMLDSigSigner.LOGGER.warning("Se necesita una referencia externa HTTP o HTTPS a la hoja de estilo para referenciarla en firmas XML Externally Detached");
                }
            }
        } else if (var8_8.equals("XMLDSig Enveloped")) {
            try {
                var36_50.add(var32_45.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                var36_50.add(var32_45.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("not(ancestor-or-self::" + var17_17 + ":Signature)", Collections.singletonMap(var17_17, "http://www.w3.org/2000/09/xmldsig#"))));
                var31_42.add(var32_45.newReference("", var33_46, var36_50, null, var34_48));
            }
            catch (Exception var39_60) {
                throw new AOException("Error al generar la firma en formato enveloped", var39_60);
            }
            if (var27_27.getStyleHref() != null && var27_27.getStyleElement() == null && (var27_27.getStyleHref().startsWith("http://") || var27_27.getStyleHref().startsWith("https://"))) {
                try {
                    var31_42.add(var32_45.newReference(var27_27.getStyleHref(), var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                }
                catch (Exception var39_61) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + var39_61);
                }
            }
        }
        var39_55 = UUID.randomUUID().toString();
        var40_62 = "KeyInfo-" + (String)var39_55;
        try {
            var31_42.add(var32_45.newReference("#" + (String)var40_62, var33_46, var36_50, null, null));
            var41_66 = var32_45.getKeyInfoFactory();
            var42_70 = new ArrayList<XMLStructure>();
            var43_72 = (X509Certificate)var4_4[0];
            var42_70.add(var41_66.newKeyValue(var43_72.getPublicKey()));
            var44_73 = null;
            var45_74 = Boolean.parseBoolean(var7_7.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (!var45_74) {
                var44_73 = var4_4;
            }
            if (var44_73 == null) {
                var44_73 = new Certificate[]{var43_72};
            }
            var42_70.add(var41_66.newX509Data(Arrays.asList(var44_73)));
            var46_75 = new ArrayList<XMLObject>();
            if (var8_8.equals("XMLDSig Enveloping") && var37_53 != null) {
                var46_75.add(var37_53);
                if (var38_54 != null) {
                    var46_75.add(var38_54);
                }
            }
            if (var8_8.equals("XMLDSig Enveloped") && var27_27.getStyleElement() != null) {
                var46_75.add(var32_45.newXMLObject(Collections.singletonList(new DOMStructure(var27_27.getStyleElement())), var24_24, var27_27.getStyleType(), var27_27.getStyleEncoding()));
                try {
                    var31_42.add((Reference)var32_45.newReference((String)var29_34, var33_46, Collections.singletonList(var32_45.newTransform(var11_11, (TransformParameterSpec)null)), null, var35_49));
                }
                catch (Exception var47_76) {
                    AOXMLDSigSigner.LOGGER.severe("No se ha podido anadir una referencia a la hoja de estilo, esta se incluira dentro de la firma, pero no estara firmada: " + var47_76);
                }
            }
            var47_77 = var32_45.newXMLSignature(var32_45.newSignedInfo(var32_45.newCanonicalizationMethod(var11_11, (C14NMethodParameterSpec)null), var32_45.newSignatureMethod(var6_6, null), XmlDSigUtil.cleanReferencesList(var31_42)), var41_66.newKeyInfo((List<? extends XMLStructure>)var42_70, (String)var40_62), var46_75, "Signature-" + (String)var39_55, "SignatureValue-" + (String)var39_55);
            var48_78 = new DOMSignContext(var3_3, (Node)var30_37.getDocumentElement());
            var48_78.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", var17_17);
            try {
                var48_78.setURIDereferencer(new CustomUriDereferencer(CustomUriDereferencer.getDefaultDereferencer()));
            }
            catch (Exception var49_79) {
                AOXMLDSigSigner.LOGGER.warning("No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + var49_79);
            }
            var47_77.sign(var48_78);
        }
        catch (NoSuchAlgorithmException var41_68) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + var2_2 + "'", var41_68);
        }
        catch (Exception var41_69) {
            throw new AOException("Error al generar la firma XMLdSig", var41_69);
        }
        var41_66 = (var17_17 == null || "".equals(var17_17) != false ? "" : var17_17 + ":") + "Signature";
        if (var8_8.equals("XMLDSig Enveloping")) {
            try {
                if (var30_37.getElementsByTagName((String)var41_66).getLength() == 1) {
                    var42_70 = var21_22.newDocumentBuilder().newDocument();
                    var42_70.appendChild(var42_70.adoptNode(var30_37.getElementsByTagName((String)var41_66).item(0)));
                    var30_37 = var42_70;
                }
            }
            catch (Exception var42_71) {
                AOXMLDSigSigner.LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + var42_71);
            }
        }
        return Utils.writeXML(var30_37.getDocumentElement(), var20_21, var8_8.equals("XMLDSig Enveloped") != false ? var27_27.getStyleHref() : null, var8_8.equals("XMLDSig Enveloped") != false ? var27_27.getStyleType() : null);
    }

    private static boolean isDetached(Element element) {
        if (element == null) {
            return false;
        }
        return element.getFirstChild().getLocalName() != null && element.getFirstChild().getLocalName().equals(DETACHED_CONTENT_ELEMENT_NAME);
    }

    private static boolean isEnveloped(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("Algorithm").equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnveloping(Element element) {
        if (element == null) {
            return false;
        }
        return element.getLocalName().equals(SIGNATURE_STR) || element.getLocalName().equals(AFIRMA) && element.getFirstChild().getLocalName().equals(SIGNATURE_STR);
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        Object object;
        Element element;
        block9: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            element = null;
            try {
                if (!this.isSign(byArray)) {
                    throw new AOInvalidFormatException("El documento no es un documento de firmas valido.");
                }
                Element element2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
                if (AOXMLDSigSigner.isDetached(element2)) {
                    object = (Element)element2.getFirstChild();
                    if (object.getAttribute(MIMETYPE_STR).equals("text/xml")) {
                        element = (Element)object.getFirstChild();
                        break block9;
                    }
                    return Base64.decode(object.getTextContent());
                }
                if (AOXMLDSigSigner.isEnveloped(element2)) {
                    object = element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.removeChild(object.item(0));
                    }
                    element = element2;
                    break block9;
                }
                if (!AOXMLDSigSigner.isEnveloping(element2)) break block9;
                object = (Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object").item(0);
                if (object.getAttribute(MIMETYPE_STR).equals("text/xml")) {
                    element = (Element)object.getFirstChild();
                    break block9;
                }
                return Base64.decode(object.getTextContent());
            }
            catch (Exception exception) {
                throw new AOInvalidFormatException("Error al leer el fichero de firmas", exception);
            }
        }
        if (element == null) {
            return null;
        }
        object = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object)), element);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        String string2;
        Object object;
        Object object2;
        DigestMethod digestMethod;
        Element element;
        Document document;
        String string3 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string4 = properties2.getProperty("referencesDigestMethod", DIGEST_METHOD);
        String string5 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string6 = properties2.getProperty("xmlSignaturePrefix", XML_SIGNATURE_PREFIX);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray2));
            element = document.getDocumentElement();
            if (element.getNodeName().equals((string6 == null || "".equals(string6) ? "" : string6 + ":") + SIGNATURE_STR)) {
                document = AOXMLDSigSigner.insertarNodoAfirma(document);
                element = document.getDocumentElement();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AOException("Formato de documento de firmas incorrecto", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new AOException("Formato de documento de firmas incorrecto", sAXException);
        }
        catch (IOException iOException) {
            throw new AOException("Error al leer el documento de firmas", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("Parametro de entrada incorrecto", illegalArgumentException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido leer el documento XML de firmas", exception);
        }
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string4, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string4 + "'", exception);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        NodeList nodeList = ((Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR).item(0)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            object2 = node.getAttributes();
            if (i != 0 && (object2.getNamedItem("Id") == null || !object2.getNamedItem("Id").getNodeValue().startsWith(STYLE_REFERENCE_PREFIX))) continue;
            try {
                object = Utils.getObjectReferenceTransforms(node, string6);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Logger.getLogger("Se ha declarado una transformacion personalizada de un tipo no soportado: " + noSuchAlgorithmException);
                throw new AOException("Se ha declarado una transformacion personalizada de un tipo no soportado", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Logger.getLogger("Se han especificado parametros erroneos para una transformacion personalizada: " + invalidAlgorithmParameterException);
                throw new AOException("Se han especificado parametros erroneos para una transformacion personalizada", invalidAlgorithmParameterException);
            }
            string2 = null;
            string2 = object2.getNamedItem("Id") != null && object2.getNamedItem("Id").getNodeValue().startsWith(STYLE_REFERENCE_PREFIX) ? STYLE_REFERENCE_PREFIX + UUID.randomUUID().toString() : "Reference-" + UUID.randomUUID().toString();
            arrayList2.add(string2);
            arrayList.add(xMLSignatureFactory.newReference(((Element)node).getAttribute("URI"), digestMethod, (List<? extends Transform>)object, null, string2));
        }
        String string7 = UUID.randomUUID().toString();
        object2 = "Signature-" + string7;
        object = "SignatureValue-" + string7;
        string2 = "KeyInfo-" + string7;
        try {
            CanonicalizationMethod canonicalizationMethod = xMLSignatureFactory.newCanonicalizationMethod(string5, (C14NMethodParameterSpec)null);
            ArrayList<Transform> arrayList3 = new ArrayList<Transform>();
            Transform transform = xMLSignatureFactory.newTransform(string5, (TransformParameterSpec)null);
            arrayList3.add(transform);
            arrayList.add(xMLSignatureFactory.newReference("#" + string2, digestMethod, arrayList3, null, null));
            SignatureMethod signatureMethod = xMLSignatureFactory.newSignatureMethod(string3, null);
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            ArrayList<XMLStructure> arrayList4 = new ArrayList<XMLStructure>();
            arrayList4.add(keyInfoFactory.newKeyValue(x509Certificate.getPublicKey()));
            Certificate[] certificateArray2 = null;
            boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (!bl) {
                certificateArray2 = certificateArray;
            }
            if (certificateArray2 == null) {
                certificateArray2 = new Certificate[]{x509Certificate};
            }
            arrayList4.add(keyInfoFactory.newX509Data(Arrays.asList(certificateArray2)));
            DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element);
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", string6);
            xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, arrayList), keyInfoFactory.newKeyInfo(arrayList4, string2), new ArrayList(), (String)object2, (String)object).sign(dOMSignContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'", noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la cofirma XMLdSig", exception);
        }
        return Utils.writeXML(element, hashtable, null, null);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Element element;
        Object object2;
        Element element2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            element2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            object2 = documentBuilderFactory.newDocumentBuilder().newDocument();
            element = (Element)object2.adoptNode(element2.cloneNode(true));
            object = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            while (object.getLength() > 0) {
                element.removeChild(object.item(0));
                object = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            }
            object2.appendChild(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AOException("Formato de documento de firmas incorrecto", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new AOException("Formato de documento de firmas incorrecto", sAXException);
        }
        catch (IOException iOException) {
            throw new AOException("Error al leer el documento de firmas", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("Parametro de entrada incorrecto", illegalArgumentException);
        }
        object2 = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object2)), element2);
        object = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object)), element);
        return this.cosign(((ByteArrayOutputStream)object).toByteArray(), ((ByteArrayOutputStream)object2).toByteArray(), string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        String string2 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", DIGEST_METHOD);
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string5)) {
            string5 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        String string6 = properties2.getProperty("xmlSignaturePrefix", XML_SIGNATURE_PREFIX);
        boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
        this.algo = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Element element;
            DocumentType documentType;
            String string7;
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            if (string5 == null) {
                string5 = this.doc.getXmlEncoding();
            }
            if (string5 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equalsIgnoreCase(string5)) {
                hashtable.put("encoding", string5);
            }
            if ((string7 = this.doc.getXmlVersion()) != null) {
                hashtable.put("version", string7);
            }
            if ((documentType = this.doc.getDoctype()) != null && (string7 = documentType.getSystemId()) != null) {
                hashtable.put("doctype-system", string7);
            }
            if ((element = this.doc.getDocumentElement()).getNodeName().equals((string6 == null || "".equals(string6) ? "" : string6 + ":") + SIGNATURE_STR)) {
                this.doc = AOXMLDSigSigner.insertarNodoAfirma(this.doc);
                element = this.doc.getDocumentElement();
            }
            if (counterSignTarget == CounterSignTarget.TREE) {
                this.countersignTree(element, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                this.countersignLeafs(element, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.NODES) {
                this.countersignNodes(element, objectArray, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                this.countersignSigners(element, objectArray, privateKey, certificateArray, bl, string3, string4, string6);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
        return Utils.writeXML(this.doc.getDocumentElement(), hashtable, null, null);
    }

    private void countersignTree(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elementArray[i] = (Element)nodeList.item(i);
        }
        try {
            for (Element element2 : elementArray) {
                this.cs(element2, privateKey, certificateArray, bl, string, string2, string3);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
    }

    private void countersignLeafs(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        int n;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        NodeList nodeList2 = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
        String[] stringArray = new String[nodeList.getLength()];
        for (n = 0; n < nodeList.getLength(); ++n) {
            stringArray[n] = ((Element)nodeList.item(n)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0).getAttributes().getNamedItem("Id").getNodeValue();
        }
        try {
            for (n = 0; n < stringArray.length; ++n) {
                String string4 = "#" + stringArray[n];
                boolean bl2 = true;
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (!((Element)nodeList2.item(i)).getAttribute("URI").equals(string4)) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                this.cs((Element)nodeList.item(n), privateKey, certificateArray, bl, string, string2, string3);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
    }

    private void countersignNodes(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        int n;
        if (objectArray == null) {
            throw new IllegalArgumentException("La lista de nodos a contrafirmar no puede ser nula");
        }
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringArray[i] = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0).getAttributes().getNamedItem("Id").getNodeValue();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            n = 1;
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!CSURI.equals(((Element)nodeList2.item(j)).getAttribute("Type"))) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            arrayList.add((Element)nodeList.item(i));
            this.addSubNodes(stringArray[i], nodeList, stringArray, arrayList);
        }
        List<Object> list = Arrays.asList(objectArray);
        for (n = 0; n < arrayList.size(); ++n) {
            if (!list.contains(n)) continue;
            this.cs((Element)arrayList.get(n), privateKey, certificateArray, bl, string, string2, string3);
        }
    }

    private void addSubNodes(String string, NodeList nodeList, String[] stringArray, List<Element> list) {
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!("#" + string).equals(((Element)nodeList2.item(j)).getAttribute("URI"))) continue;
                if (stringArray[i].equals(string)) continue block0;
                list.add((Element)nodeList.item(i));
                this.addSubNodes(stringArray[i], nodeList, stringArray, list);
                continue block0;
            }
        }
    }

    private void countersignSigners(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        int n = nodeList.getLength();
        List<Object> list = Arrays.asList(objectArray);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!list.contains(AOUtil.getCN(Utils.getCertificate(element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0))))) continue;
            arrayList.add(element2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.cs((Element)iterator.next(), privateKey, certificateArray, bl, string, string2, string3);
        }
    }

    private void cs(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        Object object;
        DigestMethod digestMethod;
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string + "'", exception);
        }
        String string4 = "Reference-" + UUID.randomUUID().toString();
        try {
            object = new ArrayList<Transform>();
            object.add(xMLSignatureFactory.newTransform(string2, (TransformParameterSpec)null));
            arrayList.add(xMLSignatureFactory.newReference("#" + element2.getAttribute("Id"), digestMethod, (List<? extends Transform>)object, CSURI, string4));
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
        object = UUID.randomUUID().toString();
        String string5 = "Signature-" + (String)object;
        String string6 = "SignatureValue-" + (String)object;
        String string7 = "KeyInfo-" + (String)object;
        try {
            arrayList.add(xMLSignatureFactory.newReference("#" + string7, digestMethod));
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            ArrayList<XMLStructure> arrayList2 = new ArrayList<XMLStructure>();
            arrayList2.add(keyInfoFactory.newKeyValue(x509Certificate.getPublicKey()));
            Certificate[] certificateArray2 = null;
            if (!bl) {
                certificateArray2 = certificateArray;
            }
            if (certificateArray2 == null) {
                certificateArray2 = new Certificate[]{x509Certificate};
            }
            arrayList2.add(keyInfoFactory.newX509Data(Arrays.asList(certificateArray2)));
            XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(string2, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(XMLConstants.SIGN_ALGOS_URI.get(this.algo), null), arrayList), keyInfoFactory.newKeyInfo(arrayList2, string7), null, string5, string6);
            DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element.getOwnerDocument().getDocumentElement());
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", string3);
            xMLSignature.sign(dOMSignContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + this.algo + "'", noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        int n;
        String string;
        Object object;
        Element element;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            element = this.doc.getDocumentElement();
            object = Utils.guessXmlDSigNamespacePrefix(element);
            String string2 = string = "".equals(object) ? "" : (String)object + ":";
            if (element.getNodeName().equals(string + SIGNATURE_STR)) {
                this.doc = AOXMLDSigSigner.insertarNodoAfirma(this.doc);
                element = this.doc.getDocumentElement();
            }
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha producido un error al obtener la estructura de firmas. " + exception);
            return null;
        }
        object = new AOTreeNode("Datos");
        NodeList nodeList = element.getElementsByTagName(string + SIGNATURE_STR);
        NodeList nodeList2 = element.getElementsByTagName(string + "SignatureValue");
        int n2 = nodeList.getLength();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        AOTreeNode[] aOTreeNodeArray = new AOTreeNode[n2];
        for (n = 0; n < n2; ++n) {
            Element element2 = (Element)nodeList.item(n);
            stringArray[n] = element2.getAttribute("Id");
            aOTreeNodeArray[n] = new AOTreeNode(bl ? Utils.getSimpleSignInfoNode(XADESNS, element2) : Utils.getStringInfoNode(element2));
            String string3 = ((Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR).item(0)).getAttribute("Type");
            stringArray2[n] = string3.equals(CSURI) ? Utils.getCounterSignerReferenceId(element2, nodeList2) : "";
        }
        for (n = 0; n < n2; ++n) {
            if (!"".equals(stringArray2[n])) continue;
            ((AOTreeNode)object).add(this.generaArbol(n, n2 - 1, aOTreeNodeArray, stringArray, stringArray2)[n]);
        }
        return new AOTreeModel((AOTreeNode)object);
    }

    private AOTreeNode[] generaArbol(int n, int n2, AOTreeNode[] aOTreeNodeArray, String[] stringArray, String[] stringArray2) {
        int n3 = stringArray.length;
        if (n < n3 && n2 > 0) {
            if (stringArray[n].equals(stringArray2[n2])) {
                this.generaArbol(n + 1, n2 - 1, aOTreeNodeArray, stringArray, stringArray2);
            }
            if (n < n2) {
                this.generaArbol(n, n2 - 1, aOTreeNodeArray, stringArray, stringArray2);
            }
            if (!stringArray[n].equals(stringArray2[n2])) {
                return aOTreeNodeArray;
            }
            this.generaArbol(n2, n3 - 1, aOTreeNodeArray, stringArray, stringArray2);
            aOTreeNodeArray[n].add(aOTreeNodeArray[n2]);
        }
        return aOTreeNodeArray;
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            Element element = document.getDocumentElement();
            String string = XML_SIGNATURE_PREFIX == null || "".equals(XML_SIGNATURE_PREFIX) ? SIGNATURE_STR : "ds:Signature";
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (element.getNodeName().equals(string)) {
                arrayList.add(element);
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            if (arrayList.size() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    private static Document insertarNodoAfirma(Document document) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document2 = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document2.createElement(AFIRMA);
        element.appendChild(document2.adoptNode(document.getDocumentElement()));
        document2.appendChild(element);
        return document2;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        AOSignInfo aOSignInfo = new AOSignInfo("XMLDSig");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Element element = null;
        try {
            element = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
        }
        catch (Exception exception) {
            LOGGER.warning("Error al analizar la firma: " + exception);
            element = null;
        }
        if (element != null) {
            if (AOXMLDSigSigner.isDetached(element)) {
                aOSignInfo.setVariant("XMLDSig Detached");
            } else if (AOXMLDSigSigner.isEnveloped(element)) {
                aOSignInfo.setVariant("XMLDSig Enveloped");
            } else if (AOXMLDSigSigner.isEnveloping(element)) {
                aOSignInfo.setVariant("XMLDSig Enveloping");
            }
        }
        return aOSignInfo;
    }

    private static void writeXML(Writer writer, Node node) {
        Document document = node.getOwnerDocument();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("namespaces", Boolean.FALSE);
        DOMOutputImpl dOMOutputImpl = new DOMOutputImpl();
        dOMOutputImpl.setCharacterStream(writer);
        lSSerializer.write(node, dOMOutputImpl);
    }

    static {
        if (Security.getProvider("XMLDSig") == null) {
            try {
                Security.addProvider((Provider)Class.forName("org.jcp.xml.dsig.internal.dom.XMLDSigRI").newInstance());
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido agregar el proveedor de firma XMLDSig necesario para firmas XML: " + exception);
            }
        }
    }
}

