/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.style;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyleMessages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlStyle {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private Element element;
    private final String type;
    private final String href;
    private final String encoding;

    public XmlStyle() {
        this.element = null;
        this.type = null;
        this.href = null;
        this.encoding = null;
    }

    public XmlStyle(byte[] byArray, boolean bl) throws IOException, TransformerConfigurationException, CannotDereferenceException, IsInnerlException, ReferenceIsNotXmlException {
        Properties properties = XmlStyle.getStyleSheetHeader(new String(byArray));
        this.type = properties.getProperty("type");
        this.href = properties.getProperty("href");
        if (this.type != null && this.href != null) {
            LOGGER.info("Se ha encontrado una hoja de estilo asociada al XML a firmar: tipo=" + this.type + ", referencia=" + this.href);
            Document document = XmlStyle.dereferenceStyleSheet(TransformerFactory.newInstance().getAssociatedStylesheet(new StreamSource(new ByteArrayInputStream(byArray)), null, null, null).getSystemId(), bl);
            this.element = !this.href.startsWith(HTTP_PROTOCOL_PREFIX) && !this.href.startsWith(HTTPS_PROTOCOL_PREFIX) ? document.getDocumentElement() : null;
            this.encoding = document.getXmlEncoding();
        } else {
            this.encoding = null;
            this.element = null;
        }
    }

    public void setStyleElement(Element element) {
        this.element = element;
    }

    public Element getStyleElement() {
        return this.element;
    }

    public String getStyleType() {
        return this.type;
    }

    public String getStyleHref() {
        return this.href;
    }

    public String getStyleEncoding() {
        return this.encoding;
    }

    private static Properties getStyleSheetHeader(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        int n = string.indexOf("<?xml-stylesheet ");
        if (n == -1) {
            return properties;
        }
        String string2 = string.substring(n);
        string2 = string2.substring(0, string2.indexOf(62) + 1).replace("<?xml-stylesheet ", "").replace("?>", "").replace(" ", "\n").replace("\"", "").replace("'", "");
        properties.load(new ByteArrayInputStream(string2.getBytes()));
        return properties;
    }

    private static Document dereferenceStyleSheet(String string, boolean bl) throws CannotDereferenceException, IsInnerlException, ReferenceIsNotXmlException {
        byte[] byArray;
        block13: {
            if (string == null || "".equals(string)) {
                throw new CannotDereferenceException("La hoja de estilo era nula o vacia");
            }
            byArray = null;
            try {
                URI uRI = AOUtil.createURI(string);
                if (uRI.getScheme().equals("file")) {
                    throw new UnsupportedOperationException("No se aceptan dereferenciaciones directas con file://");
                }
                byArray = AOUtil.getDataFromInputStream(AOUtil.loadFile(uRI));
            }
            catch (Exception exception) {
                String[] stringArray = string.replace(File.separator, "/").split("/");
                String string2 = stringArray[stringArray.length - 1];
                if (string2.startsWith("#")) {
                    throw new IsInnerlException(exception);
                }
                if (!bl && string.startsWith("file://")) {
                    File file;
                    if (AOUIFactory.showConfirmDialog(null, XmlStyleMessages.getString("XmlStyle.5"), XmlStyleMessages.getString("XmlStyle.6"), AOUIFactory.OK_CANCEL_OPTION, AOUIFactory.INFORMATION_MESSAGE) != AOUIFactory.OK_OPTION) break block13;
                    try {
                        file = AOUIFactory.getLoadFiles(XmlStyleMessages.getString("XmlStyle.7"), null, string2, null, XmlStyleMessages.getString("XmlStyle.8", string2), false, false, null)[0];
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        LOGGER.warning("El usuario ha cancelado la seleccion de hoja de estilo: " + aOCancelledOperationException);
                        throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo", exception);
                    }
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byArray = AOUtil.getDataFromInputStream(fileInputStream);
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception2) {
                        throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo", exception2);
                    }
                }
                throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo: " + string, exception);
            }
        }
        try {
            if (byArray != null) {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            }
            throw new CannotDereferenceException("No se ha dereferenciado la hoja de estilo");
        }
        catch (Exception exception) {
            throw new ReferenceIsNotXmlException(exception);
        }
    }
}

