/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xadestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.UrlHttpManager;
import es.gob.afirma.core.misc.UrlHttpManagerFactory;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOXAdESTriPhaseSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String PROPERTY_NAME_SIGN_SERVER_URL = "serverUrl";
    private static final String OPERATION_PRESIGN = "pre";
    private static final String OPERATION_POSTSIGN = "post";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String CRYPTO_OPERATION_COSIGN = "cosign";
    private static final String CRYPTO_OPERATION_COUNTERSIGN = "countersign";
    private static final String PARAMETER_NAME_OPERATION = "op";
    private static final String PARAMETER_NAME_CRYPTO_OPERATION = "cop";
    private static final String HTTP_CGI = "?";
    private static final String HTTP_EQUALS = "=";
    private static final String HTTP_AND = "&";
    private static final String PARAMETER_NAME_DOCID = "doc";
    private static final String PARAMETER_NAME_ALGORITHM = "algo";
    private static final String PARAMETER_NAME_FORMAT = "format";
    private static final String PARAMETER_NAME_CERT = "cert";
    private static final String PARAMETER_NAME_EXTRA_PARAM = "params";
    private static final String PARAMETER_NAME_SESSION_DATA = "session";
    private static final String XADES_FORMAT = "XAdES";
    private static final String PROPERTY_NAME_PRESIGN_PREFIX = "PRE.";
    private static final String PROPERTY_NAME_SIGN_COUNT = "SIGN_COUNT";
    private static final String PROPERTY_NAME_PKCS1_SIGN_PREFIX = "PK1.";
    private static final String PROPERTY_NAME_NEED_PRE = "NEED_PRE";
    private static final String PROPERTY_NAME_NEED_DATA = "NEED_DATA";
    private static final String SUCCESS = "OK";
    private static final String COUNTERSIGN_TARGET_KEY = "target";
    public static final String COUNTERSIGN_TARGET_LEAFS = "leafs";
    public static final String COUNTERSIGN_TARGET_TREE = "tree";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(CRYPTO_OPERATION_COSIGN, byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.cosign(null, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Properties properties2;
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (!properties2.containsKey(COUNTERSIGN_TARGET_KEY)) {
            properties2.setProperty(COUNTERSIGN_TARGET_KEY, COUNTERSIGN_TARGET_LEAFS);
        }
        return AOXAdESTriPhaseSigner.triPhaseOperation(CRYPTO_OPERATION_COUNTERSIGN, byArray, string, privateKey, certificateArray, properties2);
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    private static byte[] triPhaseOperation(String string, byte[] byArray, String string2, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        CharSequence charSequence;
        byte[] byArray3;
        Serializable serializable;
        String string3;
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL), exception);
        }
        try {
            string3 = Base64.encodeBytes(byArray, 16);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error al interpretar los datos como identificador del documento que desea firmar", iOException);
        }
        UrlHttpManager urlHttpManager = UrlHttpManagerFactory.getInstalledManager();
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_PRESIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(XADES_FORMAT).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(Base64.encodeBytes(certificateArray[0].getEncoded(), 16)).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string3);
            if (properties.size() > 0) {
                ((StringBuffer)serializable).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOXAdESTriPhaseSigner.properties2Base64(properties));
            }
            byArray3 = urlHttpManager.readUrlByPost(((StringBuffer)serializable).toString());
            ((StringBuffer)serializable).setLength(0);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando el certificado del firmante: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, iOException);
        }
        try {
            serializable = AOXAdESTriPhaseSigner.base642Properties(new String(byArray3));
        }
        catch (IOException iOException) {
            throw new AOException("La respuesta del servidor no es valida: " + new String(byArray3), iOException);
        }
        String string4 = ((Properties)serializable).getProperty(PROPERTY_NAME_NEED_DATA);
        boolean bl = string4 != null && "true".equalsIgnoreCase(string4);
        String string5 = ((Properties)serializable).getProperty(PROPERTY_NAME_NEED_PRE);
        boolean bl2 = string5 != null && "true".equalsIgnoreCase(string5);
        int n = 1;
        if (((Properties)serializable).containsKey(PROPERTY_NAME_SIGN_COUNT)) {
            n = Integer.parseInt(((Properties)serializable).getProperty(PROPERTY_NAME_SIGN_COUNT));
        }
        for (int i = 0; i < n; ++i) {
            byte[] byArray4;
            charSequence = ((Properties)serializable).getProperty(PROPERTY_NAME_PRESIGN_PREFIX + i);
            if (charSequence == null) {
                throw new AOException("El servidor no ha devuelto la prefirma numero " + i + ": " + new String(byArray3));
            }
            try {
                byArray4 = Base64.decode((String)charSequence);
            }
            catch (IOException iOException) {
                throw new AOException("Error decodificando la prefirma: " + iOException, iOException);
            }
            byte[] byArray5 = new AOPkcs1Signer().sign(byArray4, string2, privateKey, certificateArray, null);
            ((Properties)serializable).setProperty(PROPERTY_NAME_PKCS1_SIGN_PREFIX + i, Base64.encode(byArray5));
            if (bl2) continue;
            ((Properties)serializable).remove(PROPERTY_NAME_PRESIGN_PREFIX + i);
        }
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_POSTSIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(XADES_FORMAT).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(Base64.encodeBytes(certificateArray[0].getEncoded(), 16));
            if (properties.size() > 0) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOXAdESTriPhaseSigner.properties2Base64(properties));
            }
            if (((Properties)serializable).size() > 0) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_SESSION_DATA).append(HTTP_EQUALS).append(AOXAdESTriPhaseSigner.properties2Base64((Properties)serializable));
            }
            if (bl) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string3);
            }
            byArray2 = urlHttpManager.readUrlByPost(((StringBuffer)charSequence).toString());
            ((StringBuffer)charSequence).setLength(0);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando el certificado del firmante: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de postfirma al servidor: " + iOException, iOException);
        }
        charSequence = new String(byArray2).trim();
        if (!((String)charSequence).startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + new String(byArray2));
        }
        try {
            return Base64.decode(((String)charSequence).substring("OK NEWID=".length()), 16);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto", iOException);
        }
    }

    private static String properties2Base64(Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "");
        return Base64.encodeBytes(byteArrayOutputStream.toByteArray(), 16);
    }

    private static Properties base642Properties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(Base64.decode(string, 16)));
        return properties;
    }
}

