/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.InvalidXMLException;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyle;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.xades.security.xml.XAdES.DataObjectFormat;
import net.java.xades.security.xml.XAdES.DataObjectFormatImpl;
import net.java.xades.security.xml.XAdES.ObjectIdentifier;
import net.java.xades.security.xml.XAdES.ObjectIdentifierImpl;
import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifier;
import net.java.xades.security.xml.XAdES.SignatureProductionPlace;
import net.java.xades.security.xml.XAdES.SignerRoleImpl;
import net.java.xades.security.xml.XAdES.XAdES;
import net.java.xades.security.xml.XAdES.XAdES_BES;
import net.java.xades.security.xml.XAdES.XAdES_EPES;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XAdESSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";

    public static byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        AOXMLAdvancedSignature aOXMLAdvancedSignature;
        Object object2;
        String string2;
        SignatureProductionPlace signatureProductionPlace;
        Object object3;
        Object object4;
        Object object5;
        Transform transform;
        DigestMethod digestMethod;
        Object object6;
        Object object7;
        Element element;
        Object object8;
        Object object9;
        Object object10;
        String string3 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("useManifest", Boolean.FALSE.toString()));
        String string4 = properties2.getProperty("insertEnvelopedSignatureOnNodeByXPath");
        String string5 = properties2.getProperty("nodeToSign");
        String string6 = properties2.getProperty("format", "XAdES Enveloping");
        String string7 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2000/09/xmldsig#sha1");
        String string8 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string9 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string10 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("ignoreStyleSheets", Boolean.FALSE.toString()));
        boolean bl4 = Boolean.parseBoolean(properties2.getProperty("avoidBase64Transforms", Boolean.FALSE.toString()));
        boolean bl5 = Boolean.parseBoolean(properties2.getProperty("headLess", Boolean.TRUE.toString()));
        boolean bl6 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.FALSE.toString()));
        boolean bl7 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString()));
        String string11 = properties2.getProperty("precalculatedHashAlgorithm");
        boolean bl8 = Boolean.parseBoolean(properties2.getProperty("facturaeSign", Boolean.FALSE.toString()));
        Object object11 = properties2.getProperty("mimeType", "application/octet-stream");
        String string12 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string12)) {
            string12 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        URI uRI = null;
        try {
            uRI = AOUtil.createURI(properties2.getProperty("uri"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Utils.checkIllegalParams(string6, "implicit", uRI, string11, true);
        if (!(byArray != null && byArray.length != 0 || string6.equals("XAdES Externally Detached") && uRI != null)) {
            throw new AOException("No se han podido leer los datos a firmar");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        String string13 = "CONTENT-" + UUID.randomUUID().toString();
        String string14 = "STYLE-" + UUID.randomUUID().toString();
        boolean bl9 = false;
        boolean bl10 = false;
        XmlStyle xmlStyle = new XmlStyle();
        try {
            object10 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            if (!bl3) {
                try {
                    xmlStyle = new XmlStyle(byArray, bl5);
                }
                catch (IsInnerlException isInnerlException) {
                    LOGGER.info("La hoja de estilo esta referenciada internamente, por lo que no se necesita dereferenciar");
                }
                catch (ReferenceIsNotXmlException referenceIsNotXmlException) {
                    LOGGER.warning("La hoja de estilo referenciada no es XML o no se ha dereferenciado apropiadamente");
                }
                catch (CannotDereferenceException cannotDereferenceException) {
                    LOGGER.warning("La hoja de estilo no ha podido dereferenciar, probablemente sea un enlace relativo local");
                }
                catch (Exception exception) {
                    LOGGER.severe("Error intentando dereferenciar la hoja de estilo: " + exception);
                }
            }
            if (object11 == null || "application/octet-stream".equals(object11)) {
                object11 = "text/xml";
            }
            if (string12 == null) {
                string12 = object10.getXmlEncoding();
            }
            if (string12 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equals(string12)) {
                hashtable.put("encoding", string12);
            }
            if ((object9 = object10.getXmlVersion()) != null) {
                hashtable.put("version", (String)object9);
            }
            if ((object8 = object10.getDoctype()) != null && (object9 = object8.getSystemId()) != null) {
                hashtable.put("doctype-system", (String)object9);
            }
            if (string6.equals("XAdES Detached")) {
                element = object10.createElement("CONTENT");
                element.setAttributeNS(null, "Id", string13);
                element.setAttributeNS(null, "MimeType", (String)object11);
                if (string12 != null && !"".equals(string12)) {
                    element.setAttributeNS(null, "Encoding", string12);
                }
                element.appendChild(object10.getDocumentElement());
                if (xmlStyle.getStyleElement() != null) {
                    try {
                        object7 = object10.createElement("STYLE");
                        object7.setAttributeNS(null, "Id", string14);
                        if (xmlStyle.getStyleType() != null) {
                            object7.setAttributeNS(null, "MimeType", xmlStyle.getStyleType());
                        }
                        object7.setAttributeNS(null, "Encoding", xmlStyle.getStyleEncoding());
                        object7.appendChild(object10.adoptNode(xmlStyle.getStyleElement().cloneNode(true)));
                        xmlStyle.setStyleElement((Element)object7);
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No ha sido posible crear el elemento DOM para incluir la hoja de estilo del XML como Internally Detached: " + exception);
                        xmlStyle.setStyleElement(null);
                    }
                }
            } else {
                element = object10.getDocumentElement();
            }
        }
        catch (Exception exception) {
            if (string6.equals("XAdES Enveloped") || string5 != null) {
                throw new InvalidXMLException(exception);
            }
            LOGGER.info("El documento no es un XML valido. Se convertira a Base64: " + exception);
            try {
                object9 = documentBuilderFactory.newDocumentBuilder().newDocument();
                element = object9.createElement("CONTENT");
                uRI = null;
                if (object11 == null) {
                    object11 = "application/octet-stream";
                }
                element.setAttributeNS(null, "Id", string13);
                if (AOUtil.isBase64(byArray) && ("http://www.w3.org/2000/09/xmldsig#base64".equals(string12) || "base64".equalsIgnoreCase(string12))) {
                    LOGGER.info("El documento se ha indicado como Base64, se insertara como tal en el XML");
                    object8 = Base64.decode(new String(byArray));
                    object7 = new MimeHelper((byte[])object8);
                    object6 = ((MimeHelper)object7).getMimeType();
                    object11 = object6 != null ? object6 : "application/octet-stream";
                    element.setAttributeNS(null, "MimeType", (String)object11);
                    element.setTextContent(Base64.encode((byte[])object8));
                } else {
                    if ("http://www.w3.org/2000/09/xmldsig#base64".equals(string12)) {
                        LOGGER.info("El documento se ha indicado como Base64, pero no es un Base64 valido. Se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                    } else {
                        LOGGER.info("El documento se considera binario, se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                    }
                    if (object11 == "application/octet-stream") {
                        object8 = new MimeHelper(byArray);
                        object7 = ((MimeHelper)object8).getMimeType();
                        object11 = object7 != null ? object7 : "application/octet-stream";
                        element.setAttributeNS(null, "MimeType", (String)object11);
                    }
                    element.setTextContent(Base64.encode(byArray));
                    bl10 = true;
                }
                bl9 = true;
                string12 = "http://www.w3.org/2000/09/xmldsig#base64";
                element.setAttributeNS(null, "Encoding", string12);
            }
            catch (Exception exception2) {
                throw new AOException("Error al convertir los datos a base64", exception2);
            }
        }
        object10 = "#" + (string5 != null ? string5 : string13);
        object9 = "#" + string14;
        object8 = null;
        try {
            object8 = documentBuilderFactory.newDocumentBuilder().newDocument();
            if (string6.equals("XAdES Enveloped")) {
                object8.appendChild(object8.adoptNode(element));
            } else {
                object8.appendChild(object8.createElement("AFIRMA"));
            }
        }
        catch (Exception exception) {
            throw new AOException("Error al crear la firma en formato " + string6 + ": " + exception, exception);
        }
        object7 = new ArrayList<Object>();
        object6 = Utils.getDOMFactory();
        try {
            digestMethod = ((XMLSignatureFactory)object6).newDigestMethod(string7, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string7 + "'", exception);
        }
        String string15 = "Reference-" + UUID.randomUUID().toString();
        String string16 = "StyleReference-" + UUID.randomUUID().toString();
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        Utils.addCustomTransforms(arrayList, properties2, "ds");
        try {
            transform = ((XMLSignatureFactory)object6).newTransform(string8, (TransformParameterSpec)null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha posido crear el canonizador para el algoritmo indicado (" + string8 + "): " + exception, exception);
        }
        if (!bl9) {
            if (!bl8) {
                try {
                    arrayList.add(transform);
                }
                catch (Exception exception) {
                    throw new AOException("No se puede encontrar el algoritmo de canonicalizacion: " + exception, exception);
                }
            }
        } else if (bl10 && !bl4) {
            try {
                arrayList.add(((XMLSignatureFactory)object6).newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null));
            }
            catch (Exception exception) {
                throw new AOException("No se puede encontrar el algoritmo transformacion Base64: " + exception, exception);
            }
        }
        XMLObject xMLObject = null;
        XMLObject xMLObject2 = null;
        if (string6.equals("XAdES Enveloping")) {
            try {
                object5 = new ArrayList<DOMStructure>(1);
                object5.add(new DOMStructure(bl9 ? element.getFirstChild() : element));
                object4 = "Object-" + UUID.randomUUID().toString();
                xMLObject = ((XMLSignatureFactory)object6).newXMLObject((List<? extends XMLStructure>)object5, (String)object4, (String)object11, string12);
                object7.add(((XMLSignatureFactory)object6).newReference("#" + (String)(string5 != null ? string5 : object4), digestMethod, arrayList, "http://www.w3.org/2000/09/xmldsig#Object", string15));
                if (xmlStyle.getStyleElement() != null) {
                    object3 = "StyleObject-" + UUID.randomUUID().toString();
                    xMLObject2 = ((XMLSignatureFactory)object6).newXMLObject(Collections.singletonList(new DOMStructure(xmlStyle.getStyleElement())), (String)object3, xmlStyle.getStyleType(), xmlStyle.getStyleEncoding());
                    object7.add(((XMLSignatureFactory)object6).newReference("#" + (String)object3, digestMethod, Collections.singletonList(transform), "http://www.w3.org/2000/09/xmldsig#Object", string16));
                }
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato enveloping", exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object7.add(((XMLSignatureFactory)object6).newReference(xmlStyle.getStyleHref(), digestMethod, Collections.singletonList(transform), null, string16));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + exception);
                }
            }
        } else if (string6.equals("XAdES Detached")) {
            try {
                if (element != null) {
                    object8.getDocumentElement().appendChild(object8.adoptNode(element));
                    object7.add(((XMLSignatureFactory)object6).newReference((String)object10, digestMethod, arrayList, null, string15));
                }
                if (xmlStyle.getStyleElement() != null) {
                    object8.getDocumentElement().appendChild(object8.adoptNode(xmlStyle.getStyleElement()));
                    object7.add(((XMLSignatureFactory)object6).newReference((String)object9, digestMethod, Collections.singletonList(transform), null, string16));
                }
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato detached: " + exception, exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object7.add(((XMLSignatureFactory)object6).newReference(xmlStyle.getStyleHref(), digestMethod, Collections.singletonList(transform), null, string16));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + exception);
                }
            }
        } else if (string6.equals("XAdES Externally Detached")) {
            object5 = null;
            if (string11 != null && (uRI == null || uRI.getScheme().equals("") || uRI.getScheme().equals("file"))) {
                object4 = null;
                try {
                    if (AOSignConstants.getDigestAlgorithmName(string11).equalsIgnoreCase("SHA1")) {
                        object4 = ((XMLSignatureFactory)object6).newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(string11).equalsIgnoreCase("SHA-256")) {
                        object4 = ((XMLSignatureFactory)object6).newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(string11).equalsIgnoreCase("SHA-512")) {
                        object4 = ((XMLSignatureFactory)object6).newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(string11).equalsIgnoreCase("RIPEMD160")) {
                        object4 = ((XMLSignatureFactory)object6).newDigestMethod("http://www.w3.org/2001/04/xmlenc#ripemd160", null);
                    }
                }
                catch (Exception exception) {
                    throw new AOException("No se ha podido crear el metodo de huella digital para la referencia Externally Detached: " + exception, exception);
                }
                if (object4 == null) {
                    throw new AOException("Metodo de Message Digest para la referencia Externally Detached no soportado: " + string11);
                }
                object5 = ((XMLSignatureFactory)object6).newReference("", (DigestMethod)object4, null, null, string15, byArray);
            } else {
                if (uRI != null && uRI.getScheme().equals("file")) {
                    try {
                        object5 = ((XMLSignatureFactory)object6).newReference("", digestMethod, null, null, string15, MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string7)).digest(AOUtil.getDataFromInputStream(AOUtil.loadFile(uRI))));
                    }
                    catch (Exception exception) {
                        throw new AOException("No se ha podido crear la referencia XML a partir de la URI local (" + uRI.toASCIIString() + "): " + exception, exception);
                    }
                }
                if (uRI != null) {
                    try {
                        object5 = ((XMLSignatureFactory)object6).newReference(uRI.toASCIIString(), digestMethod);
                    }
                    catch (Exception exception) {
                        throw new AOException("No se ha podido crear la referencia Externally Detached, probablemente por no obtenerse el metodo de digest: " + exception, exception);
                    }
                }
            }
            if (object5 == null) {
                throw new AOException("Error al generar la firma Externally Detached, no se ha podido crear la referencia externa");
            }
            object7.add(object5);
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null) {
                if (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX)) {
                    try {
                        object7.add(((XMLSignatureFactory)object6).newReference(xmlStyle.getStyleHref(), digestMethod, Collections.singletonList(transform), null, string16));
                    }
                    catch (Exception exception) {
                        LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + exception);
                    }
                } else {
                    LOGGER.warning("Se necesita una referencia externa HTTP o HTTPS a la hoja de estilo para referenciarla en firmas XML Externally Detached");
                }
            }
        } else if (string6.equals("XAdES Enveloped")) {
            try {
                arrayList.add(((XMLSignatureFactory)object6).newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                if (!bl8) {
                    arrayList.add(((XMLSignatureFactory)object6).newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("not(ancestor-or-self::ds:Signature)", Collections.singletonMap("ds", "http://www.w3.org/2000/09/xmldsig#"))));
                }
                object7.add(((XMLSignatureFactory)object6).newReference(string5 != null ? "#" + string5 : "", digestMethod, arrayList, null, string15));
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato enveloped: " + exception, exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object7.add(((XMLSignatureFactory)object6).newReference(xmlStyle.getStyleHref(), digestMethod, Collections.singletonList(transform), null, string16));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML, esta no se firmara: " + exception);
                }
            }
        }
        object5 = null;
        if (string4 != null && "XAdES Enveloped".equals(string6)) {
            object5 = XAdESUtil.getFirstElmentFromXPath(string4, object8.getDocumentElement());
        }
        object4 = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, string9, "xades", "ds", string7, (Document)object8, (Element)(object5 != null ? object5 : object8.getDocumentElement()));
        object4.setSigningCertificate((X509Certificate)certificateArray[0]);
        object3 = AOXAdESSigner.getPolicy(properties2.getProperty("policyIdentifier"), properties2.getProperty("policyIdentifierHash"), properties2.getProperty("policyIdentifierHashAlgorithm"), properties2.getProperty("policyDescription"), properties2.getProperty("policyQualifier"));
        if (object3 != null) {
            object4.setSignaturePolicyIdentifier((SignaturePolicyIdentifier)object3);
        }
        if ((signatureProductionPlace = AOXAdESSigner.getSignatureProductionPlace(properties2.getProperty("signatureProductionCity"), properties2.getProperty("signatureProductionProvince"), properties2.getProperty("signatureProductionPostalCode"), properties2.getProperty("signatureProductionCountry"))) != null) {
            object4.setSignatureProductionPlace(signatureProductionPlace);
        }
        SignerRoleImpl signerRoleImpl = null;
        try {
            string2 = properties2.getProperty("signerClaimedRole");
            object2 = properties2.getProperty("signerCertifiedRole");
            signerRoleImpl = new SignerRoleImpl();
            if (string2 != null) {
                signerRoleImpl.addClaimedRole(string2);
            }
            if (object2 != null) {
                signerRoleImpl.addCertifiedRole((String)object2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (signerRoleImpl != null) {
            object4.setSignerRole(signerRoleImpl);
        }
        if (Boolean.parseBoolean(properties2.getProperty("applySystemDate", Boolean.TRUE.toString()))) {
            object4.setSigningTime(new Date());
        }
        if ((string2 = properties2.getProperty("contentTypeOid")) == null && object11 != null) {
            try {
                string2 = MimeHelper.transformMimeTypeToOid((String)object11);
            }
            catch (Exception exception) {
                LOGGER.warning("Error en la obtencion del OID del tipo de datos a partir del MimeType: " + exception);
            }
            if (!"application/octet-stream".equals(object11) && "1.2.840.113549.1.7.1".equals(string2)) {
                string2 = null;
            }
        }
        object2 = string2 != null ? new ObjectIdentifierImpl("OIDAsURN", (string2.startsWith("urn:oid:") ? "" : "urn:oid:") + string2, null, new ArrayList<String>(0)) : null;
        ArrayList<DataObjectFormat> arrayList2 = new ArrayList<DataObjectFormat>();
        DataObjectFormatImpl dataObjectFormatImpl = new DataObjectFormatImpl(null, (ObjectIdentifier)object2, (String)object11, string12, "#" + string15);
        arrayList2.add(dataObjectFormatImpl);
        object4.setDataObjectFormats(arrayList2);
        try {
            aOXMLAdvancedSignature = AOXMLAdvancedSignature.newInstance((XAdES_BES)object4);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido instanciar la firma XML Avanzada de JXAdES", exception);
        }
        aOXMLAdvancedSignature.setSignedPropertiesTypeUrl(string10);
        try {
            aOXMLAdvancedSignature.setDigestMethod(string7);
            aOXMLAdvancedSignature.setCanonicalizationMethod(string8);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido establecer el algoritmo de huella digital (" + string3 + "): " + exception, exception);
        }
        if (string6.equals("XAdES Enveloping")) {
            aOXMLAdvancedSignature.addXMLObject(xMLObject);
            if (xMLObject2 != null) {
                aOXMLAdvancedSignature.addXMLObject(xMLObject2);
            }
        }
        if (string6.equals("XAdES Enveloped") && xmlStyle.getStyleElement() != null) {
            aOXMLAdvancedSignature.addStyleSheetEnvelopingOntoSignature(xmlStyle, string14);
            try {
                object7.add(((XMLSignatureFactory)object6).newReference((String)object9, digestMethod, Collections.singletonList(transform), null, string16));
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido anadir una referencia a la hoja de estilo, esta se incluira dentro de la firma, pero no estara firmada: " + exception);
            }
        }
        if (bl2) {
            object = new LinkedList<Manifest>();
            object.add(((XMLSignatureFactory)object6).newManifest(new ArrayList(object7)));
            String string17 = "Manifest-" + UUID.randomUUID().toString();
            aOXMLAdvancedSignature.addXMLObject(((XMLSignatureFactory)object6).newXMLObject((List<? extends XMLStructure>)object, string17, null, null));
            object7.clear();
            object7.add(((XMLSignatureFactory)object6).newReference("#" + string17, digestMethod, Collections.singletonList(transform), "http://www.w3.org/2000/09/xmldsig#Object", string15));
        }
        try {
            aOXMLAdvancedSignature.sign(bl ? Arrays.asList((X509Certificate)certificateArray[0]) : Arrays.asList((X509Certificate[])certificateArray), privateKey, string3, (List<?>)object7, "Signature-" + UUID.randomUUID().toString(), bl6, bl7);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "':" + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la firma XAdES: " + exception, exception);
        }
        if (string6.equals("XAdES Enveloping")) {
            try {
                if (object8.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength() == 1) {
                    object = documentBuilderFactory.newDocumentBuilder().newDocument();
                    object.appendChild(object.adoptNode(object8.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)));
                    object8 = object;
                }
            }
            catch (Exception exception) {
                LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + exception);
            }
        }
        return Utils.writeXML(object8.getDocumentElement(), hashtable, string6.equals("XAdES Enveloped") ? xmlStyle.getStyleHref() : null, string6.equals("XAdES Enveloped") ? xmlStyle.getStyleType() : null);
    }

    private XAdESSigner() {
    }
}

