/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.xades.security.xml.XAdES.DataObjectFormat;
import net.java.xades.security.xml.XAdES.DataObjectFormatImpl;
import net.java.xades.security.xml.XAdES.ObjectIdentifier;
import net.java.xades.security.xml.XAdES.ObjectIdentifierImpl;
import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifier;
import net.java.xades.security.xml.XAdES.SignatureProductionPlace;
import net.java.xades.security.xml.XAdES.SignerRoleImpl;
import net.java.xades.security.xml.XAdES.XAdES;
import net.java.xades.security.xml.XAdES.XAdES_BES;
import net.java.xades.security.xml.XAdES.XAdES_EPES;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XAdESCounterSigner {
    private static final String CSURI = "http://uri.etsi.org/01903#CountersignedSignature";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public static byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Element element;
        Object object;
        Object object2;
        Properties properties2 = properties != null ? properties : new Properties();
        String string2 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string2)) {
            string2 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        if (byArray == null) {
            throw new IllegalArgumentException("El objeto de firma no puede ser nulo");
        }
        String string3 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        boolean bl = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            DocumentType documentType;
            object2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            if (string2 == null) {
                string2 = object2.getXmlEncoding();
            }
            if (string2 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equals(string2)) {
                hashtable.put("encoding", string2);
            }
            if ((object = object2.getXmlVersion()) != null) {
                hashtable.put("version", (String)object);
            }
            if ((documentType = object2.getDoctype()) != null && (object = documentType.getSystemId()) != null) {
                hashtable.put("doctype-system", (String)object);
            }
            if ((element = object2.getDocumentElement()).getNodeName().equals("ds:Signature")) {
                bl = true;
                object2 = AOXAdESSigner.insertarNodoAfirma((Document)object2);
                element = object2.getDocumentElement();
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
        try {
            if (counterSignTarget == CounterSignTarget.TREE) {
                XAdESCounterSigner.countersignTree(element, privateKey, certificateArray, properties2, string, (Document)object2);
            } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                XAdESCounterSigner.countersignLeafs(element, privateKey, certificateArray, properties2, string, (Document)object2);
            } else if (counterSignTarget == CounterSignTarget.NODES) {
                XAdESCounterSigner.countersignNodes(element, objectArray, privateKey, certificateArray, properties2, string, (Document)object2);
            } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                XAdESCounterSigner.countersignSigners(element, objectArray, privateKey, certificateArray, properties2, string, (Document)object2);
            }
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la contrafirma", exception);
        }
        if (bl) {
            try {
                object = documentBuilderFactory.newDocumentBuilder().newDocument();
                object.appendChild(object.adoptNode(object2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)));
                object2 = object;
            }
            catch (Exception exception) {
                LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + exception);
            }
        }
        return Utils.writeXML(object2.getDocumentElement(), hashtable, null, null);
    }

    private static void countersignLeafs(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = nodeList.getLength();
        try {
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                int n2 = element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength();
                if (n2 != 0) continue;
                XAdESCounterSigner.cs(element2, privateKey, certificateArray, properties, string, document);
                ++n;
                ++i;
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma de hojas", exception);
        }
    }

    private static void countersignNodes(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (arrayList.contains(objectArray[i])) continue;
            arrayList.add((Integer)objectArray[i]);
        }
        Object[] objectArray2 = arrayList.toArray();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element[] elementArray = new Element[objectArray2.length];
        try {
            for (int i = 0; i < objectArray2.length; ++i) {
                elementArray[i] = (Element)nodeList.item((Integer)objectArray2[i]);
                if (elementArray[i] != null) continue;
                throw new AOException("Posicion de nodo no valida.");
            }
        }
        catch (ClassCastException classCastException) {
            throw new AOException("Valor de nodo no valido", classCastException);
        }
        try {
            for (Element element2 : elementArray) {
                XAdESCounterSigner.cs(element2, privateKey, certificateArray, properties, string, document);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma de nodos", exception);
        }
    }

    private static void countersignSigners(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        List<Object> list = Arrays.asList(objectArray);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!list.contains(AOUtil.getCN(Utils.getCertificate(element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0))))) continue;
            arrayList.add(element2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XAdESCounterSigner.cs((Element)iterator.next(), privateKey, certificateArray, properties, string, document);
        }
    }

    private static void countersignTree(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        int n;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n2 = nodeList.getLength();
        Element[] elementArray = new Element[n2];
        for (n = 0; n < n2; ++n) {
            elementArray[n] = (Element)nodeList.item(n);
        }
        try {
            for (n = 0; n < n2; ++n) {
                XAdESCounterSigner.cs(elementArray[n], privateKey, certificateArray, properties, string, document);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma del arbol", exception);
        }
    }

    private static void cs(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        AOXMLAdvancedSignature aOXMLAdvancedSignature;
        Object object;
        Object object2;
        SignatureProductionPlace signatureProductionPlace;
        Object object3;
        DigestMethod digestMethod;
        String string2 = Utils.guessXAdESNamespacePrefix(element);
        if (document == null) {
            throw new IllegalArgumentException("El documento DOM no puede ser nulo");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2000/09/xmldsig#sha1");
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string6 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        Element element2 = document.createElement(string2 + ":CounterSignature");
        NodeList nodeList = element.getElementsByTagNameNS("*", "UnsignedSignatureProperties");
        Element element3 = nodeList.getLength() == 0 ? document.createElement(string2 + ":UnsignedSignatureProperties") : (Element)nodeList.item(0);
        element3.appendChild(element2);
        NodeList nodeList2 = element.getElementsByTagNameNS("*", "UnsignedProperties");
        Element element4 = nodeList2.getLength() == 0 ? document.createElement(string2 + ":UnsignedProperties") : (Element)nodeList2.item(0);
        element4.appendChild(element3);
        Node node = element.getElementsByTagNameNS("*", "QualifyingProperties").item(0);
        node.appendChild(element4);
        Element element5 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string3, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string3 + "'", exception);
        }
        String string7 = "Reference-" + UUID.randomUUID().toString();
        try {
            object3 = new ArrayList<Transform>();
            object3.add(xMLSignatureFactory.newTransform(string4, (TransformParameterSpec)null));
            arrayList.add(xMLSignatureFactory.newReference("#" + element5.getAttribute("Id"), digestMethod, (List<? extends Transform>)object3, CSURI, string7));
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
        object3 = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, string5, string2, "ds", string3, element2.getOwnerDocument(), element2);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        object3.setSigningCertificate(x509Certificate);
        SignaturePolicyIdentifier signaturePolicyIdentifier = AOXAdESSigner.getPolicy(properties2.getProperty("policyIdentifier"), properties2.getProperty("policyIdentifierHash"), properties2.getProperty("policyIdentifierHashAlgorithm"), properties2.getProperty("policyDescription"), properties2.getProperty("policyQualifier"));
        if (signaturePolicyIdentifier != null) {
            object3.setSignaturePolicyIdentifier(signaturePolicyIdentifier);
        }
        if ((signatureProductionPlace = AOXAdESSigner.getSignatureProductionPlace(properties2.getProperty("signatureProductionCity"), properties2.getProperty("signatureProductionProvince"), properties2.getProperty("signatureProductionPostalCode"), properties2.getProperty("signatureProductionCountry"))) != null) {
            object3.setSignatureProductionPlace(signatureProductionPlace);
        }
        SignerRoleImpl signerRoleImpl = null;
        try {
            object2 = properties2.getProperty("signerClaimedRole");
            object = properties2.getProperty("signerCertifiedRole");
            signerRoleImpl = new SignerRoleImpl();
            if (object2 != null) {
                signerRoleImpl.addClaimedRole((String)object2);
            }
            if (object != null) {
                signerRoleImpl.addCertifiedRole((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (signerRoleImpl != null) {
            object3.setSignerRole(signerRoleImpl);
        }
        if (Boolean.parseBoolean(properties2.getProperty("applySystemDate", Boolean.TRUE.toString()))) {
            object3.setSigningTime(new Date());
        }
        object2 = new ObjectIdentifierImpl("OIDAsURN", "urn:oid:1.2.840.10003.5.109.10", null, new ArrayList<String>(0));
        object = new DataObjectFormatImpl(null, (ObjectIdentifier)object2, "text/xml", document.getInputEncoding(), "#" + string7);
        ArrayList<DataObjectFormat> arrayList2 = new ArrayList<DataObjectFormat>();
        arrayList2.add((DataObjectFormat)object);
        object3.setDataObjectFormats(arrayList2);
        try {
            aOXMLAdvancedSignature = AOXMLAdvancedSignature.newInstance((XAdES_BES)object3);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido instanciar la firma Avanzada XML JXAdES", exception);
        }
        aOXMLAdvancedSignature.setSignedPropertiesTypeUrl(string6);
        try {
            aOXMLAdvancedSignature.setDigestMethod(string3);
            aOXMLAdvancedSignature.setCanonicalizationMethod(string4);
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido establecer el algoritmo de huella digital (" + XMLConstants.SIGN_ALGOS_URI.get(string) + "), es posible que el usado en la firma difiera del indicado: " + exception);
        }
        try {
            boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (bl) {
                aOXMLAdvancedSignature.sign((X509Certificate)certificateArray[0], privateKey, XMLConstants.SIGN_ALGOS_URI.get(string), arrayList, "Signature-" + UUID.randomUUID().toString());
            } else {
                aOXMLAdvancedSignature.sign(Arrays.asList((X509Certificate[])certificateArray), privateKey, XMLConstants.SIGN_ALGOS_URI.get(string), arrayList, "Signature-" + UUID.randomUUID().toString(), Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.FALSE.toString())), Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString())));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'", noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", exception);
        }
    }

    private XAdESCounterSigner() {
    }
}

