/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.xades.security.xml.XAdES.DataObjectFormat;
import net.java.xades.security.xml.XAdES.DataObjectFormatImpl;
import net.java.xades.security.xml.XAdES.ObjectIdentifierImpl;
import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifier;
import net.java.xades.security.xml.XAdES.SignatureProductionPlace;
import net.java.xades.security.xml.XAdES.SignerRole;
import net.java.xades.security.xml.XAdES.SignerRoleImpl;
import net.java.xades.security.xml.XAdES.XAdES;
import net.java.xades.security.xml.XAdES.XAdES_EPES;
import net.java.xades.security.xml.XAdES.XMLAdvancedSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XAdESCoSigner {
    private XAdESCoSigner() {
    }

    public static byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        DigestMethod digestMethod;
        Element element;
        Document document;
        String string2 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2000/09/xmldsig#sha1");
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string6 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        boolean bl = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.FALSE.toString()));
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString()));
        String string7 = properties2.getProperty("mimeType");
        String string8 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string8)) {
            string8 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        String string9 = properties2.getProperty("contentTypeOid");
        ObjectIdentifierImpl objectIdentifierImpl = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            element = document.getDocumentElement();
            if (element.getNodeName().equals("ds:Signature")) {
                document = AOXAdESSigner.insertarNodoAfirma(document);
                element = document.getDocumentElement();
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido leer el documento XML de firmas", exception);
        }
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string3, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string3 + "'", exception);
        }
        XMLObject xMLObject = null;
        boolean bl3 = false;
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        NodeList nodeList = ((Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        String string10 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            object6 = node.getAttributes();
            if (i != 0 && (object6.getNamedItem("Id") == null || !object6.getNamedItem("Id").getNodeValue().startsWith("StyleReference-"))) continue;
            try {
                object5 = Utils.getObjectReferenceTransforms(node, "ds");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("Se ha declarado una transformacion personalizada de un tipo no soportado", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new AOException("Se han especificado parametros erroneos para una transformacion personalizada", invalidAlgorithmParameterException);
            }
            string10 = object6.getNamedItem("Id") != null && object6.getNamedItem("Id").getNodeValue().startsWith("StyleReference-") ? "StyleReference-" + UUID.randomUUID().toString() : "Reference-" + UUID.randomUUID().toString();
            object4 = ((Element)node).getAttribute("URI");
            if ("".equals(object4)) {
                if (string7 == null) {
                    string7 = "text/xml";
                }
                if (string8 == null) {
                    string8 = document.getInputEncoding();
                }
                arrayList.add(xMLSignatureFactory.newReference(((Element)node).getAttribute("URI"), digestMethod, (List<? extends Transform>)object5, "http://www.w3.org/2000/09/xmldsig#Object", string10));
            } else {
                Object object7;
                int n;
                NodeList nodeList2;
                Node node2;
                object3 = ((String)object4).substring(((String)object4).startsWith("#") ? 1 : 0);
                object2 = null;
                object = document.getDocumentElement();
                Node node3 = node2 = object.getAttributes() != null ? object.getAttributes().getNamedItem("Id") : null;
                if (node2 != null && ((String)object3).equals(node2.getNodeValue())) {
                    object2 = object;
                } else {
                    nodeList2 = object.getChildNodes();
                    for (n = nodeList2.getLength() - 1; n >= 0; --n) {
                        Node node4 = node2 = nodeList2.item(n).getAttributes() != null ? nodeList2.item(n).getAttributes().getNamedItem("Id") : null;
                        if (node2 != null && ((String)object3).equals(node2.getNodeValue())) {
                            object2 = (Element)nodeList2.item(n);
                            break;
                        }
                        if (!"Signature".equals(nodeList2.item(n).getLocalName())) continue;
                        object7 = nodeList2.item(n).getChildNodes();
                        for (int j = object7.getLength() - 1; j >= 0; --j) {
                            Node node5 = node2 = object7.item(j).getAttributes() != null ? object7.item(j).getAttributes().getNamedItem("Id") : null;
                            if (node2 == null || !((String)object3).equals(node2.getNodeValue())) continue;
                            object2 = (Element)object7.item(j);
                            break;
                        }
                        if (object2 != null) break;
                    }
                }
                if (object2 != null) {
                    if (string7 == null) {
                        string7 = object2.getAttribute("MimeType");
                    }
                    if (string8 == null) {
                        string8 = object2.getAttribute("Encoding");
                    }
                }
                nodeList2 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0).getChildNodes();
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    Node node6;
                    object7 = nodeList2.item(n);
                    NamedNodeMap namedNodeMap = object7.getAttributes();
                    if (namedNodeMap == null || (node6 = namedNodeMap.getNamedItem("Id")) == null || !((String)object3).equals(node6.getNodeValue())) continue;
                    bl3 = true;
                }
                if (bl3 && object2 != null) {
                    ArrayList<DOMStructure> arrayList2 = new ArrayList<DOMStructure>(1);
                    arrayList2.add(new DOMStructure(object2.getFirstChild().cloneNode(true)));
                    object7 = "Object-" + UUID.randomUUID().toString();
                    xMLObject = xMLSignatureFactory.newXMLObject(arrayList2, (String)object7, string7, string8);
                    arrayList.add(xMLSignatureFactory.newReference("#" + (String)object7, digestMethod, (List<? extends Transform>)object5, "http://www.w3.org/2000/09/xmldsig#Object", string10));
                } else {
                    arrayList.add(xMLSignatureFactory.newReference(((Element)node).getAttribute("URI"), digestMethod, (List<? extends Transform>)object5, "http://www.w3.org/2000/09/xmldsig#Object", string10));
                }
            }
            if (string9 == null && string7 != null) {
                try {
                    string9 = MimeHelper.transformMimeTypeToOid(string7);
                }
                catch (IOException iOException) {
                    AOXAdESSigner.LOGGER.warning("Error en la obtencion del OID del tipo de datos a partir del MimeType: " + iOException);
                }
            }
            if (string9 == null) continue;
            objectIdentifierImpl = new ObjectIdentifierImpl("OIDAsURN", (string9.startsWith("urn:oid:") ? "" : "urn:oid:") + string9, null, new ArrayList<String>(0));
        }
        XAdES_EPES xAdES_EPES = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, string5, "xades", "ds", string3, element.getOwnerDocument(), element);
        object6 = (X509Certificate)certificateArray[0];
        xAdES_EPES.setSigningCertificate((X509Certificate)object6);
        object5 = AOXAdESSigner.getPolicy(properties2.getProperty("policyIdentifier"), properties2.getProperty("policyIdentifierHash"), properties2.getProperty("policyIdentifierHashAlgorithm"), properties2.getProperty("policyDescription"), properties2.getProperty("policyQualifier"));
        if (object5 != null) {
            xAdES_EPES.setSignaturePolicyIdentifier((SignaturePolicyIdentifier)object5);
        }
        if ((object4 = AOXAdESSigner.getSignatureProductionPlace(properties2.getProperty("signatureProductionCity"), properties2.getProperty("signatureProductionProvince"), properties2.getProperty("signatureProductionPostalCode"), properties2.getProperty("signatureProductionCountry"))) != null) {
            xAdES_EPES.setSignatureProductionPlace((SignatureProductionPlace)object4);
        }
        object3 = null;
        try {
            object2 = properties2.getProperty("signerClaimedRole");
            object = properties2.getProperty("signerCertifiedRole");
            object3 = new SignerRoleImpl();
            if (object2 != null) {
                object3.addClaimedRole((String)object2);
            }
            if (object != null) {
                object3.addCertifiedRole((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object3 != null) {
            xAdES_EPES.setSignerRole((SignerRole)object3);
        }
        if (Boolean.parseBoolean(properties2.getProperty("applySystemDate", Boolean.TRUE.toString()))) {
            xAdES_EPES.setSigningTime(new Date());
        }
        if (objectIdentifierImpl != null || string7 != null || string8 != null) {
            object2 = new ArrayList();
            object = new DataObjectFormatImpl(null, objectIdentifierImpl, string7, string8, "#" + string10);
            ((ArrayList)object2).add(object);
            xAdES_EPES.setDataObjectFormats((List<DataObjectFormat>)object2);
        }
        try {
            object2 = AOXMLAdvancedSignature.newInstance(xAdES_EPES);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido instanciar la firma Avanzada XML JXAdES", exception);
        }
        ((XMLAdvancedSignature)object2).setSignedPropertiesTypeUrl(string6);
        try {
            ((XMLAdvancedSignature)object2).setDigestMethod(string3);
            ((AOXMLAdvancedSignature)object2).setCanonicalizationMethod(string4);
        }
        catch (Exception exception) {
            AOXAdESSigner.LOGGER.severe("No se ha podido establecer el algoritmo de huella digital (" + string2 + "), es posible que el usado en la firma difiera del indicado: " + exception);
        }
        if (bl3) {
            ((XMLAdvancedSignature)object2).addXMLObject(xMLObject);
        }
        try {
            boolean bl4 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (bl4) {
                ((XMLAdvancedSignature)object2).sign((X509Certificate)certificateArray[0], privateKey, string2, arrayList, "Signature-" + UUID.randomUUID().toString());
            } else {
                ((AOXMLAdvancedSignature)object2).sign(Arrays.asList((X509Certificate[])certificateArray), privateKey, string2, arrayList, "Signature-" + UUID.randomUUID().toString(), bl, bl2);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("No se soporta el algoritmo de firma '" + string + "': " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la cofirma", exception);
        }
        return Utils.writeXML(element, hashtable, null, null);
    }
}

