/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.signers.xml.CustomUriDereferencer;
import es.gob.afirma.signers.xml.style.XmlStyle;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import net.java.xades.security.xml.WrappedKeyStorePlace;
import net.java.xades.security.xml.XAdES.XAdES_BES;
import net.java.xades.security.xml.XAdES.XMLAdvancedSignature;
import net.java.xades.security.xml.XmlWrappedKeyInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class AOXMLAdvancedSignature
extends XMLAdvancedSignature {
    static final Logger LOGGER = Logger.getLogger("es.agob.afirma");
    private String canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private Element styleElement = null;
    private String styleType = "text/xsl";
    private String styleEncoding = null;
    private String styleId = null;

    private AOXMLAdvancedSignature(XAdES_BES xAdES_BES) {
        super(xAdES_BES);
    }

    void addStyleSheetEnvelopingOntoSignature(XmlStyle xmlStyle, String string) {
        this.styleElement = xmlStyle.getStyleElement();
        if (xmlStyle.getStyleType() != null) {
            this.styleType = xmlStyle.getStyleType();
        }
        this.styleId = string;
        this.styleEncoding = xmlStyle.getStyleEncoding();
    }

    void setCanonicalizationMethod(String string) {
        if (string != null) {
            this.canonicalizationMethod = string;
        }
    }

    private KeyInfo newKeyInfo(List<X509Certificate> list, String string, boolean bl, boolean bl2) throws KeyException {
        KeyInfoFactory keyInfoFactory = this.getXMLSignatureFactory().getKeyInfoFactory();
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        if (!XmlWrappedKeyInfo.PUBLIC_KEY.equals((Object)this.getXmlWrappedKeyInfo())) {
            for (X509Certificate x509Certificate : list) {
                arrayList.add(x509Certificate);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(keyInfoFactory.newKeyValue(list.get(0).getPublicKey()));
        arrayList2.add(keyInfoFactory.newX509Data(arrayList));
        if (bl) {
            arrayList2.add(keyInfoFactory.newKeyValue(list.get(0).getPublicKey()));
        }
        if (bl2) {
            arrayList2.add(keyInfoFactory.newKeyName(AOUtil.getCN(list.get(0)).replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00f1", "n").replace("\u00d1", "N").replace("\u00e7", "c").replace("\u00c7", "C")));
        }
        return keyInfoFactory.newKeyInfo(arrayList2, string);
    }

    void sign(List<X509Certificate> list, PrivateKey privateKey, String string, List<?> list2, String string2, boolean bl, boolean bl2) throws MarshalException, GeneralSecurityException, XMLSignatureException {
        ArrayList arrayList = new ArrayList(list2);
        if (WrappedKeyStorePlace.SIGNING_CERTIFICATE_PROPERTY.equals((Object)this.getWrappedKeyStorePlace()) && list != null && list.size() > 0) {
            this.xades.setSigningCertificate(list.get(0));
        }
        this.addXMLObject(this.marshalXMLSignature(this.xadesNamespace, this.signedPropertiesTypeUrl, string2, arrayList));
        XMLSignatureFactory xMLSignatureFactory = this.getXMLSignatureFactory();
        if (this.styleElement != null && this.styleId != null) {
            this.addXMLObject(xMLSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(this.styleElement)), this.styleId, this.styleType, this.styleEncoding));
        }
        List<Reference> list3 = this.getReferences(arrayList);
        String string3 = this.getKeyInfoId(string2);
        list3.add(xMLSignatureFactory.newReference("#" + string3, this.getDigestMethod()));
        this.signature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(this.canonicalizationMethod, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(string, null), list3), this.newKeyInfo(list, string3, bl, bl2), this.getXMLObjects(), this.getSignatureId(string2), this.getSignatureValueId(string2));
        this.signContext = new DOMSignContext(privateKey, (Node)this.baseElement);
        this.signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.xades.getXmlSignaturePrefix());
        this.signContext.putNamespacePrefix(this.xadesNamespace, this.xades.getXadesPrefix());
        try {
            this.signContext.setURIDereferencer(new CustomUriDereferencer(CustomUriDereferencer.getDefaultDereferencer()));
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + exception);
        }
        this.signature.sign(this.signContext);
    }

    public static AOXMLAdvancedSignature newInstance(XAdES_BES xAdES_BES) throws GeneralSecurityException {
        AOXMLAdvancedSignature aOXMLAdvancedSignature = new AOXMLAdvancedSignature(xAdES_BES);
        aOXMLAdvancedSignature.setDigestMethod(xAdES_BES.getDigestMethod());
        aOXMLAdvancedSignature.setXadesNamespace(xAdES_BES.getXadesNamespace());
        return aOXMLAdvancedSignature;
    }
}

