/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.EFacturaAlreadySignedException;
import es.gob.afirma.signers.xades.InvalidEFacturaDataException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AOFacturaESigner
implements AOSigner {
    private static final AOSigner XADES_SIGNER = new AOXAdESSigner();
    private static final Set<String> ALLOWED_PARAMS = new HashSet<String>(5);
    private static final Properties EXTRA_PARAMS;

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la cofirma de facturas");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la cofirma de facturas");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la contrafirma de facturas");
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        if (!this.isValidDataFile(byArray)) {
            throw new InvalidEFacturaDataException();
        }
        if (this.isSign(byArray)) {
            throw new EFacturaAlreadySignedException();
        }
        Properties properties2 = (Properties)EXTRA_PARAMS.clone();
        if (properties != null) {
            for (Object object : properties.keySet()) {
                if (!ALLOWED_PARAMS.contains(object)) continue;
                properties2.put(object, properties.get(object));
            }
        }
        return XADES_SIGNER.sign(byArray, string, privateKey, certificateArray, properties2);
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        return XADES_SIGNER.getSignersStructure(byArray, bl);
    }

    @Override
    public boolean isSign(byte[] byArray) throws IOException {
        return XADES_SIGNER.isSign(byArray) && this.isValidDataFile(byArray);
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            Element element = document.getDocumentElement();
            String string = element.getPrefix();
            if (!((string != null ? string + ":" : "") + "Facturae").equals(element.getNodeName())) {
                return false;
            }
            HashSet<String> hashSet = new HashSet<String>(3);
            hashSet.add("FileHeader");
            hashSet.add("Parties");
            hashSet.add("Invoices");
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2 = nodeList.item(i).getNodeName();
                if (!hashSet.contains(string2)) continue;
                hashSet.remove(string2);
            }
            if (hashSet.size() > 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return XADES_SIGNER.getSignedName(string, string2);
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOException, IOException {
        return XADES_SIGNER.getData(byArray);
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException, IOException {
        AOSignInfo aOSignInfo = new AOSignInfo("FacturaE");
        aOSignInfo.setVariant(null);
        return aOSignInfo;
    }

    static {
        ALLOWED_PARAMS.add("signerCertifiedRole");
        ALLOWED_PARAMS.add("signatureProductionCity");
        ALLOWED_PARAMS.add("signatureProductionProvince");
        ALLOWED_PARAMS.add("signatureProductionPostalCode");
        ALLOWED_PARAMS.add("signatureProductionCountry");
        EXTRA_PARAMS = new Properties();
        EXTRA_PARAMS.setProperty("format", "XAdES Enveloped");
        EXTRA_PARAMS.setProperty("mode", "implicit");
        EXTRA_PARAMS.setProperty("policyIdentifier", "http://www.facturae.es/politica_de_firma_formato_facturae/politica_de_firma_formato_facturae_v3_1.pdf");
        EXTRA_PARAMS.setProperty("policyIdentifierHash", "Ohixl6upD6av8N7pEvDABhEL6hM=");
        EXTRA_PARAMS.setProperty("policyIdentifierHashAlgorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        EXTRA_PARAMS.setProperty("policyDescription", "facturae31");
        EXTRA_PARAMS.setProperty("signerClaimedRole", "emisor");
        EXTRA_PARAMS.setProperty("facturaeSign", "true");
    }
}

