/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.tsp.pkcs7;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.tsp.pkcs7.TsaRequestExtension;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public final class CMSTimestamper {
    public static final String CATCERT_TSP = "http://psis.catcert.net/psis/catcert/tsp";
    public static final String CATCERT_POLICY = "0.4.0.2023.1.1";
    public static final Boolean CATCERT_REQUIRECERT = Boolean.TRUE;
    private static final String SIGNATURE_TIMESTAMP_TOKEN_OID = "1.2.840.113549.1.9.16.2.14";
    private final TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
    private final URI tsaURL;
    private final String tsaUsername;
    private final String tsaPassword;

    public CMSTimestamper(boolean bl, String string, URI uRI, String string2, String string3, TsaRequestExtension[] tsaRequestExtensionArray) {
        if (tsaRequestExtensionArray != null) {
            for (TsaRequestExtension tsaRequestExtension : tsaRequestExtensionArray) {
                this.tsqGenerator.addExtension(new ASN1ObjectIdentifier(tsaRequestExtension.getOid()), tsaRequestExtension.isCritical(), tsaRequestExtension.getValue());
                Logger.getLogger("es.gob.afirma").info("Anadida extension a la solicitud de sello de tiempo: " + tsaRequestExtension);
            }
        }
        this.tsqGenerator.setCertReq(bl);
        this.tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(string));
        this.tsaURL = uRI;
        this.tsaPassword = string3;
        this.tsaUsername = string2;
    }

    public byte[] addTimestamp(byte[] byArray, String string) throws NoSuchAlgorithmException, AOException, IOException {
        CMSSignedData cMSSignedData;
        try {
            cMSSignedData = new CMSSignedData(byArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Los datos de entrada no son un SignedData de CMS: " + exception);
        }
        SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        Collection collection = signerInformationStore.getSigners();
        for (Object e : collection) {
            SignerInformation signerInformation = (SignerInformation)e;
            byte[] byArray2 = this.getTimeStampToken(signerInformation.getSignature(), string);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray2));
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            aSN1InputStream.close();
            DERSet dERSet = new DERSet(aSN1Primitive);
            Attribute attribute = new Attribute(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), (ASN1Set)dERSet);
            Hashtable<ASN1ObjectIdentifier, Attribute> hashtable = new Hashtable<ASN1ObjectIdentifier, Attribute>();
            hashtable.put(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), attribute);
            AttributeTable attributeTable = new AttributeTable(hashtable);
            arrayList.add(SignerInformation.replaceUnsignedAttributes(signerInformation, attributeTable));
        }
        return CMSSignedData.replaceSigners(cMSSignedData, new SignerInformationStore(arrayList)).getEncoded();
    }

    private byte[] getTSAResponse(byte[] byArray) throws IOException {
        if (this.tsaURL.getScheme().equals("socket")) {
            return this.getTSAResponseSocket(byArray);
        }
        if (this.tsaURL.getScheme().equals("http")) {
            return this.getTSAResponseHttp(byArray);
        }
        throw new UnsupportedOperationException("Protocolo de conexion con TSA no soportado: " + this.tsaURL.getScheme());
    }

    private byte[] getTSAResponseSocket(byte[] byArray) throws IOException {
        Socket socket = new Socket(this.tsaURL.getHost(), this.tsaURL.getPort());
        socket.setSoTimeout(500000);
        byte[] byArray2 = CMSTimestamper.getTSAResponseExternalSocket(byArray, socket);
        socket.close();
        return byArray2;
    }

    private static byte[] getTSAResponseExternalSocket(byte[] byArray, Socket socket) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeInt(byArray.length + 1);
        dataOutputStream.writeByte(0);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        socket.getOutputStream().flush();
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        int n = dataInputStream.readInt();
        byte by = dataInputStream.readByte();
        byte[] byArray2 = new byte[n - 1];
        dataInputStream.readFully(byArray2);
        if (by != 5 && by != 6) {
            throw new IOException("Obtenida resuesta incorrecta del servidor TSA: " + new String(byArray2));
        }
        socket.close();
        return byArray2;
    }

    private byte[] getTSAResponseHttp(byte[] byArray) throws IOException {
        Object object;
        URLConnection uRLConnection = this.tsaURL.toURL().openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        uRLConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !"".equals(this.tsaUsername)) {
            object = this.tsaUsername + ":" + this.tsaPassword;
            uRLConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encode(((String)object).getBytes())));
        }
        object = uRLConnection.getOutputStream();
        ((OutputStream)object).write(byArray);
        ((OutputStream)object).flush();
        ((OutputStream)object).close();
        byte[] byArray2 = AOUtil.getDataFromInputStream(uRLConnection.getInputStream());
        String string = uRLConnection.getContentEncoding();
        if (string != null && string.equalsIgnoreCase("base64")) {
            return Base64.decode(new String(byArray2));
        }
        return byArray2;
    }

    private byte[] getTimeStampToken(byte[] byArray, String string) throws AOException, IOException {
        int n;
        TimeStampResponse timeStampResponse;
        TimeStampRequest timeStampRequest = this.tsqGenerator.generate(new ASN1ObjectIdentifier(string != null ? AOAlgorithmID.getOID(string) : X509ObjectIdentifiers.id_SHA1.getId()), byArray, BigInteger.valueOf(System.currentTimeMillis()));
        byte[] byArray2 = timeStampRequest.getEncoded();
        byte[] byArray3 = this.getTSAResponse(byArray2);
        try {
            timeStampResponse = new TimeStampResponse(byArray3);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la respuesta de la TSA", exception);
        }
        try {
            timeStampResponse.validate(timeStampRequest);
        }
        catch (Exception exception) {
            throw new AOException("Error validando la respuesta de la TSA", exception);
        }
        PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
        int n2 = n = pKIFailureInfo == null ? 0 : pKIFailureInfo.intValue();
        if (n != 0) {
            throw new AOException("Respuesta invalida de la TSA ('" + this.tsaURL + "') con el codigo " + n);
        }
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken == null) {
            throw new AOException("La respuesta de la TSA ('" + this.tsaURL + "') no es un sello de tiempo valido: " + new String(byArray3));
        }
        return timeStampToken.getEncoded();
    }
}

