/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import java.util.logging.Logger;

public final class P7ContentSignerParameters {
    private final byte[] data;
    private final String sigAlgo;
    private final byte[] signature;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public P7ContentSignerParameters(byte[] byArray, String string) {
        this.data = (byte[])byArray.clone();
        if (string == null || string.length() < 1) {
            LOGGER.warning("No se especifico algoritmo para la firma CADES, se utilizara SHA1withRSA");
            this.sigAlgo = "SHA1withRSA";
        } else {
            this.sigAlgo = string;
        }
        this.signature = new byte[0];
    }

    public byte[] getContent() {
        return (byte[])this.data.clone();
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }
}

