/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class ObtainContentSignedData {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ObtainContentSignedData() {
    }

    public static byte[] obtainData(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
            SignedData signedData = SignedData.getInstance(aSN1TaggedObject.getObject());
            ContentInfo contentInfo = signedData.getEncapContentInfo();
            if (contentInfo.getContent() != null) {
                byArray2 = ((DEROctetString)contentInfo.getContent()).getOctets();
            } else {
                LOGGER.warning("No existe contenido en esta firma.");
            }
        } else {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
        }
        return byArray2;
    }

    public static byte[] obtainMessageDigest(byte[] byArray, String string) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
            return null;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        SignedData signedData = SignedData.getInstance(aSN1TaggedObject.getObject());
        ASN1Set aSN1Set = signedData.getSignerInfos();
        byte[] byArray2 = null;
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier = signerInfo.getDigestAlgorithm();
            if (!algorithmIdentifier.getAlgorithm().toString().equals(AOAlgorithmID.getOID(string))) continue;
            ASN1Set aSN1Set2 = signerInfo.getAuthenticatedAttributes();
            for (int j = 0; j < aSN1Set2.size(); ++j) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set2.getObjectAt(j);
                DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                if (!CMSAttributes.messageDigest.getId().equals(dERObjectIdentifier2.toString())) continue;
                DERSet dERSet = (DERSet)aSN1Sequence2.getObjectAt(1);
                DEROctetString dEROctetString = (DEROctetString)dERSet.getObjectAt(0);
                byArray2 = dEROctetString.getOctets();
                break;
            }
            if (byArray2 != null) break;
        }
        if (byArray2 == null) {
            LOGGER.warning("No se ha encontrado en la firma una huella digital generada con el algoritmo: " + string);
        }
        return byArray2;
    }
}

