/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class DigestedData
implements ASN1Encodable {
    private final DERInteger version;
    private final AlgorithmIdentifier digestAlgorithm;
    private final ContentInfo contentInfo;
    private final ASN1OctetString digest;

    static DigestedData getInstance(Object object) {
        if (object instanceof DigestedData) {
            return (DigestedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DigestedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Objeto desconocido: " + object.getClass().getName());
    }

    public DigestedData(AlgorithmIdentifier algorithmIdentifier, ContentInfo contentInfo, ASN1OctetString aSN1OctetString) {
        this.version = new DERInteger(0L);
        this.digestAlgorithm = algorithmIdentifier;
        this.contentInfo = contentInfo;
        this.digest = aSN1OctetString;
    }

    public DigestedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.digestAlgorithm = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.contentInfo = ContentInfo.getInstance(enumeration.nextElement());
        this.digest = (ASN1OctetString)enumeration.nextElement();
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm.getAlgorithm().toString();
    }

    ASN1OctetString getDigest() {
        return this.digest;
    }

    public String getContentType() {
        return this.contentInfo.getContentType().toString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithm);
        aSN1EncodableVector.add(this.contentInfo);
        aSN1EncodableVector.add(this.digest);
        return new BERSequence(aSN1EncodableVector);
    }
}

