/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import es.gob.afirma.core.misc.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PdfSignResult
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String fileID;
    private byte[] sign;
    private GregorianCalendar signTime;
    private Properties extraParams;

    protected PdfSignResult() {
        this.fileID = null;
        this.sign = new byte[0];
        this.signTime = new GregorianCalendar();
        this.extraParams = new Properties();
    }

    public void setExtraParams(Properties properties) {
        this.extraParams = properties;
    }

    public PdfSignResult(String string, byte[] byArray, GregorianCalendar gregorianCalendar, Properties properties) {
        if (gregorianCalendar == null || string == null || byArray == null || "".equals(string) || byArray.length < 1) {
            throw new IllegalArgumentException("Es obligatorio proporcionar un MAC, una pre-firma y un momento de firmado");
        }
        this.fileID = string;
        this.sign = (byte[])byArray.clone();
        this.signTime = gregorianCalendar;
        this.extraParams = properties != null ? properties : new Properties();
    }

    Properties getExtraParams() {
        return this.extraParams;
    }

    public String getFileID() {
        return this.fileID;
    }

    public byte[] getSign() {
        return this.sign;
    }

    GregorianCalendar getSignTime() {
        return this.signTime;
    }

    private static String properties2Base64(Properties properties) throws IOException {
        if (properties == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "PAdES");
        return Base64.encode(byteArrayOutputStream.toByteArray());
    }

    private static Properties base642Properties(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        properties.load(new ByteArrayInputStream(Base64.decode(string)));
        return properties;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        DatatypeFactory datatypeFactory;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        StringBuilder stringBuilder = new StringBuilder().append("<signResult>\n").append(" <extraParams>\n").append(PdfSignResult.properties2Base64(this.getExtraParams())).append('\n').append(" </extraParams>\n").append(" <pdfId>\n").append(this.getFileID()).append('\n').append(" </pdfIf>\n").append(" <sign>\n").append(Base64.encode(this.getSign())).append('\n').append(" </sign>\n").append(" <signTime>\n").append(datatypeFactory.newXMLGregorianCalendar(this.getSignTime()).toXMLFormat()).append('\n').append(" </signTime>\n").append("</signResult>");
        objectOutputStream.write(stringBuilder.toString().getBytes());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DatatypeFactory datatypeFactory;
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(objectInputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        NodeList nodeList = document.getChildNodes();
        int n = PdfSignResult.getNextElementNode(nodeList, 0);
        Node node = nodeList.item(n);
        if (!"extraParams".equalsIgnoreCase(node.getNodeName())) {
            throw new IOException("No se encontro el nodo 'extraParams' del PdfSignResultSerializado");
        }
        this.extraParams = PdfSignResult.base642Properties(node.getTextContent().trim());
        ++n;
        node = nodeList.item(n = PdfSignResult.getNextElementNode(nodeList, n));
        if (!"pdfId".equalsIgnoreCase(node.getNodeName())) {
            throw new IOException("No se encontro el nodo 'pdfId' del PdfSignResultSerializado");
        }
        this.fileID = node.getTextContent().trim();
        ++n;
        node = nodeList.item(n = PdfSignResult.getNextElementNode(nodeList, n));
        if (!"sign".equalsIgnoreCase(node.getNodeName())) {
            throw new IOException("No se encontro el nodo 'sign' del PdfSignResultSerializado");
        }
        this.sign = Base64.decode(node.getTextContent().trim());
        ++n;
        node = nodeList.item(n = PdfSignResult.getNextElementNode(nodeList, n));
        if (!"signTime".equalsIgnoreCase(node.getNodeName())) {
            throw new IOException("No se encontro el nodo 'signTime' del PdfSignResultSerializado");
        }
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        this.signTime = datatypeFactory.newXMLGregorianCalendar(node.getTextContent().trim()).toGregorianCalendar();
    }

    private static int getNextElementNode(NodeList nodeList, int n) throws IOException {
        for (int i = n; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return i;
        }
        throw new IOException("No se encontraron todos los campos del PdfSignResult serializado");
    }
}

