/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDeveloperExtension;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfWriter;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.signers.pades.BadPdfPasswordException;
import es.gob.afirma.signers.pades.CommonPdfMessages;
import es.gob.afirma.signers.pades.InvalidPdfException;
import es.gob.afirma.signers.pades.PdfIsCertifiedException;
import es.gob.afirma.signers.pades.PdfIsPasswordProtectedException;
import es.gob.afirma.signers.pades.PdfPreProcessor;
import es.gob.afirma.signers.pades.PdfTriPhaseSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public final class PdfSessionManager {
    static final int LAST_PAGE = -666;
    private static final int UNDEFINED = -1;
    private static final int DEFAULT_LAYER_2_FONT_SIZE = 12;
    private static final int COURIER = 0;
    private static final int CSIZE = 27000;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private PdfSessionManager() {
    }

    public static PdfTriPhaseSession getSessionData(byte[] byArray, X509Certificate[] x509CertificateArray, Calendar calendar, Properties properties) throws AOException, IOException, DocumentException {
        Rectangle rectangle;
        PdfStamper pdfStamper;
        PdfReader pdfReader;
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = Boolean.parseBoolean(properties.getProperty("alwaysCreateRevision", "false"));
        Image image = PdfPreProcessor.getImage(properties.getProperty("signatureRubricImage"));
        String string = properties.getProperty("signReason");
        String string2 = properties.getProperty("signatureField");
        String string3 = properties.getProperty("signatureProductionCity");
        String string4 = properties.getProperty("signerContact");
        int n5 = -666;
        try {
            n5 = Integer.parseInt(properties.getProperty("signaturePage"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string5 = properties.getProperty("signatureSubFilter");
        try {
            n4 = properties.getProperty("certificationLevel") != null ? Integer.parseInt(properties.getProperty("certificationLevel")) : -1;
        }
        catch (Exception exception) {
            n4 = -1;
        }
        String string6 = properties.getProperty("layer4Text");
        String string7 = properties.getProperty("layer2Text");
        try {
            n3 = properties.getProperty("layer2FontFamily") != null ? Integer.parseInt(properties.getProperty("layer2FontFamily")) : -1;
        }
        catch (Exception exception) {
            n3 = -1;
        }
        try {
            n2 = properties.getProperty("layer2FontSize") != null ? Integer.parseInt(properties.getProperty("layer2FontSize")) : -1;
        }
        catch (Exception exception) {
            n2 = -1;
        }
        try {
            n = properties.getProperty("layer2FontStyle") != null ? Integer.parseInt(properties.getProperty("layer2FontStyle")) : -1;
        }
        catch (Exception exception) {
            n = -1;
        }
        String string8 = properties.getProperty("layer2FontColor");
        String string9 = properties.getProperty("ownerPassword");
        String string10 = properties.getProperty("userPassword");
        try {
            pdfReader = string9 != null ? new PdfReader(byArray, string9.getBytes()) : (string10 != null ? new PdfReader(byArray, string10.getBytes()) : new PdfReader(byArray));
        }
        catch (BadPasswordException badPasswordException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(properties.getProperty("headLess"))) {
                throw new BadPdfPasswordException(badPasswordException);
            }
            string9 = new String(AOUIFactory.getPassword(string9 == null ? CommonPdfMessages.getString("AOPDFSigner.0") : CommonPdfMessages.getString("AOPDFSigner.1"), null));
            try {
                pdfReader = new PdfReader(byArray, string9.getBytes());
            }
            catch (BadPasswordException badPasswordException2) {
                throw new BadPdfPasswordException(badPasswordException2);
            }
        }
        catch (IOException iOException) {
            throw new InvalidPdfException(iOException);
        }
        if (pdfReader.getCertificationLevel() == 1 && !Boolean.parseBoolean(properties.getProperty("allowSigningCertifiedPdfs"))) {
            if (Boolean.parseBoolean(properties.getProperty("headLess")) || "false".equalsIgnoreCase(properties.getProperty("allowSigningCertifiedPdfs"))) {
                throw new PdfIsCertifiedException();
            }
            if (AOUIFactory.NO_OPTION == AOUIFactory.showConfirmDialog(null, CommonPdfMessages.getString("AOPDFSigner.8"), CommonPdfMessages.getString("AOPDFSigner.9"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE)) {
                throw new AOCancelledOperationException("El usuario no ha permitido la firma de un PDF certificado");
            }
        }
        pdfReader.removeUsageRights();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            pdfStamper = PdfStamper.createSignature(pdfReader, byteArrayOutputStream, '\u0000', null, bl || pdfReader.getAcroFields().getSignatureNames().size() > 0, calendar);
        }
        catch (BadPasswordException badPasswordException) {
            throw new PdfIsPasswordProtectedException(badPasswordException);
        }
        PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
        pdfStamper.setFullCompression();
        pdfSignatureAppearance.setAcro6Layers(true);
        pdfStamper.getWriter().addDeveloperExtension(new PdfDeveloperExtension(new PdfName("ESIC"), PdfWriter.PDF_VERSION_1_7, 1));
        PdfPreProcessor.attachFile(properties, pdfStamper);
        PdfPreProcessor.addImage(properties, pdfStamper);
        pdfSignatureAppearance.setRender(0);
        if (string != null) {
            pdfSignatureAppearance.setReason(string);
        }
        pdfSignatureAppearance.setSignDate(calendar);
        if (pdfReader.isEncrypted() && (string9 != null || string10 != null)) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(properties.getProperty("avoidEncryptingSignedPdfs"))) {
                LOGGER.info("Aunque el PDF original estaba encriptado no se encriptara el PDF firmado (se establecio el indicativo 'avoidEncryptingSignedPdfs')");
            } else {
                LOGGER.info("El PDF original estaba encriptado, se intentara encriptar tambien el PDF firmado");
                try {
                    pdfStamper.setEncryption(string9 != null ? string9.getBytes() : null, string10 != null ? string10.getBytes() : null, pdfReader.getPermissions(), pdfReader.getCryptoMode());
                }
                catch (DocumentException documentException) {
                    LOGGER.warning("No se ha podido cifrar el PDF destino, se escribira sin contrasena: " + documentException);
                }
            }
        }
        if (n5 == -666) {
            n5 = pdfReader.getNumberOfPages();
        }
        if ((rectangle = PdfSessionManager.getSignaturePositionOnPage(properties)) != null && string2 == null) {
            pdfSignatureAppearance.setVisibleSignature(rectangle, n5, null);
        } else if (string2 != null) {
            pdfSignatureAppearance.setVisibleSignature(string2);
        }
        if (string3 != null) {
            pdfSignatureAppearance.setLocation(string3);
        }
        if (string4 != null) {
            pdfSignatureAppearance.setContact(string4);
        }
        if (image != null) {
            pdfSignatureAppearance.setImage(image);
            pdfSignatureAppearance.setLayer2Text("");
            pdfSignatureAppearance.setLayer4Text("");
        }
        if (string7 != null) {
            Font font;
            int n6;
            int n7;
            int n8;
            pdfSignatureAppearance.setLayer2Text(string7);
            if ("black".equalsIgnoreCase(string8)) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
            } else if ("white".equalsIgnoreCase(string8)) {
                n8 = 255;
                n7 = 255;
                n6 = 255;
            } else if ("lightGray".equalsIgnoreCase(string8)) {
                n8 = 192;
                n7 = 192;
                n6 = 192;
            } else if ("gray".equalsIgnoreCase(string8)) {
                n8 = 128;
                n7 = 128;
                n6 = 128;
            } else if ("darkGray".equalsIgnoreCase(string8)) {
                n8 = 64;
                n7 = 64;
                n6 = 64;
            } else if ("red".equalsIgnoreCase(string8)) {
                n8 = 255;
                n7 = 0;
                n6 = 0;
            } else if ("pink".equalsIgnoreCase(string8)) {
                n8 = 255;
                n7 = 175;
                n6 = 175;
            } else if (string8 == null) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
            } else {
                LOGGER.warning("No se soporta el color '" + string8 + "' para el texto de la capa 4, se usara negro");
                n8 = 0;
                n7 = 0;
                n6 = 0;
            }
            try {
                Class<?> clazz = Platform.getOS() == Platform.OS.ANDROID ? Class.forName("harmony.java.awt.Color") : Class.forName("java.awt.Color");
                Object obj = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(n8, n7, n6);
                font = (Font)Font.class.getConstructor(Integer.TYPE, Float.TYPE, Integer.TYPE, clazz).newInstance(n3 == -1 ? 0 : n3, Float.valueOf(n2 == -1 ? 12.0f : (float)n2), n == -1 ? 0 : n, obj);
            }
            catch (Exception exception) {
                font = new Font(n3 == -1 ? 0 : n3, n2 == -1 ? 12.0f : (float)n2, n == -1 ? 0 : n, null);
            }
            pdfSignatureAppearance.setLayer2Font(font);
        }
        if (string6 != null) {
            pdfSignatureAppearance.setLayer4Text(string6);
        }
        pdfSignatureAppearance.setCrypto(null, x509CertificateArray, null, null);
        PdfSignature pdfSignature = new PdfSignature(PdfName.ADOBE_PPKLITE, string5 != null && !"".equals(string5) ? new PdfName(string5) : PdfName.ADBE_PKCS7_DETACHED);
        if (pdfSignatureAppearance.getSignDate() != null) {
            pdfSignature.setDate(new PdfDate(pdfSignatureAppearance.getSignDate()));
        }
        pdfSignature.setName(PdfPKCS7.getSubjectFields(x509CertificateArray[0]).getField("CN"));
        if (pdfSignatureAppearance.getReason() != null) {
            pdfSignature.setReason(pdfSignatureAppearance.getReason());
        }
        if (pdfSignatureAppearance.getLocation() != null) {
            pdfSignature.setLocation(pdfSignatureAppearance.getLocation());
        }
        if (pdfSignatureAppearance.getContact() != null) {
            pdfSignature.setContact(pdfSignatureAppearance.getContact());
        }
        pdfSignatureAppearance.setCryptoDictionary(pdfSignature);
        if (n4 != -1) {
            pdfSignatureAppearance.setCertificationLevel(n4);
        }
        HashMap<PdfName, Integer> hashMap = new HashMap<PdfName, Integer>();
        hashMap.put(PdfName.CONTENTS, 54002);
        pdfSignatureAppearance.preClose(hashMap, calendar);
        PdfObject pdfObject = ((PdfStamperImp)pdfStamper.getWriter()).getFileID();
        return new PdfTriPhaseSession(pdfSignatureAppearance, byteArrayOutputStream, new String(pdfObject.getBytes()));
    }

    private static Rectangle getSignaturePositionOnPage(Properties properties) {
        return PdfPreProcessor.getPositionOnPage(properties, "signature");
    }
}

