/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.lowagie.text.Annotation;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Jpeg;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfStamper;
import es.gob.afirma.core.misc.Base64;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public final class PdfPreProcessor {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private PdfPreProcessor() {
    }

    public static void addMoreInfo(HashMap<String, String> hashMap, PdfStamper pdfStamper) {
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        pdfStamper.setMoreInfo(hashMap);
    }

    static void attachFile(Properties properties, PdfStamper pdfStamper) throws IOException {
        if (properties == null) {
            return;
        }
        if (pdfStamper == null) {
            throw new IllegalArgumentException("No se puede adjuntar un fichero a un PdfStamper nulo");
        }
        String string = properties.getProperty("attach");
        String string2 = properties.getProperty("attachFileName");
        String string3 = properties.getProperty("attachDescription");
        if (string != null && string2 != null) {
            byte[] byArray;
            try {
                byArray = Base64.decode(string);
            }
            catch (IOException iOException) {
                LOGGER.warning("Se ha indicado un adjunto, pero no estaba en formato Base64, se ignorara : " + iOException);
                return;
            }
            pdfStamper.getWriter().addFileAttachment(string3, byArray, null, string2);
        }
    }

    public static void addImage(byte[] byArray, int n, int n2, int n3, int n4, int n5, String string, PdfStamper pdfStamper) throws IOException {
        PdfContentByte pdfContentByte = pdfStamper.getOverContent(n5);
        try {
            Jpeg jpeg = new Jpeg(byArray);
            if (string != null) {
                jpeg.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, string));
            }
            pdfContentByte.addImage(jpeg, n, 0.0f, 0.0f, n2, n3, n4, false);
        }
        catch (DocumentException documentException) {
            throw new IOException("Error durante la insercion de la imagen en el PDF: " + documentException, documentException);
        }
    }

    static void addImage(Properties properties, PdfStamper pdfStamper) throws IOException {
        int n;
        if (properties == null || pdfStamper == null) {
            return;
        }
        String string = properties.getProperty("image");
        if (string == null || string.length() < 1) {
            return;
        }
        byte[] byArray = Base64.decode(string);
        Rectangle rectangle = PdfPreProcessor.getPositionOnPage(properties, "image");
        if (rectangle == null) {
            return;
        }
        String string2 = properties.getProperty("imagePage");
        if (string2 == null) {
            return;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Se ha indicado un numero de pagina con formato invalido para insertar la imagen (" + string2 + "): " + numberFormatException, numberFormatException);
        }
        PdfPreProcessor.addImage(byArray, (int)rectangle.getWidth(), (int)rectangle.getHeight(), (int)rectangle.getLeft(), (int)rectangle.getBottom(), n, null, pdfStamper);
        LOGGER.info("Anadida imagen al PDF antes de la firma");
    }

    static Rectangle getPositionOnPage(Properties properties, String string) {
        if (properties == null || string == null) {
            LOGGER.severe("Se ha pedido una posicion para un elemento grafico nulo");
            return null;
        }
        if (properties.getProperty(string + "PositionOnPageLowerLeftX") != null && properties.getProperty(string + "PositionOnPageLowerLeftY") != null && properties.getProperty(string + "PositionOnPageUpperRightX") != null && properties.getProperty(string + "PositionOnPageUpperRightY") != null) {
            try {
                return new Rectangle(Integer.parseInt(properties.getProperty(string + "PositionOnPageLowerLeftX")), Integer.parseInt(properties.getProperty(string + "PositionOnPageLowerLeftY")), Integer.parseInt(properties.getProperty(string + "PositionOnPageUpperRightX")), Integer.parseInt(properties.getProperty(string + "PositionOnPageUpperRightY")));
            }
            catch (Exception exception) {
                LOGGER.severe("Se ha indicado una posicion invalida para el elemento grafico '" + string + "': " + exception);
            }
        }
        return null;
    }

    static Image getImage(String string) {
        byte[] byArray;
        if (string == null || "".equals(string)) {
            return null;
        }
        try {
            byArray = Base64.decode(string);
        }
        catch (Exception exception) {
            LOGGER.severe("Se ha proporcionado una imagen de rubrica que no esta codificada en Base64: " + exception);
            return null;
        }
        try {
            return new Jpeg(byArray);
        }
        catch (Exception exception) {
            LOGGER.info("Se ha proporcionado una imagen de rubrica que no esta codificada en JPEG: " + exception);
            return null;
        }
    }
}

