/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;

final class PdfDocumentSecurityStore {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    private final Map<String, ValidationInformation> signatures = new HashMap<String, ValidationInformation>();
    private final Map<Integer, byte[]> certificates = new HashMap<Integer, byte[]>();
    private final Map<Integer, byte[]> ocsps = new HashMap<Integer, byte[]>();
    private final Map<Integer, byte[]> crls = new HashMap<Integer, byte[]>();
    private static final String PDF_NAME_CERTS = "Certs";
    private static final String PDF_NAME_OCSPS = "OCSPs";
    private static final String PDF_NAME_CRLS = "CRLs";
    private static final String PDF_NAME_VRI = "VRI";
    private static final String PDF_NAME_CERT = "Cert";
    private static final String PDF_NAME_OCSP = "OCSP";
    private static final String PDF_NAME_CRL = "CRL";

    PdfDocumentSecurityStore() {
    }

    PdfDocumentSecurityStore(PdfDictionary pdfDictionary) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        PdfArray pdfArray = pdfDictionary.getAsArray(new PdfName(PDF_NAME_CERTS));
        if (pdfArray != null) {
            object3 = pdfArray.listIterator();
            while (object3.hasNext()) {
                object2 = (PdfIndirectReference)object3.next();
                this.certificates.put(n, PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject((PdfObject)object2)));
                ++n;
            }
        }
        if ((object3 = pdfDictionary.getAsArray(new PdfName(PDF_NAME_OCSPS))) != null) {
            n = 0;
            object2 = ((PdfArray)object3).listIterator();
            while (object2.hasNext()) {
                object = (PdfIndirectReference)object2.next();
                this.ocsps.put(n, PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject((PdfObject)object)));
                ++n;
            }
        }
        if ((object2 = pdfDictionary.getAsArray(new PdfName(PDF_NAME_CRLS))) != null) {
            n = 0;
            object = ((PdfArray)object2).listIterator();
            while (object.hasNext()) {
                PdfIndirectReference pdfObject = (PdfIndirectReference)object.next();
                this.crls.put(n, PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject(pdfObject)));
                ++n;
            }
        }
        if ((object = pdfDictionary.getAsDict(new PdfName(PDF_NAME_VRI))) != null) {
            for (PdfName pdfName : ((PdfDictionary)object).getKeys()) {
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                int[] nArray;
                PdfDictionary pdfDictionary2 = ((PdfDictionary)object).getAsDict(pdfName);
                pdfArray = pdfDictionary2.getAsArray(new PdfName(PDF_NAME_CERT));
                if (pdfArray != null) {
                    nArray = new int[pdfArray.size()];
                    for (n = 0; n < pdfArray.size(); ++n) {
                        object7 = (PdfIndirectReference)pdfArray.getPdfObject(n);
                        object6 = PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject((PdfObject)object7));
                        object5 = this.certificates.keySet().iterator();
                        while (object5.hasNext()) {
                            int pdfIndirectReference = object5.next();
                            if (!Arrays.equals(object6, this.certificates.get(pdfIndirectReference))) continue;
                            nArray[n] = pdfIndirectReference;
                        }
                    }
                } else {
                    nArray = new int[]{};
                }
                if ((object3 = pdfDictionary2.getAsArray(new PdfName(PDF_NAME_OCSP))) != null) {
                    object7 = new int[((PdfArray)object3).size()];
                    n = 0;
                    object6 = ((PdfArray)object3).listIterator();
                    while (object6.hasNext()) {
                        object5 = (PdfIndirectReference)object6.next();
                        byte[] byArray = PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject((PdfObject)object5));
                        object4 = this.ocsps.keySet().iterator();
                        while (object4.hasNext()) {
                            int n2 = object4.next();
                            if (!Arrays.equals(byArray, this.ocsps.get(n2))) continue;
                            object7[n] = n2;
                        }
                        ++n;
                    }
                } else {
                    object7 = new int[0];
                }
                if ((object2 = pdfDictionary2.getAsArray(new PdfName(PDF_NAME_CRL))) != null) {
                    object6 = new int[((PdfArray)object2).size()];
                    n = 0;
                    object5 = ((PdfArray)object2).listIterator();
                    while (object5.hasNext()) {
                        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)object5.next();
                        object4 = PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject(pdfIndirectReference));
                        for (int n3 : this.crls.keySet()) {
                            if (!Arrays.equals((byte[])object4, this.crls.get(n3))) continue;
                            object6[n] = n3;
                        }
                        ++n;
                    }
                } else {
                    object6 = new int[0];
                }
                object5 = null;
                if (pdfDictionary2.get(PdfName.TU) != null) {
                    if (pdfDictionary2.get(PdfName.TU) instanceof PdfDate) {
                        object5 = PdfDate.decode(((PdfDate)pdfDictionary2.get(PdfName.TU)).getEncoding());
                    }
                    if (pdfDictionary2.get(PdfName.TU) instanceof PdfString) {
                        object5 = PdfDate.decode(pdfDictionary2.getAsString(PdfName.TU).getEncoding());
                    }
                }
                ValidationInformation validationInformation = new ValidationInformation(pdfName, nArray, (int[])object7, (int[])object6, (Calendar)object5);
                this.signatures.put(pdfName.toString().substring(1), validationInformation);
            }
        }
    }

    Map<String, ValidationInformation> getSignatures() {
        return this.signatures;
    }

    Map<Integer, byte[]> getCertificates() {
        return this.certificates;
    }

    Map<Integer, byte[]> getOcsps() {
        return this.ocsps;
    }

    Map<Integer, byte[]> getCrls() {
        return this.crls;
    }

    void registerSignature(byte[] byArray, int[] nArray, int[] nArray2, int[] nArray3, Calendar calendar) {
        ValidationInformation validationInformation = new ValidationInformation(byArray, nArray, nArray2, nArray3, calendar);
        this.signatures.put(validationInformation.getKey(), validationInformation);
    }

    void registerSignature(byte[] byArray, int[] nArray, int[] nArray2, int[] nArray3) {
        this.registerSignature(byArray, nArray, nArray2, nArray3, new GregorianCalendar());
    }

    void registerSignature(byte[] byArray) {
        this.registerSignature(byArray, null, null, null, new GregorianCalendar());
    }

    synchronized int registerCertificate(byte[] byArray) {
        int n = this.certificates.size() + 1;
        this.certificates.put(n, byArray);
        return n;
    }

    synchronized int registerOcspResp(byte[] byArray) {
        int n = this.ocsps.size() + 1;
        this.ocsps.put(n, byArray);
        return n;
    }

    synchronized int registerOcspBasicResp(byte[] byArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        aSN1EncodableVector.add(new DEROctetString(byArray));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new DEREnumerated(0));
        aSN1EncodableVector2.add(new DERTaggedObject(true, 0, new DERSequence(aSN1EncodableVector)));
        return this.registerOcspResp(new DERSequence(aSN1EncodableVector2).getEncoded());
    }

    synchronized int registerCrl(byte[] byArray) {
        int n = this.crls.size() + 1;
        this.crls.put(n, byArray);
        return n;
    }

    ValidationInformation getValidationInformation(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_DIGEST_ALGORITHM);
        return this.signatures.get(ValidationInformation.getKey(messageDigest.digest(byArray)));
    }

    private static byte[] getContentBytesFromContentObject(PdfObject pdfObject) throws IOException {
        switch (pdfObject.type()) {
            case 10: {
                return PdfDocumentSecurityStore.getContentBytesFromContentObject(PdfReader.getPdfObject(pdfObject));
            }
            case 7: {
                return PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObject(pdfObject));
            }
            case 5: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ListIterator<PdfObject> listIterator = ((PdfArray)pdfObject).listIterator();
                while (listIterator.hasNext()) {
                    byteArrayOutputStream.write(PdfDocumentSecurityStore.getContentBytesFromContentObject(listIterator.next()));
                    byteArrayOutputStream.write(32);
                }
                return byteArrayOutputStream.toByteArray();
            }
        }
        throw new IllegalStateException("No se soporta contenido del tipo: " + pdfObject.getClass());
    }

    static class ValidationInformation {
        private final byte[] digest;
        private final int[] ocspId;
        private final int[] crlId;
        private final int[] certId;
        private final Calendar date;

        static String getKey(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                int n = by & 0xFF;
                if (n >= 0 && n <= 15) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toHexString(n).toUpperCase(Locale.ENGLISH));
            }
            return stringBuilder.toString();
        }

        String getKey() {
            return ValidationInformation.getKey(this.digest);
        }

        byte[] getDigest() {
            return this.digest;
        }

        int[] getOcspId() {
            return (int[])this.ocspId.clone();
        }

        int[] getCrlId() {
            return (int[])this.crlId.clone();
        }

        int[] getCertId() {
            return (int[])this.certId.clone();
        }

        Calendar getDate() {
            return this.date;
        }

        ValidationInformation(byte[] byArray, int[] nArray, int[] nArray2, int[] nArray3, Calendar calendar) {
            byte[] byArray2 = null;
            try {
                byArray2 = MessageDigest.getInstance(PdfDocumentSecurityStore.DEFAULT_DIGEST_ALGORITHM).digest(byArray);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").severe("No se ha posido calcular la huella digital: " + exception);
            }
            this.digest = byArray2;
            this.ocspId = (int[])nArray2.clone();
            this.crlId = (int[])nArray3.clone();
            this.certId = (int[])nArray.clone();
            this.date = calendar;
        }

        ValidationInformation(PdfName pdfName, int[] nArray, int[] nArray2, int[] nArray3, Calendar calendar) {
            this.digest = pdfName.getBytes();
            this.ocspId = (int[])nArray2.clone();
            this.crlId = (int[])nArray3.clone();
            this.certId = (int[])nArray.clone();
            this.date = calendar;
        }
    }
}

