/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfString;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESTriPhaseSigner;
import es.gob.afirma.signers.pades.PdfSessionManager;
import es.gob.afirma.signers.pades.PdfSignResult;
import es.gob.afirma.signers.pades.PdfTriPhaseSession;
import es.gob.afirma.signers.pades.SignEnhancer;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.tsp.pkcs7.CMSTimestamper;
import es.gob.afirma.signers.tsp.pkcs7.TsaRequestExtension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Logger;

public final class PAdESTriPhaseSigner {
    private static final String PDF_OID = "1.2.826.0.1089.1.5";
    private static final String PDF_DESC = "Documento en formato PDF";
    public static final int LAST_PAGE = -666;
    public static final String ITEXT_VERSION = "2.1.7";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int CSIZE = 27000;

    private PAdESTriPhaseSigner() {
    }

    public static PdfSignResult preSign(String string, byte[] byArray, X509Certificate[] x509CertificateArray, GregorianCalendar gregorianCalendar, Properties properties) throws IOException, AOException, DocumentException {
        MessageDigest messageDigest;
        Properties properties2 = properties != null ? properties : new Properties();
        PdfTriPhaseSession pdfTriPhaseSession = PdfSessionManager.getSessionData(byArray, x509CertificateArray, gregorianCalendar, properties2);
        boolean bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string));
        byte[] byArray2 = AOUtil.getDataFromInputStream(pdfTriPhaseSession.getSAP().getRangeStream());
        try {
            messageDigest = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("El algoritmo de huella digital no es valido", noSuchAlgorithmException);
        }
        messageDigest.update(byArray2);
        return new PdfSignResult(pdfTriPhaseSession.getFileID(), CAdESTriPhaseSigner.preSign(AOSignConstants.getDigestAlgorithmName(string), null, x509CertificateArray, new AdESPolicy(properties2), bl, messageDigest.digest(), gregorianCalendar.getTime(), true, PDF_OID, PDF_DESC), gregorianCalendar, properties2);
    }

    public static byte[] postSign(String string, byte[] byArray, X509Certificate[] x509CertificateArray, byte[] byArray2, PdfSignResult pdfSignResult, SignEnhancer signEnhancer, Properties properties) throws AOException, IOException, NoSuchAlgorithmException {
        PdfSignResult pdfSignResult2 = PAdESTriPhaseSigner.generatePdfSignature(string, x509CertificateArray, pdfSignResult.getExtraParams(), byArray2, pdfSignResult.getSign(), pdfSignResult.getFileID(), pdfSignResult.getSignTime(), signEnhancer, properties);
        return PAdESTriPhaseSigner.insertSignatureOnPdf(byArray, x509CertificateArray, pdfSignResult2);
    }

    private static PdfSignResult generatePdfSignature(String string, X509Certificate[] x509CertificateArray, Properties properties, byte[] byArray, byte[] byArray2, String string2, GregorianCalendar gregorianCalendar, SignEnhancer signEnhancer, Properties properties2) throws AOException, IOException, NoSuchAlgorithmException {
        Properties properties3;
        String string3;
        byte[] byArray3 = CAdESTriPhaseSigner.postSign(AOSignConstants.getDigestAlgorithmName(string), null, x509CertificateArray, byArray, byArray2);
        if (signEnhancer != null) {
            byArray3 = signEnhancer.enhance(byArray3, properties2);
        }
        if ((string3 = (properties3 = properties != null ? properties : new Properties()).getProperty("tsaURL")) != null) {
            URI uRI;
            try {
                uRI = new URI(string3);
            }
            catch (Exception exception) {
                LOGGER.warning("Se ha indicado una URL de TSA invalida (" + string3 + "), no se anadira sello de tiempo: " + exception);
                uRI = null;
            }
            if (uRI != null) {
                String string4 = properties3.getProperty("tsaPolicy");
                if (string4 == null) {
                    LOGGER.warning("Se ha indicado una URL de TSA pero no una politica, no se anadira sello de tiempo");
                } else {
                    TsaRequestExtension[] tsaRequestExtensionArray;
                    String string5 = properties3.getProperty("tsaHashAlgorithm");
                    boolean bl = !Boolean.FALSE.toString().equalsIgnoreCase(properties3.getProperty("tsaRequireCert"));
                    String string6 = properties3.getProperty("tsaUsr");
                    String string7 = properties3.getProperty("tsaPwd");
                    if (properties3.getProperty("tsaExtensionOid") != null && properties3.getProperty("tsaExtensionValueBase64") != null) {
                        TsaRequestExtension[] tsaRequestExtensionArray2 = new TsaRequestExtension[1];
                        tsaRequestExtensionArray = tsaRequestExtensionArray2;
                        tsaRequestExtensionArray2[0] = new TsaRequestExtension(properties3.getProperty("tsaExtensionOid"), Boolean.getBoolean(properties3.getProperty("tsaExtensionCritical", "false")), Base64.decode(properties3.getProperty("tsaExtensionValueBase64")));
                    } else {
                        tsaRequestExtensionArray = null;
                    }
                    byArray3 = new CMSTimestamper(bl, string4, uRI, string6, string7, tsaRequestExtensionArray).addTimestamp(byArray3, AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(string5 != null ? string5 : "SHA1")));
                }
            }
        }
        return new PdfSignResult(string2, byArray3, gregorianCalendar, properties);
    }

    private static byte[] insertSignatureOnPdf(byte[] byArray, X509Certificate[] x509CertificateArray, PdfSignResult pdfSignResult) throws AOException, IOException {
        PdfTriPhaseSession pdfTriPhaseSession;
        byte[] byArray2 = new byte[27000];
        if (pdfSignResult.getSign().length > 27000) {
            throw new AOException("El tamano de la firma (" + pdfSignResult.getSign().length + ") supera el maximo permitido para un PDF (" + 27000 + ")");
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        System.arraycopy(pdfSignResult.getSign(), 0, byArray2, 0, pdfSignResult.getSign().length);
        pdfDictionary.put(PdfName.CONTENTS, new PdfString(byArray2).setHexWriting(true));
        try {
            pdfTriPhaseSession = PdfSessionManager.getSessionData(byArray, x509CertificateArray, pdfSignResult.getSignTime(), pdfSignResult.getExtraParams());
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
        PdfSignatureAppearance pdfSignatureAppearance = pdfTriPhaseSession.getSAP();
        ByteArrayOutputStream byteArrayOutputStream = pdfTriPhaseSession.getBAOS();
        String string = pdfTriPhaseSession.getFileID();
        try {
            pdfSignatureAppearance.close(pdfDictionary);
        }
        catch (Exception exception) {
            byteArrayOutputStream.close();
            throw new AOException("Error al cerrar el PDF para finalizar el proceso de firma", exception);
        }
        byte[] byArray3 = new String(byteArrayOutputStream.toByteArray(), "ISO-8859-1").replace(string, pdfSignResult.getFileID()).getBytes("ISO-8859-1");
        byteArrayOutputStream.close();
        return byArray3;
    }
}

