/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.lowagie.text.DocumentException;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSimpleSignInfo;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.pades.CommonPdfMessages;
import es.gob.afirma.signers.pades.InvalidITextException;
import es.gob.afirma.signers.pades.InvalidPdfException;
import es.gob.afirma.signers.pades.PAdESTriPhaseSigner;
import es.gob.afirma.signers.pades.PdfSignResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPDFSigner
implements AOSigner {
    private static final String PDF_FILE_SUFFIX = ".pdf";
    private static final String PDF_FILE_HEADER = "%PDF-";
    private static final String ITEXT_VERSION = "2.1.7";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final int LAST_PAGE = -666;

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        PdfSignResult pdfSignResult;
        Properties properties2 = properties != null ? properties : new Properties();
        this.checkIText();
        try {
            pdfSignResult = PAdESTriPhaseSigner.preSign(string, byArray, (X509Certificate[])certificateArray, new GregorianCalendar(), properties2);
        }
        catch (DocumentException documentException) {
            throw new InvalidPdfException(documentException);
        }
        try {
            return PAdESTriPhaseSigner.postSign(string, byArray, (X509Certificate[])certificateArray, new AOPkcs1Signer().sign(pdfSignResult.getSign(), string, privateKey, certificateArray, properties2), pdfSignResult, null, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("Error el en algoritmo de firma: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.sign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.sign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No es posible realizar contrafirmas de ficheros PDF");
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signed.pdf";
        }
        if (string.toLowerCase(Locale.US).endsWith(PDF_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PDF_FILE_SUFFIX.length()) + string3 + PDF_FILE_SUFFIX;
        }
        return string + string3 + PDF_FILE_SUFFIX;
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        AcroFields acroFields;
        PdfReader pdfReader;
        AOTreeNode aOTreeNode = new AOTreeNode("Datos");
        if (!this.isPdfFile(byArray)) {
            return new AOTreeModel(aOTreeNode);
        }
        try {
            pdfReader = new PdfReader(byArray);
        }
        catch (BadPasswordException badPasswordException) {
            try {
                pdfReader = new PdfReader(byArray, new String(AOUIFactory.getPassword(CommonPdfMessages.getString("AOPDFSigner.0"), null)).getBytes());
            }
            catch (BadPasswordException badPasswordException2) {
                LOGGER.severe("La contrasena del PDF no es valida, se devolvera un arbol vacio: " + badPasswordException2);
                return new AOTreeModel(aOTreeNode);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido leer el PDF, se devolvera un arbol vacio: " + exception);
                return new AOTreeModel(aOTreeNode);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido leer el PDF, se devolvera un arbol vacio: " + exception);
            return new AOTreeModel(aOTreeNode);
        }
        try {
            acroFields = pdfReader.getAcroFields();
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido obtener la informacion de los firmantes del PDF, se devolvera un arbol vacio: " + exception);
            return new AOTreeModel(aOTreeNode);
        }
        ArrayList arrayList = acroFields.getSignatureNames();
        Object object = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(arrayList.get(i).toString());
            if (bl) {
                AOSimpleSignInfo aOSimpleSignInfo = new AOSimpleSignInfo(new X509Certificate[]{pdfPKCS7.getSigningCertificate()}, pdfPKCS7.getSignDate().getTime());
                try {
                    Field field = Class.forName("com.lowagie.text.pdf.PdfPKCS7").getDeclaredField("digest");
                    field.setAccessible(true);
                    object = field.get(pdfPKCS7);
                }
                catch (Exception exception) {
                    LOGGER.severe("No se ha podido obtener informacion de una de las firmas del PDF, se continuara con la siguiente: " + exception);
                    continue;
                }
                if (object instanceof byte[]) {
                    aOSimpleSignInfo.setPkcs1((byte[])object);
                }
                aOTreeNode.add(new AOTreeNode(aOSimpleSignInfo));
                continue;
            }
            aOTreeNode.add(new AOTreeNode(AOUtil.getCN(pdfPKCS7.getSigningCertificate())));
        }
        return new AOTreeModel(aOTreeNode);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        if (!this.isPdfFile(byArray)) {
            return false;
        }
        Object object = this.getSignersStructure(byArray, false).getRoot();
        if (object instanceof AOTreeNode) {
            return AOTreeModel.getChildCount(object) > 0;
        }
        return false;
    }

    private boolean isPdfFile(byte[] byArray) {
        this.checkIText();
        byte[] byArray2 = new byte[PDF_FILE_HEADER.length()];
        try {
            new ByteArrayInputStream(byArray).read(byArray2);
        }
        catch (Exception exception) {
            byArray2 = null;
        }
        if (byArray2 != null && !PDF_FILE_HEADER.equals(new String(byArray2))) {
            return false;
        }
        try {
            new PdfReader(byArray);
        }
        catch (BadPasswordException badPasswordException) {
            LOGGER.warning("El PDF esta protegido con contrasena, se toma como PDF valido");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return this.isPdfFile(byArray);
    }

    public static String getSignedName(String string) {
        if (string == null) {
            return "signed.pdf";
        }
        if (string.endsWith(PDF_FILE_SUFFIX)) {
            return string.replace(PDF_FILE_SUFFIX, ".signed.pdf");
        }
        if (string.endsWith(".PDF")) {
            return string.replace(".PDF", ".signed.pdf");
        }
        return string + ".signed.pdf";
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("El documento introducido no contiene una firma valida");
        }
        return byArray;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("Adobe PDF");
    }

    private void checkIText() {
        String string = Platform.getITextVersion();
        if (!ITEXT_VERSION.equals(string)) {
            throw new InvalidITextException(ITEXT_VERSION, string);
        }
    }
}

