/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

public final class CAdESTriPhaseCounterSigner {
    public static final int PKCS1_DEFAULT_SIZE = 128;
    private int counterIndex = 0;
    private List<byte[]> signedDatas = new ArrayList<byte[]>();

    /*
     * WARNING - void declaration
     */
    public CAdESPreCounterSignResult preCounterSign(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, CounterSignTarget counterSignTarget, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        void var22_26;
        ArrayList<ASN1Encodable> arrayList;
        this.counterIndex = 0;
        this.signedDatas = new ArrayList<byte[]>();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ASN1Set aSN1Set = signedData.getSignerInfos();
        ASN1Set aSN1Set2 = null;
        ASN1Set aSN1Set3 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set3.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (certificateArray.length != 0) {
            arrayList = new ArrayList<ASN1Encodable>();
            for (java.security.cert.Certificate certificate : certificateArray) {
                arrayList.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
            aSN1Set2 = SigUtils.fillRestCerts(arrayList, aSN1EncodableVector);
        }
        arrayList = null;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (CounterSignTarget.TREE.equals((Object)counterSignTarget)) {
            ASN1EncodableVector aSN1EncodableVector3 = this.counterTree(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl);
        } else if (CounterSignTarget.LEAFS.equals((Object)counterSignTarget)) {
            ASN1EncodableVector aSN1EncodableVector4 = this.counterLeaf(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl);
        } else {
            throw new IllegalArgumentException("Modo de contrafirma no soportado: " + (Object)((Object)counterSignTarget));
        }
        return new CAdESPreCounterSignResult(new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), aSN1Set2, (ASN1Set)((Object)arrayList), new DERSet((ASN1EncodableVector)var22_26))).getEncoded("DER"), this.signedDatas);
    }

    private ASN1EncodableVector counterTree(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, AdESPolicy adESPolicy, boolean bl) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add(this.getCounterSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, AdESPolicy adESPolicy, boolean bl) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add(this.getLeafSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl));
        }
        return aSN1EncodableVector;
    }

    private SignerInfo getCounterSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, AdESPolicy adESPolicy, boolean bl) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        SignerInfo signerInfo3 = SignerInfo.getInstance(object.nextElement());
                        aSN1EncodableVector.add(this.getCounterSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl));
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            signerInfo2 = this.generateSignerInfo(p7ContentSignerParameters.getSignatureAlgorithm(), signerInfo, certificateArray, string, string2, adESPolicy, bl);
            aSN1EncodableVector.add(signerInfo2);
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters.getSignatureAlgorithm(), signerInfo, certificateArray, string, string2, adESPolicy, bl));
                    object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet((ASN1Encodable)object));
            }
        } else {
            aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters.getSignatureAlgorithm(), signerInfo, certificateArray, string, string2, adESPolicy, bl));
            Attribute attribute = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
        }
        return signerInfo2;
    }

    private SignerInfo getLeafSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, AdESPolicy adESPolicy, boolean bl) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        SignerInfo signerInfo3 = SignerInfo.getInstance(object.nextElement());
                        aSN1EncodableVector.add(this.getLeafSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2, adESPolicy, bl));
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters.getSignatureAlgorithm(), signerInfo, certificateArray, string, string2, adESPolicy, bl));
                    object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet((ASN1Encodable)object));
            }
        } else {
            aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters.getSignatureAlgorithm(), signerInfo, certificateArray, string, string2, adESPolicy, bl));
            Attribute attribute = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
        }
        return signerInfo2;
    }

    private SignerInfo generateSignerInfo(String string, SignerInfo signerInfo, java.security.cert.Certificate[] certificateArray, String string2, String string3, AdESPolicy adESPolicy, boolean bl) throws NoSuchAlgorithmException, IOException, CertificateException {
        String string4 = AOSignConstants.getDigestAlgorithmName(string);
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.generateSignerInfo((X509Certificate)certificateArray[0], string4, signerInfo.getEncryptedDigest().getOctets(), adESPolicy, bl, null, new Date(), false, string2, string3);
        ASN1Set aSN1Set = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        this.signedDatas.add(this.counterIndex, aSN1Set.getEncoded("DER"));
        DEROctetString dEROctetString = new DEROctetString(this.firma());
        ++this.counterIndex;
        if (this.counterIndex > 9) {
            throw new UnsupportedOperationException("No se soportan mas de 10 contrafirmas en una misma firma");
        }
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string4));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set2, algorithmIdentifier2, (ASN1OctetString)dEROctetString, null);
    }

    private byte[] firma() {
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)Integer.toString(this.counterIndex).toCharArray()[0]);
        return byArray;
    }

    public static final class CAdESPreCounterSignResult {
        private final List<byte[]> preSigns;
        private final byte[] sign;

        CAdESPreCounterSignResult(byte[] byArray, List<byte[]> list) {
            this.preSigns = list;
            this.sign = (byte[])byArray.clone();
        }

        public byte[] getSign() {
            return this.sign;
        }

        public List<byte[]> getPreSigns() {
            return this.preSigns;
        }
    }
}

