/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;

public final class CAdESTriPhaseCoSigner {
    private CAdESTriPhaseCoSigner() {
    }

    public static byte[] preCoSign(byte[] byArray, String string, X509Certificate[] x509CertificateArray, AdESPolicy adESPolicy, boolean bl, byte[] byArray2, String string2, String string3, Date date) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        return CAdESTriPhaseCoSigner.getSignedAttributes(byArray2, x509CertificateArray, AOSignConstants.getDigestAlgorithmName(string), byArray, bl, adESPolicy, string2, string3, date).getEncoded("DER");
    }

    private static ASN1Set getSignedAttributes(byte[] byArray, X509Certificate[] x509CertificateArray, String string, byte[] byArray2, boolean bl, AdESPolicy adESPolicy, String string2, String string3, Date date) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.generateSignerInfo(x509CertificateArray[0], string, byArray2, adESPolicy, bl, byArray, date, false, string2, string3);
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    public static byte[] postCoSign(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, X509Certificate[] x509CertificateArray, byte[] byArray4) throws IOException, CertificateEncodingException {
        Object object;
        DEROctetString dEROctetString = new DEROctetString(byArray);
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(string)));
        ASN1Sequence aSN1Sequence = CAdESTriPhaseCoSigner.getContentSignedData(byArray4);
        SignedData signedData = SignedData.getInstance(aSN1Sequence);
        ASN1Set aSN1Set = signedData.getCertificates();
        Enumeration enumeration = aSN1Set.getObjects();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        ASN1Set aSN1Set2 = null;
        if (x509CertificateArray.length != 0) {
            object = new ArrayList();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                object.add(Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            aSN1Set2 = SigUtils.fillRestCerts((List<ASN1Encodable>)object, aSN1EncodableVector);
        }
        object = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < ((ASN1Set)object).size(); ++i) {
            aSN1EncodableVector2.add(SignerInfo.getInstance(((ASN1Set)object).getObjectAt(i)));
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier2, ASN1Set.getInstance(byArray2), algorithmIdentifier, (ASN1OctetString)dEROctetString, null));
        ContentInfo contentInfo = CAdESTriPhaseCoSigner.getContentInfoFromContent(byArray3);
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set2, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private static ContentInfo getContentInfoFromContent(byte[] byArray) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId());
        if (byArray != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
            try {
                cMSProcessableByteArray.write(byteArrayOutputStream);
            }
            catch (CMSException cMSException) {
                throw new IOException("Error en la escritura del procesable CMS: " + cMSException, cMSException);
            }
            return new ContentInfo(aSN1ObjectIdentifier, new BEROctetString(byteArrayOutputStream.toByteArray()));
        }
        return new ContentInfo(aSN1ObjectIdentifier, null);
    }

    private static ASN1Sequence getContentSignedData(byte[] byArray) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        return (ASN1Sequence)aSN1TaggedObject.getObject();
    }
}

