/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CAdESCounterSignerEnveloped {
    private int actualIndex = 0;
    private ASN1Set signedAttr2;
    private AdESPolicy globalPolicy;
    private boolean globalSigningCertificateV2;

    CAdESCounterSignerEnveloped() {
    }

    private void setGlobalPolicy(AdESPolicy adESPolicy) {
        this.globalPolicy = adESPolicy;
    }

    private AdESPolicy getGlobalPolicy() {
        return this.globalPolicy;
    }

    private boolean isGlobalSigningCertificateV2() {
        return this.globalSigningCertificateV2;
    }

    private void setGlobalsigningCertificateV2(boolean bl) {
        this.globalSigningCertificateV2 = bl;
    }

    /*
     * WARNING - void declaration
     */
    byte[] counterSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, CounterSignTarget counterSignTarget, int[] nArray, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        void var23_31;
        ArrayList<ASN1Encodable> arrayList;
        this.setGlobalPolicy(adESPolicy);
        this.setGlobalsigningCertificateV2(bl);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(aSN1Sequence2);
        ASN1Set aSN1Set = signedAndEnvelopedData.getSignerInfos();
        ASN1Set aSN1Set2 = null;
        ASN1Set aSN1Set3 = signedAndEnvelopedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set3.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (certificateArray.length != 0) {
            arrayList = new ArrayList<ASN1Encodable>();
            for (java.security.cert.Certificate certificate : certificateArray) {
                arrayList.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
            aSN1Set2 = SigUtils.fillRestCerts(arrayList, aSN1EncodableVector);
        }
        arrayList = null;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (counterSignTarget.equals((Object)CounterSignTarget.TREE)) {
            ASN1EncodableVector aSN1EncodableVector3 = this.counterTree(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray, string, string2);
        } else if (counterSignTarget.equals((Object)CounterSignTarget.LEAFS)) {
            ASN1EncodableVector aSN1EncodableVector4 = this.counterLeaf(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray, string, string2);
        } else {
            if (counterSignTarget.equals((Object)CounterSignTarget.NODES)) {
                SignedAndEnvelopedData signedAndEnvelopedData2 = signedAndEnvelopedData;
                int n = 0;
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    ASN1EncodableVector aSN1EncodableVector5 = this.counterNode(signedAndEnvelopedData2, p7ContentSignerParameters, privateKey, certificateArray, string, string2, n);
                    SignedAndEnvelopedData signedAndEnvelopedData3 = new SignedAndEnvelopedData(signedAndEnvelopedData.getRecipientInfos(), signedAndEnvelopedData.getDigestAlgorithms(), signedAndEnvelopedData.getEncryptedContentInfo(), aSN1Set2, (ASN1Set)((Object)arrayList), new DERSet(aSN1EncodableVector5));
                    ASN1InputStream aSN1InputStream2 = new ASN1InputStream(signedAndEnvelopedData3.toASN1Primitive().getEncoded("DER"));
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1InputStream2.readObject();
                    aSN1InputStream2.close();
                    signedAndEnvelopedData2 = new SignedAndEnvelopedData(aSN1Sequence3);
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, signedAndEnvelopedData2).getEncoded("DER");
            }
            if (counterSignTarget.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedAndEnvelopedData signedAndEnvelopedData4 = signedAndEnvelopedData;
                int n = 0;
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    ASN1EncodableVector aSN1EncodableVector6 = this.counterNode(signedAndEnvelopedData4, p7ContentSignerParameters, privateKey, certificateArray, string, string2, n);
                    SignedAndEnvelopedData signedAndEnvelopedData5 = new SignedAndEnvelopedData(signedAndEnvelopedData.getRecipientInfos(), signedAndEnvelopedData.getDigestAlgorithms(), signedAndEnvelopedData.getEncryptedContentInfo(), aSN1Set2, (ASN1Set)((Object)arrayList), new DERSet(aSN1EncodableVector6));
                    ASN1InputStream aSN1InputStream3 = new ASN1InputStream(signedAndEnvelopedData5.getEncoded("DER"));
                    ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1InputStream3.readObject();
                    aSN1InputStream3.close();
                    signedAndEnvelopedData4 = new SignedAndEnvelopedData(aSN1Sequence4);
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, signedAndEnvelopedData4).getEncoded("DER");
            }
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(signedAndEnvelopedData.getRecipientInfos(), signedAndEnvelopedData.getDigestAlgorithms(), signedAndEnvelopedData.getEncryptedContentInfo(), aSN1Set2, (ASN1Set)((Object)arrayList), new DERSet((ASN1EncodableVector)var23_31))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add(this.getCounterSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add(this.getCounterLeafSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterNode(SignedAndEnvelopedData signedAndEnvelopedData, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set aSN1Set = signedAndEnvelopedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1Set aSN1Set2 = aSN1Set;
        this.actualIndex = 0;
        for (int i = 0; i < aSN1Set2.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set2.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            SignerInfo signerInfo2 = null;
            if (this.actualIndex == n) {
                signerInfo2 = this.getCounterNodeSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2);
            } else if (this.actualIndex != n) {
                signerInfo2 = this.getCounterNodeSignerInfo(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, string, string2, n);
            }
            ++this.actualIndex;
            aSN1EncodableVector.add(signerInfo2);
        }
        return aSN1EncodableVector;
    }

    private SignerInfo getCounterSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        SignerInfo signerInfo3 = SignerInfo.getInstance(object.nextElement());
                        aSN1EncodableVector.add(this.getCounterSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2));
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            signerInfo2 = this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2);
            aSN1EncodableVector.add(signerInfo2);
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2)));
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet((ASN1Encodable)object));
            }
        } else {
            aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2))));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterLeafSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object = aSN1Object.getAttrValues();
                    Enumeration enumeration2 = ((ASN1Set)object).getObjects();
                    while (enumeration2.hasMoreElements()) {
                        SignerInfo signerInfo3 = SignerInfo.getInstance(enumeration2.nextElement());
                        aSN1EncodableVector.add(this.getCounterLeafSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2));
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector))));
            }
        } else {
            aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2))));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Object aSN1Object;
            Object object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                object = Attribute.getInstance(enumeration.nextElement());
                if (!((Attribute)object).getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    aSN1Object = ((Attribute)object).getAttrValues();
                    Enumeration enumeration2 = aSN1Object.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        aSN1EncodableVector.add(SignerInfo.getInstance(enumeration2.nextElement()));
                    }
                    continue;
                }
                aSN1EncodableVector.add((ASN1Encodable)object);
            }
            aSN1EncodableVector.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
                    aSN1Object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object).add(aSN1Object);
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            } else {
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector))));
            }
        } else {
            aSN1EncodableVector2.add(this.generateSignerInfo(p7ContentSignerParameters, signerInfo, privateKey, certificateArray, string, string2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2))));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                object = Attribute.getInstance(enumeration.nextElement());
                if (!((Attribute)object).getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    Enumeration enumeration2 = ((Attribute)object).getAttrValues().getObjects();
                    while (enumeration2.hasMoreElements()) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)enumeration2.nextElement();
                        SignerInfo signerInfo3 = SignerInfo.getInstance(aSN1Sequence);
                        ++this.actualIndex;
                        if (this.actualIndex != n) {
                            if (this.actualIndex < n) {
                                aSN1EncodableVector.add(this.getCounterNodeSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2, n));
                                continue;
                            }
                            aSN1EncodableVector.add(signerInfo3);
                            continue;
                        }
                        aSN1EncodableVector.add(this.getCounterNodeSignerInfo(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, string, string2));
                    }
                    continue;
                }
                aSN1EncodableVector.add((ASN1Encodable)object);
            }
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            } else {
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector))));
            }
        } else {
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return signerInfo2;
    }

    private SignerInfo generateSignerInfo(P7ContentSignerParameters p7ContentSignerParameters, SignerInfo signerInfo, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, String string2) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1OctetString aSN1OctetString;
        String string3 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string4 = AOSignConstants.getDigestAlgorithmName(string3);
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.generateSignerInfo((X509Certificate)certificateArray[0], string4, signerInfo.getEncryptedDigest().getOctets(), this.getGlobalPolicy(), this.isGlobalSigningCertificateV2(), null, new Date(), false, string, string2);
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        ASN1Set aSN1Set = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string4));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        try {
            aSN1OctetString = this.firma(string3, privateKey, certificateArray);
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma electronica: " + aOException, aOException);
        }
        return new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, aSN1OctetString, null);
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws AOException {
        byte[] byArray;
        try {
            byArray = this.signedAttr2.getEncoded("DER");
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo los atributos firmados: " + exception);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(byArray, string, privateKey, certificateArray, null));
    }
}

