/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CAdESCoSignerEnveloped {
    private ASN1Set signedAttr2;

    CAdESCoSignerEnveloped() {
    }

    byte[] coSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, AdESPolicy adESPolicy, boolean bl, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, byte[] byArray2, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString aSN1OctetString;
        Object object;
        Object object3;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(aSN1Sequence2);
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedAndEnvelopedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set2.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (certificateArray.length != 0) {
            object3 = new ArrayList();
            for (java.security.cert.Certificate certificate : certificateArray) {
                object3.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List<ASN1Encodable>)object3, aSN1EncodableVector);
        }
        object3 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string3 = AOSignConstants.getDigestAlgorithmName((String)object3);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string3));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set3 = null;
        if (byArray2 == null) {
            object = CAdESUtils.generateSignerInfo((X509Certificate)certificateArray[0], string3, p7ContentSignerParameters.getContent(), adESPolicy, bl, null, new Date(), false, string, string2);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set3 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        } else {
            object = CAdESUtils.generateSignerInfo((X509Certificate)certificateArray[0], string3, null, adESPolicy, bl, byArray2, new Date(), false, string, string2);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set3 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        }
        object = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set4 = signedAndEnvelopedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set4.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set4.getObjectAt(i));
            aSN1EncodableVector2.add(signerInfo);
        }
        try {
            aSN1OctetString = this.firma((String)object3, privateKey, certificateArray);
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + aOException, aOException);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set3, (AlgorithmIdentifier)object, aSN1OctetString, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(signedAndEnvelopedData.getRecipientInfos(), signedAndEnvelopedData.getDigestAlgorithms(), signedAndEnvelopedData.getEncryptedContentInfo(), aSN1Set, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    byte[] coSigner(String string, X509Certificate[] x509CertificateArray, InputStream inputStream, AdESPolicy adESPolicy, boolean bl, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, byte[] byArray, String string2, String string3) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object3;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(aSN1Sequence2);
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedAndEnvelopedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set2.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (x509CertificateArray.length != 0) {
            object3 = new ArrayList();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                object3.add(Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List<ASN1Encodable>)object3, aSN1EncodableVector);
        }
        object3 = AOSignConstants.getDigestAlgorithmName(string);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID((String)object3));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set3 = signedAndEnvelopedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        byte[] byArray2 = byArray != null ? (byte[])byArray.clone() : null;
        for (int i = 0; i < aSN1Set3.size(); ++i) {
            object = SignerInfo.getInstance(aSN1Set3.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier3 = ((SignerInfo)object).getDigestAlgorithm();
            if (algorithmIdentifier3.getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object3))) {
                ASN1Set aSN1Set4 = ((SignerInfo)object).getAuthenticatedAttributes();
                for (int j = 0; j < aSN1Set4.size(); ++j) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set4.getObjectAt(j);
                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                    if (!CMSAttributes.messageDigest.getId().toString().equals(dERObjectIdentifier.toString())) continue;
                    DERSet dERSet = (DERSet)aSN1Sequence3.getObjectAt(1);
                    DEROctetString dEROctetString = (DEROctetString)dERSet.getObjectAt(0);
                    byArray2 = dEROctetString.getOctets();
                }
            }
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        ASN1Set aSN1Set5 = null;
        if (byArray2 == null) {
            throw new IllegalStateException("No se puede crear la firma ya que no se ha encontrado un message digest valido");
        }
        object = CAdESUtils.generateSignerInfo(x509CertificateArray[0], (String)object3, null, adESPolicy, bl, byArray2, new Date(), false, string2, string3);
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        aSN1Set5 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        try {
            object = this.firma(string, privateKey, certificateArray);
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + aOException, aOException);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set5, algorithmIdentifier2, (ASN1OctetString)object, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(signedAndEnvelopedData.getRecipientInfos(), signedAndEnvelopedData.getDigestAlgorithms(), signedAndEnvelopedData.getEncryptedContentInfo(), aSN1Set, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws AOException {
        byte[] byArray;
        try {
            byArray = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error al obtener los datos a firmar", iOException);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(byArray, string, privateKey, certificateArray, null));
    }
}

