/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.multi.cades.CAdESCounterSigner;
import es.gob.afirma.signers.multi.cades.CAdESCounterSignerEnveloped;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class AOCAdESCounterSigner
implements AOCounterSigner {
    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Object object;
        Certificate[] certificateArray2;
        Certificate[] certificateArray3;
        Properties properties2;
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
            X509Certificate[] x509CertificateArray = new X509Certificate[1];
            certificateArray3 = x509CertificateArray;
            x509CertificateArray[0] = (X509Certificate)certificateArray[0];
        } else {
            certificateArray3 = certificateArray2 = certificateArray;
        }
        boolean bl = AOSignConstants.isSHA2SignatureAlgorithm(string) ? true : (properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string)));
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        String string2 = "1.2.840.113549.1.7.1";
        String string3 = "binary";
        byte[] byArray2 = new AOCAdESSigner().getData(byArray);
        if (byArray2 != null) {
            object = new MimeHelper(byArray2);
            string3 = ((MimeHelper)object).getDescription();
            string2 = MimeHelper.transformMimeTypeToOid(((MimeHelper)object).getMimeType());
        }
        object = null;
        if (CAdESValidator.isCAdESSignedData(byArray)) {
            try {
                if (counterSignTarget == CounterSignTarget.TREE) {
                    int[] nArray = new int[]{0};
                    object = new CAdESCounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.TREE, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
                } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                    int[] nArray = new int[]{0};
                    object = new CAdESCounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.LEAFS, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
                } else if (counterSignTarget == CounterSignTarget.NODES) {
                    int[] nArray = new int[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        nArray[i] = (Integer)objectArray[i];
                    }
                    nArray = ReadNodesTree.simplyArray(nArray);
                    object = new CAdESCounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.NODES, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
                } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                    String[] stringArray = new String[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringArray[i] = (String)objectArray[i];
                    }
                    int[] nArray = new ReadNodesTree().readNodesFromSigners(stringArray, byArray);
                    object = new CAdESCounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.SIGNERS, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
                }
                return object;
            }
            catch (Exception exception) {
                throw new AOException("Error generando la Contrafirma CAdES", exception);
            }
        }
        try {
            if (counterSignTarget == CounterSignTarget.TREE) {
                int[] nArray = new int[]{0};
                object = new CAdESCounterSignerEnveloped().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.TREE, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
            } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                int[] nArray = new int[]{0};
                object = new CAdESCounterSignerEnveloped().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.LEAFS, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
            } else if (counterSignTarget == CounterSignTarget.NODES) {
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
                nArray = ReadNodesTree.simplyArray(nArray);
                object = new CAdESCounterSignerEnveloped().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.NODES, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
            } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
                int[] nArray = new ReadNodesTree().readNodesFromSigners(stringArray, byArray);
                object = new CAdESCounterSignerEnveloped().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.SIGNERS, nArray, privateKey, certificateArray2, new AdESPolicy(properties2), bl, string2, string3);
            }
            return object;
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Contrafirma CAdES", exception);
        }
    }
}

