/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.multi.cades.CAdESCoSigner;
import es.gob.afirma.signers.multi.cades.CAdESCoSignerEnveloped;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public class AOCAdESCoSigner
implements AOCoSigner {
    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate"));
        byte[] byArray3 = null;
        String string2 = properties2.getProperty("precalculatedHashAlgorithm");
        if (string2 != null) {
            byArray3 = byArray;
        }
        boolean bl2 = AOSignConstants.isSHA2SignatureAlgorithm(string) ? true : (properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string)));
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        String string3 = "1.2.840.113549.1.7.1";
        String string4 = "binary";
        if (byArray != null) {
            try {
                MimeHelper mimeHelper = new MimeHelper(byArray);
                string4 = mimeHelper.getDescription();
                string3 = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + exception);
            }
        }
        try {
            Certificate[] certificateArray2;
            boolean bl3 = CAdESValidator.isCAdESSignedData(byArray2);
            if (bl3) {
                Certificate[] certificateArray3;
                String string5 = properties2.getProperty("mode", "explicit");
                boolean bl4 = string5.equals("explicit") || string2 != null;
                CAdESCoSigner cAdESCoSigner = new CAdESCoSigner();
                AdESPolicy adESPolicy = new AdESPolicy(properties2);
                if (bl) {
                    X509Certificate[] x509CertificateArray = new X509Certificate[1];
                    certificateArray3 = x509CertificateArray;
                    x509CertificateArray[0] = (X509Certificate)certificateArray[0];
                } else {
                    certificateArray3 = certificateArray;
                }
                return cAdESCoSigner.coSigner(p7ContentSignerParameters, byArray2, bl4, adESPolicy, bl2, privateKey, certificateArray3, byArray3, string3, string4);
            }
            CAdESCoSignerEnveloped cAdESCoSignerEnveloped = new CAdESCoSignerEnveloped();
            AdESPolicy adESPolicy = new AdESPolicy(properties2);
            if (bl) {
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                certificateArray2 = x509CertificateArray;
                x509CertificateArray[0] = (X509Certificate)certificateArray[0];
            } else {
                certificateArray2 = certificateArray;
            }
            return cAdESCoSignerEnveloped.coSigner(p7ContentSignerParameters, byArray2, adESPolicy, bl2, privateKey, certificateArray2, byArray3, string3, string4);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Cofirma CAdES", exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate"));
        boolean bl2 = AOSignConstants.isSHA2SignatureAlgorithm(string) ? true : (properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string)));
        String string2 = string;
        String string3 = "1.2.840.113549.1.7.1";
        String string4 = "binary";
        byte[] byArray2 = new AOCAdESSigner().getData(byArray);
        if (byArray2 != null) {
            MimeHelper mimeHelper = new MimeHelper(byArray2);
            string4 = mimeHelper.getDescription();
            string3 = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
        }
        if (CAdESValidator.isCAdESSignedData(byArray)) {
            try {
                X509Certificate[] x509CertificateArray;
                CAdESCoSigner cAdESCoSigner = new CAdESCoSigner();
                if (bl) {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                    x509CertificateArray = x509CertificateArray2;
                    x509CertificateArray2[0] = (X509Certificate)certificateArray[0];
                } else {
                    x509CertificateArray = (X509Certificate[])certificateArray;
                }
                return cAdESCoSigner.coSigner(string2, x509CertificateArray, new ByteArrayInputStream(byArray), new AdESPolicy(properties2), bl2, privateKey, certificateArray, null, string3, string4);
            }
            catch (Exception exception) {
                throw new AOException("Error generando la Cofirma CADES", exception);
            }
        }
        try {
            Certificate[] certificateArray2;
            X509Certificate[] x509CertificateArray;
            CAdESCoSignerEnveloped cAdESCoSignerEnveloped = new CAdESCoSignerEnveloped();
            if (bl) {
                X509Certificate[] x509CertificateArray3 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray3;
                x509CertificateArray3[0] = (X509Certificate)certificateArray[0];
            } else {
                x509CertificateArray = (X509Certificate[])certificateArray;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            AdESPolicy adESPolicy = new AdESPolicy(properties2);
            if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
                X509Certificate[] x509CertificateArray4 = new X509Certificate[1];
                certificateArray2 = x509CertificateArray4;
                x509CertificateArray4[0] = (X509Certificate)certificateArray[0];
            } else {
                certificateArray2 = certificateArray;
            }
            return cAdESCoSignerEnveloped.coSigner(string2, x509CertificateArray, byteArrayInputStream, adESPolicy, bl2, privateKey, certificateArray2, null, string3, string4);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Cofirma CADES", exception);
        }
    }
}

