/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

final class GenSignedData {
    private ASN1Set signedAttr2;

    GenSignedData() {
    }

    byte[] generateSignedData(P7ContentSignerParameters p7ContentSignerParameters, boolean bl, boolean bl2, String string, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray) throws NoSuchAlgorithmException, CertificateException, IOException, AOException {
        AlgorithmIdentifier algorithmIdentifier;
        ContentInfo contentInfo;
        Object object2;
        Object object3;
        if (p7ContentSignerParameters == null) {
            throw new IllegalArgumentException("Los parametros no pueden ser nulos");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        String string2 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string3 = AOSignConstants.getDigestAlgorithmName(string2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID(string3));
        aSN1EncodableVector.add(algorithmIdentifier2);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        byte[] byArray2 = null;
        if (!bl) {
            object3 = new ByteArrayOutputStream();
            byArray2 = p7ContentSignerParameters.getContent();
            object2 = new CMSProcessableByteArray(byArray2);
            try {
                object2.write((OutputStream)object3);
            }
            catch (Exception exception) {
                throw new IOException("Error en la escritura del procesable CMS: " + exception, exception);
            }
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, new BEROctetString(((ByteArrayOutputStream)object3).toByteArray()));
        } else {
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, null);
        }
        object3 = null;
        if (certificateArray.length != 0) {
            object2 = new ArrayList();
            for (java.security.cert.Certificate object4 : certificateArray) {
                object2.add(Certificate.getInstance(ASN1Primitive.fromByteArray(object4.getEncoded())));
            }
            object3 = SigUtils.createBerSetFromList((List<ASN1Encodable>)object2);
        }
        object2 = null;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set = this.generateSignedInfo(string3, byArray2 != null ? byArray2 : p7ContentSignerParameters.getContent(), string, bl2, map, byArray);
        ASN1Set aSN1Set2 = GenSignedData.generateUnsignedInfo(map2);
        try {
            algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        }
        catch (Exception aSN1OctetString) {
            throw new IOException("Error de codificacion: " + aSN1OctetString, aSN1OctetString);
        }
        ASN1OctetString aSN1OctetString = this.firma(string2, privateKey);
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier2, aSN1Set, algorithmIdentifier, aSN1OctetString, aSN1Set2));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(new DERSet(aSN1EncodableVector), contentInfo, (ASN1Set)object3, (ASN1Set)object2, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1Set generateSignedInfo(String string, byte[] byArray, String string2, boolean bl, Map<String, byte[]> map, byte[] byArray2) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(DERObjectIdentifier.getInstance(new ASN1ObjectIdentifier(string2)))));
        if (bl) {
            aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        }
        byte[] byArray3 = byArray2 == null || byArray2.length < 1 ? MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray) : byArray2;
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString((byte[])byArray3.clone()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private static ASN1Set generateUnsignedInfo(Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey) throws AOException {
        byte[] byArray;
        Signature signature;
        try {
            signature = Signature.getInstance(string);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + string, exception);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada", exception);
        }
        try {
            signature.update(this.signedAttr2.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new AOException("Error al configurar la informacion de firma o al obtener los atributos a firmar", exception);
        }
        try {
            byArray = signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma", exception);
        }
        return new DEROctetString(byArray);
    }
}

