/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CounterSigner {
    private int actualIndex = 0;
    private ASN1Set signedAttr2;
    private Map<String, byte[]> atrib2 = new HashMap<String, byte[]>();
    private Map<String, byte[]> uatrib2 = new HashMap<String, byte[]>();

    CounterSigner() {
    }

    byte[] counterSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, CounterSignTarget counterSignTarget, int[] nArray, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, String string, Map<String, byte[]> map, Map<String, byte[]> map2) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        this.atrib2 = map;
        this.uatrib2 = map2;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ASN1Set aSN1Set = signedData.getSignerInfos();
        BERSet bERSet = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set2.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (certificateArray.length != 0) {
            aSN1EncodableVector.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificateArray[0].getEncoded())));
            bERSet = new BERSet(aSN1EncodableVector);
        }
        ASN1Set aSN1Set3 = null;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (counterSignTarget.equals((Object)CounterSignTarget.TREE)) {
            aSN1EncodableVector2 = this.counterTree(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray);
        } else if (counterSignTarget.equals((Object)CounterSignTarget.LEAFS)) {
            aSN1EncodableVector2 = this.counterLeaf(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray);
        } else {
            if (counterSignTarget.equals((Object)CounterSignTarget.NODES)) {
                SignedData signedData2 = signedData;
                int n = 0;
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    aSN1EncodableVector2 = this.counterNode(signedData2, p7ContentSignerParameters, privateKey, certificateArray, n);
                    SignedData signedData3 = new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), bERSet, aSN1Set3, new DERSet(aSN1EncodableVector2));
                    ASN1InputStream aSN1InputStream2 = new ASN1InputStream(signedData3.getEncoded("DER"));
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1InputStream2.readObject();
                    aSN1InputStream2.close();
                    signedData2 = SignedData.getInstance(aSN1Sequence3);
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, signedData2).getEncoded("DER");
            }
            if (counterSignTarget.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedData signedData4 = signedData;
                int n = 0;
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    aSN1EncodableVector2 = this.counterNode(signedData4, p7ContentSignerParameters, privateKey, certificateArray, n);
                    SignedData signedData5 = new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), bERSet, aSN1Set3, new DERSet(aSN1EncodableVector2));
                    ASN1InputStream aSN1InputStream3 = new ASN1InputStream(signedData5.getEncoded("DER"));
                    ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1InputStream3.readObject();
                    aSN1InputStream3.close();
                    signedData4 = SignedData.getInstance(aSN1Sequence4);
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, signedData4).getEncoded("DER");
            }
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), bERSet, aSN1Set3, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            aSN1EncodableVector.add(this.getCounterUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            aSN1EncodableVector.add(this.getCounterLeafUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterNode(SignedData signedData, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set aSN1Set = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1Set aSN1Set2 = aSN1Set;
        this.actualIndex = 0;
        for (int i = 0; i < aSN1Set2.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set2.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            SignerInfo signerInfo2 = null;
            if (this.actualIndex == n) {
                signerInfo2 = this.getCounterNodeUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray);
            } else if (this.actualIndex != n) {
                signerInfo2 = this.getCounterNodeUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, n);
            }
            ++this.actualIndex;
            aSN1EncodableVector.add(signerInfo2);
        }
        return aSN1EncodableVector;
    }

    private SignerInfo getCounterUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        Object e = object.nextElement();
                        if (e instanceof ASN1Sequence) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)e;
                            SignerInfo signerInfo3 = SignerInfo.getInstance(aSN1Sequence);
                            SignerInfo signerInfo4 = this.getCounterUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray);
                            aSN1EncodableVector.add(signerInfo4);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            signerInfo2 = this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray);
            aSN1EncodableVector.add(signerInfo2);
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)object));
            }
        } else {
            aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            Attribute attribute = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(attribute));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterLeafUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        Object e = object.nextElement();
                        if (e instanceof ASN1Sequence) {
                            SignerInfo signerInfo3 = SignerInfo.getInstance(e);
                            SignerInfo signerInfo4 = this.getCounterLeafUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray);
                            aSN1EncodableVector.add(signerInfo4);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)object));
            }
        } else {
            aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            Attribute attribute = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        Object e = object.nextElement();
                        if (e instanceof ASN1Sequence) {
                            aSN1EncodableVector.add(SignerInfo.getInstance(e));
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            aSN1EncodableVector.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else {
                object = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)object));
            }
        } else {
            aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            Attribute attribute = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2));
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
        }
        return signerInfo2;
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object = aSN1Object.getAttrValues();
                    Enumeration enumeration2 = ((ASN1Set)object).getObjects();
                    while (enumeration2.hasMoreElements()) {
                        Object e = enumeration2.nextElement();
                        if (e instanceof ASN1Sequence) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)e;
                            SignerInfo signerInfo3 = SignerInfo.getInstance(aSN1Sequence);
                            ++this.actualIndex;
                            if (this.actualIndex != n) {
                                if (this.actualIndex < n) {
                                    aSN1EncodableVector.add(this.getCounterNodeUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, n));
                                    continue;
                                }
                                aSN1EncodableVector.add(signerInfo3);
                                continue;
                            }
                            aSN1EncodableVector.add(this.getCounterNodeUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray));
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            }
        } else {
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return signerInfo2;
    }

    private ASN1Set generateSignerInfo(X509Certificate x509Certificate, String string, byte[] byArray) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray)))));
        aSN1EncodableVector.add(new Attribute(RFC4519Style.serialNumber, (ASN1Set)new DERSet(new DERPrintableString(x509Certificate.getSerialNumber().toString()))));
        if (this.atrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.atrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateUnsignerInfo() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.uatrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateUnsignerInfoFromCounter(Attribute attribute) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.uatrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        aSN1EncodableVector.add(attribute);
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private SignerInfo unsignedAtributte(P7ContentSignerParameters p7ContentSignerParameters, SignerInfo signerInfo, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1OctetString aSN1OctetString;
        String string = p7ContentSignerParameters.getSignatureAlgorithm();
        String string2 = AOSignConstants.getDigestAlgorithmName(string);
        ASN1Set aSN1Set = this.generateSignerInfo((X509Certificate)certificateArray[0], string2, signerInfo.getEncryptedDigest().getOctets());
        ASN1Set aSN1Set2 = this.generateUnsignerInfo();
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string2));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        try {
            aSN1OctetString = this.firma(string, privateKey);
        }
        catch (Exception exception) {
            throw new IOException("Error realizando la firma: " + exception, exception);
        }
        return new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, aSN1OctetString, aSN1Set2);
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey) throws AOException {
        byte[] byArray;
        byte[] byArray2;
        Signature signature;
        try {
            signature = Signature.getInstance(string);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + string, exception);
        }
        try {
            byArray2 = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error obteniendo los datos a firmar", iOException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada", exception);
        }
        try {
            signature.update(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new AOException("Error al configurar la informacion de firma", signatureException);
        }
        try {
            byArray = signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma", exception);
        }
        return new DEROctetString(byArray);
    }
}

