/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

final class CoSigner {
    private ASN1Set signedAttr2;

    CoSigner() {
    }

    byte[] coSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, boolean bl, String string, PrivateKey privateKey, java.security.cert.Certificate[] certificateArray, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString aSN1OctetString;
        Object object2;
        Object object3;
        Object object4;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        byte[] byArray3 = null;
        if (!bl) {
            object4 = new ByteArrayOutputStream();
            byArray3 = p7ContentSignerParameters.getContent();
            object3 = new CMSProcessableByteArray(byArray3);
            try {
                object3.write((OutputStream)object4);
            }
            catch (Exception exception) {
                throw new IOException("Error en la escritura del procesable CMS: " + exception, exception);
            }
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, new BEROctetString(((ByteArrayOutputStream)object4).toByteArray()));
        } else {
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, null);
        }
        object4 = null;
        object3 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = ((ASN1Set)object3).getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (certificateArray.length != 0) {
            object2 = new ArrayList();
            for (java.security.cert.Certificate certificate : certificateArray) {
                object2.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
            object4 = SigUtils.fillRestCerts((List<ASN1Encodable>)object2, aSN1EncodableVector);
        }
        object2 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string2 = AOSignConstants.getDigestAlgorithmName((String)object2);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string2));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set = null;
        aSN1Set = byArray2 == null ? this.generateSignerInfo(string2, byArray3 != null ? byArray3 : p7ContentSignerParameters.getContent(), string, map) : this.generateSignerInfoFromHash((X509Certificate)certificateArray[0], byArray2, string, map);
        ASN1Set aSN1Set2 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set3 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set3.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set3.getObjectAt(i));
            aSN1EncodableVector2.add(signerInfo);
        }
        try {
            aSN1OctetString = this.firma((String)object2, privateKey);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, aSN1OctetString, aSN1Set2));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, (ASN1Set)object4, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    byte[] coSigner(String string, X509Certificate[] x509CertificateArray, byte[] byArray, String string2, PrivateKey privateKey, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1OctetString aSN1OctetString;
        Object object2;
        byte[] byArray3 = byArray2 != null ? (byte[])byArray2.clone() : null;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        enumeration.nextElement();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ContentInfo contentInfo = signedData.getEncapContentInfo();
        DEROctetString dEROctetString = (DEROctetString)contentInfo.getContent();
        byte[] byArray4 = null;
        if (dEROctetString != null) {
            byArray4 = AOUtil.getDataFromInputStream(dEROctetString.getOctetStream());
        }
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = aSN1Set2.getObjects();
        while (enumeration2.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration2.nextElement());
        }
        if (x509CertificateArray.length != 0) {
            object2 = new ArrayList();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                object2.add(Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List<ASN1Encodable>)object2, aSN1EncodableVector);
        }
        object2 = AOSignConstants.getDigestAlgorithmName(string);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID((String)object2));
        TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set3 = null;
        ASN1Set aSN1Set4 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set5 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set5.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set5.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier3 = signerInfo.getDigestAlgorithm();
            if (algorithmIdentifier3.getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object2))) {
                ASN1Set aSN1Set6 = signerInfo.getAuthenticatedAttributes();
                for (int j = 0; j < aSN1Set6.size(); ++j) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set6.getObjectAt(j);
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                    if (!CMSAttributes.messageDigest.getId().toString().equals(aSN1ObjectIdentifier.toString())) continue;
                    DERSet dERSet = (DERSet)aSN1Sequence3.getObjectAt(1);
                    DEROctetString dEROctetString2 = (DEROctetString)dERSet.getObjectAt(0);
                    byArray3 = dEROctetString2.getOctets();
                }
            }
            aSN1EncodableVector2.add(signerInfo);
        }
        if (byArray4 != null) {
            aSN1Set3 = this.generateSignerInfo((String)object2, byArray4, string2, map);
        } else if (byArray3 != null) {
            aSN1Set3 = this.generateSignerInfoFromHash(x509CertificateArray[0], byArray3, string2, map);
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            aSN1OctetString = this.firma(string, privateKey);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set3, algorithmIdentifier2, aSN1OctetString, aSN1Set4));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1Set generateSignerInfo(String string, byte[] byArray, String string2, Map<String, byte[]> map) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(DERObjectIdentifier.getInstance(new ASN1ObjectIdentifier(string2)))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        byte[] byArray2 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray);
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString((byte[])byArray2.clone()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateSignerInfoFromHash(X509Certificate x509Certificate, byte[] byArray, String string, Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(DERObjectIdentifier.getInstance(new ASN1ObjectIdentifier(string)))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(byArray))));
        aSN1EncodableVector.add(new Attribute(RFC4519Style.serialNumber, (ASN1Set)new DERSet(new DERPrintableString(x509Certificate.getSerialNumber().toString()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private static ASN1Set generateUnsignerInfo(Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey) throws AOException {
        byte[] byArray;
        byte[] byArray2;
        Signature signature;
        try {
            signature = Signature.getInstance(string);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + string, exception);
        }
        try {
            byArray2 = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error obteniendo los atributos firmados", iOException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada", exception);
        }
        try {
            signature.update(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new AOException("Error al configurar la informacion de firma", signatureException);
        }
        try {
            byArray = signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma", exception);
        }
        return new DEROctetString(byArray);
    }
}

