/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.signers.pkcs7.DigestedData;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class CAdESValidator {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afima");

    private CAdESValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCAdESData(byte[] byArray) throws IOException {
        Enumeration enumeration;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            enumeration = ((ASN1Sequence)aSN1InputStream.readObject()).getObjects();
        }
        catch (ClassCastException classCastException) {
            boolean bl = false;
            return bl;
        }
        finally {
            aSN1InputStream.close();
        }
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.data)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            new DEROctetString(aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESData: " + exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCAdESSignedData(byte[] byArray) throws IOException {
        boolean bl = false;
        ASN1InputStream aSN1InputStream = null;
        try {
            aSN1InputStream = new ASN1InputStream(byArray);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
            if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
                bl = true;
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
            SignedData signedData = SignedData.getInstance(aSN1Sequence2);
            ASN1Set aSN1Set = signedData.getSignerInfos();
            for (int i = 0; i < aSN1Set.size(); ++i) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
                bl = CAdESValidator.verifySignerInfo(signerInfo);
            }
        }
        catch (Exception exception) {
            LOGGER.info("Los datos proporcionados no son un SignedData de CAdES: " + exception);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (aSN1InputStream != null) {
                aSN1InputStream.close();
            }
        }
        return bl;
    }

    private static boolean verifySignerInfo(SignerInfo signerInfo) {
        boolean bl = false;
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)enumeration.nextElement();
            Attribute attribute = new Attribute((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0), (ASN1Set)aSN1Sequence.getObjectAt(1));
            if (!attribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificate) && !attribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCAdESDigestedData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        boolean bl = false;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            aSN1InputStream.close();
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.digestedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            new DigestedData((ASN1Sequence)aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.info("Los datos proporcionados no son de tipo CAdESDigestedData: " + exception);
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCAdESEncryptedData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        boolean bl = false;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            aSN1InputStream.close();
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.encryptedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        try {
            DERInteger.getInstance(aSN1Sequence2.getObjectAt(0));
            EncryptedContentInfo.getInstance(aSN1Sequence2.getObjectAt(1));
            if (aSN1Sequence2.size() == 3) {
                aSN1Sequence2.getObjectAt(2);
            }
        }
        catch (Exception exception) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESEncryptedData: " + exception);
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCAdESEnvelopedData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        boolean bl = false;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            aSN1InputStream.close();
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.envelopedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            EnvelopedData.getInstance(aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESEnvelopedData: " + exception);
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCAdESSignedAndEnvelopedData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        boolean bl = false;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            aSN1InputStream.close();
        }
        aSN1InputStream.close();
        Enumeration enumeration = aSN1Sequence.getObjects();
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
        SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(aSN1Sequence2);
        ASN1Set aSN1Set = signedAndEnvelopedData.getSignerInfos();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            bl = CAdESValidator.verifySignerInfo(signerInfo);
        }
        return bl;
    }

    public static boolean isCAdESValid(byte[] byArray, String string) throws IOException {
        if (string.equals("Data")) {
            return CAdESValidator.isCAdESData(byArray);
        }
        if (string.equals("SignedData")) {
            return CAdESValidator.isCAdESSignedData(byArray);
        }
        if (string.equals("DigestedData")) {
            return CAdESValidator.isCAdESDigestedData(byArray);
        }
        if (string.equals("EncryptedData")) {
            return CAdESValidator.isCAdESEncryptedData(byArray);
        }
        if (string.equals("EnvelopedData")) {
            return CAdESValidator.isCAdESEnvelopedData(byArray);
        }
        if (string.equals("SignedAndEnvelopedData")) {
            return CAdESValidator.isCAdESSignedAndEnvelopedData(byArray);
        }
        LOGGER.warning("Tipo de contenido CADES no reconocido");
        return false;
    }

    public static boolean isCAdESValid(byte[] byArray) throws IOException {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        boolean bl = CAdESValidator.isCAdESData(byArray);
        if (!bl) {
            bl = CAdESValidator.isCAdESSignedData(byArray);
        }
        if (!bl) {
            bl = CAdESValidator.isCAdESDigestedData(byArray);
        }
        if (!bl) {
            bl = CAdESValidator.isCAdESEncryptedData(byArray);
        }
        if (!bl) {
            bl = CAdESValidator.isCAdESEnvelopedData(byArray);
        }
        if (!bl) {
            bl = CAdESValidator.isCAdESSignedAndEnvelopedData(byArray);
        }
        return bl;
    }
}

