/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOSigPolicyQualifierInfo;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;

public final class CAdESUtils {
    private CAdESUtils() {
    }

    public static ASN1EncodableVector generateSignerInfo(X509Certificate x509Certificate, String string, byte[] byArray, AdESPolicy adESPolicy, boolean bl, byte[] byArray2, Date date, boolean bl2, String string2, String string3) throws NoSuchAlgorithmException, IOException, CertificateEncodingException {
        Object object;
        Object object2;
        ASN1Encodable aSN1Encodable;
        Object object3;
        Object object4;
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string));
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.initContexExpecific(string, byArray, PKCSObjectIdentifiers.data.getId(), byArray2, date, bl2);
        if (bl) {
            aSN1Object2 = new GeneralNames(new GeneralName(X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded())));
            aSN1Object = new IssuerSerial((GeneralNames)aSN1Object2, x509Certificate.getSerialNumber());
            object4 = MessageDigest.getInstance(string).digest(x509Certificate.getEncoded());
            object3 = new ESSCertIDv2[]{new ESSCertIDv2(algorithmIdentifier, (byte[])object4, (IssuerSerial)aSN1Object)};
            aSN1Encodable = adESPolicy.getPolicyIdentifier() != null ? new SigningCertificateV2((ESSCertIDv2[])object3, CAdESUtils.getPolicyInformation(adESPolicy)) : new SigningCertificateV2((ESSCertIDv2[])object3);
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet(aSN1Encodable)));
        } else {
            aSN1Object2 = new GeneralName(X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded()));
            aSN1Object = new GeneralNames((GeneralName)aSN1Object2);
            object4 = new IssuerSerial((GeneralNames)aSN1Object, x509Certificate.getSerialNumber());
            object3 = MessageDigest.getInstance(string).digest(x509Certificate.getEncoded());
            aSN1Encodable = new ESSCertID((byte[])object3, (IssuerSerial)object4);
            if (adESPolicy.getPolicyIdentifier() != null) {
                object2 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object2).add(new DERSequence(aSN1Encodable));
                ((ASN1EncodableVector)object2).add(new DERSequence(CAdESUtils.getPolicyInformation(adESPolicy)));
                object = SigningCertificate.getInstance(new DERSequence((ASN1EncodableVector)object2));
            } else {
                object = new SigningCertificate((ESSCertID)aSN1Encodable);
            }
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)object)));
        }
        if (adESPolicy.getPolicyIdentifier() != null) {
            aSN1Object2 = new DERObjectIdentifier(adESPolicy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", ""));
            aSN1Object = adESPolicy.getPolicyIdentifierHashAlgorithm() != null ? SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(adESPolicy.getPolicyIdentifierHashAlgorithm()))) : algorithmIdentifier;
            object4 = adESPolicy.getPolicyIdentifierHash() != null ? (Object)Base64.decode(adESPolicy.getPolicyIdentifierHash()) : (Object)new byte[]{0};
            object3 = new DigestInfo((AlgorithmIdentifier)aSN1Object, (byte[])object4);
            aSN1Encodable = null;
            if (adESPolicy.getPolicyQualifier() != null) {
                aSN1Encodable = new AOSigPolicyQualifierInfo(adESPolicy.getPolicyQualifier().toString());
            }
            object = new ASN1EncodableVector();
            ((ASN1EncodableVector)object).add(aSN1Object2);
            ((ASN1EncodableVector)object).add(((DigestInfo)object3).toASN1Primitive());
            if (aSN1Encodable != null) {
                ((ASN1EncodableVector)object).add(new DERSequence(((AOSigPolicyQualifierInfo)aSN1Encodable).toASN1Primitive()));
            }
            object2 = new DERSequence((ASN1EncodableVector)object);
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Set)new DERSet(((ASN1Primitive)object2).toASN1Primitive())));
        }
        if (string2 != null && !bl2) {
            aSN1Object2 = string3 != null ? new ContentHints(new ASN1ObjectIdentifier(string2), new DERUTF8String(string3)) : new ContentHints(new ASN1ObjectIdentifier(string2));
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Set)new DERSet(((ContentHints)aSN1Object2).toASN1Primitive())));
        }
        return aSN1EncodableVector;
    }

    private static PolicyInformation[] getPolicyInformation(AdESPolicy adESPolicy) {
        if (adESPolicy == null) {
            throw new IllegalArgumentException("La politica de firma no puede ser nula en este punto");
        }
        PolicyQualifierId policyQualifierId = PolicyQualifierId.id_qt_cps;
        DERIA5String dERIA5String = null;
        if (adESPolicy.getPolicyQualifier() != null && !adESPolicy.getPolicyQualifier().equals("")) {
            dERIA5String = new DERIA5String(adESPolicy.getPolicyQualifier().toString());
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        PolicyQualifierInfo policyQualifierInfo = null;
        if (dERIA5String != null) {
            aSN1EncodableVector.add(policyQualifierId);
            aSN1EncodableVector.add(dERIA5String);
            policyQualifierInfo = new PolicyQualifierInfo(new DERSequence(aSN1EncodableVector));
        }
        if (adESPolicy.getPolicyQualifier() == null || policyQualifierInfo == null) {
            return new PolicyInformation[]{new PolicyInformation(new ASN1ObjectIdentifier(adESPolicy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", "")))};
        }
        return new PolicyInformation[]{new PolicyInformation(new ASN1ObjectIdentifier(adESPolicy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", "")), new DERSequence(policyQualifierInfo))};
    }

    static ASN1EncodableVector initContexExpecific(String string, byte[] byArray, String string2, byte[] byArray2, Date date, boolean bl) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (string2 != null) {
            aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(new DERObjectIdentifier(string2))));
        }
        if (!bl) {
            aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(date))));
        }
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(byArray2 != null ? byArray2 : MessageDigest.getInstance(string).digest(byArray)))));
        return aSN1EncodableVector;
    }
}

