/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

public final class CAdESTriPhaseSigner {
    private CAdESTriPhaseSigner() {
    }

    public static byte[] preSign(String string, byte[] byArray, X509Certificate[] x509CertificateArray, AdESPolicy adESPolicy, boolean bl, byte[] byArray2, Date date, boolean bl2, String string2, String string3) throws AOException {
        ASN1Set aSN1Set;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos una entrada");
        }
        try {
            aSN1Set = SigUtils.getAttributeSet(new AttributeTable(CAdESUtils.generateSignerInfo(x509CertificateArray[0], string, byArray, adESPolicy, bl, byArray2, date, bl2, string2, string3)));
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo los atributos a firmar: " + exception, exception);
        }
        try {
            return aSN1Set.getEncoded("DER");
        }
        catch (Exception exception) {
            throw new AOException("Error al codificar los datos ASN.1 a firmar finalmente", exception);
        }
    }

    public static byte[] postSign(String string, byte[] byArray, X509Certificate[] x509CertificateArray, byte[] byArray2, byte[] byArray3) throws AOException {
        ContentInfo contentInfo;
        Object object2;
        ASN1Set aSN1Set;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2;
        TBSCertificateStructure tBSCertificateStructure;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos una entrada");
        }
        try {
            tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido crear la estructura de certificados", exception);
        }
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificateStructure.getIssuer()), tBSCertificateStructure.getSerialNumber().getValue()));
        try {
            algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID(string));
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo el OID en ASN.1 del algoritmo de huella digital", exception);
        }
        try {
            algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        }
        catch (Exception exception) {
            throw new AOException("Error al codificar el algoritmo de cifrado", exception);
        }
        DEROctetString dEROctetString = new DEROctetString(byArray2);
        try {
            aSN1Set = (ASN1Set)ASN1Primitive.fromByteArray(byArray3);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la inclusion de la recuperacion de los SignedAttibutes", iOException);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new SignerInfo(signerIdentifier, algorithmIdentifier2, aSN1Set, algorithmIdentifier, (ASN1OctetString)dEROctetString, null));
        if (byArray != null) {
            object2 = new ByteArrayOutputStream();
            CMSProcessableByteArray object = new CMSProcessableByteArray(byArray);
            try {
                object.write((OutputStream)object2);
            }
            catch (Exception aSN1EncodableVector2) {
                throw new AOException("Error en la escritura del contenido implicito en el ContentInfo", aSN1EncodableVector2);
            }
            contentInfo = new ContentInfo(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId()), new BEROctetString(((ByteArrayOutputStream)object2).toByteArray()));
        } else {
            contentInfo = new ContentInfo(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId()), null);
        }
        object2 = new ArrayList();
        for (X509Certificate x509Certificate : x509CertificateArray) {
            try {
                object2.add(Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").severe("Error insertando el certificado '" + AOUtil.getCN(x509Certificate) + "' en la cadena de confianza");
            }
        }
        ASN1Set aSN1Set2 = SigUtils.createBerSetFromList((List<ASN1Encodable>)object2);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(algorithmIdentifier2);
        try {
            return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(new DERSet(aSN1EncodableVector2), contentInfo, aSN1Set2, null, new DERSet(aSN1EncodableVector))).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error creando el ContentInfo de CAdES: " + iOException, iOException);
        }
    }
}

