/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.cades.GenCAdESEPESSignedData;
import es.gob.afirma.signers.pkcs7.BCChecker;
import es.gob.afirma.signers.pkcs7.ObtainContentSignedData;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOCAdESSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        String string2;
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos un elemento");
        }
        AOCAdESSigner.checkAlgorithm(string);
        new BCChecker().checkBouncyCastle();
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("precalculatedHashAlgorithm");
        boolean bl = AOSignConstants.isSHA2SignatureAlgorithm(string) ? true : (properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string)));
        String string4 = properties2.getProperty("mode", "explicit");
        if (string3 != null) {
            string2 = AOSignConstants.getDigestAlgorithmName(string3);
            byArray2 = byArray;
        } else {
            string2 = AOSignConstants.getDigestAlgorithmName(string);
            try {
                byArray2 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("Algoritmo no soportado: " + noSuchAlgorithmException, noSuchAlgorithmException);
            }
        }
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        try {
            Certificate[] certificateArray2;
            boolean bl2 = false;
            if (string4.equals("explicit") || string3 != null) {
                bl2 = true;
            }
            String string5 = "1.2.840.113549.1.7.1";
            String string6 = "binary";
            if (byArray != null) {
                try {
                    MimeHelper mimeHelper = new MimeHelper(byArray);
                    string6 = mimeHelper.getDescription();
                    string5 = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
                }
                catch (Exception exception) {
                    Logger.getLogger("es.gob.afirma").warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + exception);
                }
            }
            AdESPolicy adESPolicy = new AdESPolicy(properties2);
            if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                certificateArray2 = x509CertificateArray;
                x509CertificateArray[0] = (X509Certificate)certificateArray[0];
            } else {
                certificateArray2 = certificateArray;
            }
            return GenCAdESEPESSignedData.generateSignedData(p7ContentSignerParameters, bl2, adESPolicy, bl, privateKey, certificateArray2, byArray2, string2, Boolean.parseBoolean(properties2.getProperty("padesMode", "false")), string5, string6);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la firma CAdES: " + exception, exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        AOCAdESSigner.checkAlgorithm(string);
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").newInstance()).cosign(byArray, byArray2, string, privateKey, certificateArray, properties);
        }
        catch (Exception exception) {
            throw new AOException("Error general en la cofirma: " + exception, exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        AOCAdESSigner.checkAlgorithm(string);
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").newInstance()).cosign(byArray, string, privateKey, certificateArray, properties);
        }
        catch (Exception exception) {
            throw new AOException("Error general en la cofirma: " + exception, exception);
        }
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        AOCAdESSigner.checkAlgorithm(string);
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCounterSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCounterSigner").newInstance()).countersign(byArray, string, counterSignTarget, objectArray, privateKey, certificateArray, properties);
        }
        catch (Exception exception) {
            throw new AOException("Error general en la contrafirma: " + exception, exception);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        new BCChecker().checkBouncyCastle();
        if (!CAdESValidator.isCAdESValid(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        try {
            return new ReadNodesTree().readNodesTree(byArray, bl);
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido obtener el arbol de firmantes de la firma, se devolvera null: " + exception);
            return null;
        }
    }

    @Override
    public boolean isSign(byte[] byArray) throws IOException {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        new BCChecker().checkBouncyCastle();
        return CAdESValidator.isCAdESSignedData(byArray);
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException, IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Se han introducido datos nulos para su comprobacion");
        }
        new BCChecker().checkBouncyCastle();
        if (!CAdESValidator.isCAdESValid(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return ObtainContentSignedData.obtainData(byArray);
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".csig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOInvalidFormatException, IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("CAdES");
    }

    private static void checkAlgorithm(String string) throws AOException {
        if (string == null) {
            throw new IllegalArgumentException("El algoritmo de firma no puede ser nulo");
        }
        if (string.toUpperCase().startsWith("MD")) {
            throw new AOException("CAdES no permite huellas digitales MD2 o MD5 (Decision 130/2011 CE)");
        }
    }
}

