/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.keystores.filters;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public final class ThumprintCertificateFilter
extends CertificateFilter {
    private final String digestAlgorithm;
    private final String thumbprint;

    public ThumprintCertificateFilter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("Se debe indicar tanto el algoritmo como la huella digital del certificado");
        }
        this.digestAlgorithm = string;
        this.thumbprint = string2.replace(" ", "");
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        try {
            return this.thumbprint.equalsIgnoreCase(AOUtil.hexify(MessageDigest.getInstance(this.digestAlgorithm).digest(x509Certificate.getEncoded()), ""));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger("es.gob.afirma").warning("Algoritmo de huella digital no reconocido: " + noSuchAlgorithmException);
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Logger.getLogger("es.gob.afirma").warning("No se ha podido obtener la codificacion del certificado: " + certificateEncodingException);
            return false;
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").warning("No se ha podido filtrar el certificado: " + exception);
            return false;
        }
    }
}

