/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.keystores.filters;

import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.X509Certificate;

public final class TextContainedCertificateFilter
extends CertificateFilter {
    private final String[] subjectTexts;
    private final String[] issuerTexts;

    public TextContainedCertificateFilter(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            throw new IllegalArgumentException("Al menos uno de los criterios de filtrado debe no ser nulo");
        }
        this.subjectTexts = stringArray;
        this.issuerTexts = stringArray2;
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        String string;
        if (this.subjectTexts != null) {
            string = x509Certificate.getSubjectX500Principal().toString().toLowerCase();
            for (String string2 : this.subjectTexts) {
                if (string2 == null || string.contains(string2.toLowerCase())) continue;
                return false;
            }
        }
        if (this.issuerTexts != null) {
            string = x509Certificate.getIssuerX500Principal().toString().toLowerCase();
            for (String string2 : this.issuerTexts) {
                if (string2 == null || string.contains(string2.toLowerCase())) continue;
                return false;
            }
        }
        return true;
    }
}

