/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.keystores.filters;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.AuthenticationDNIeFilter;
import es.gob.afirma.miniapplet.keystores.filters.SignatureDNIeFilter;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class SSLFilter
extends CertificateFilter {
    private static final String[] SUBJECT_SN_PREFIX = new String[]{"serialnumber=", "SERIALNUMBER=", "2.5.4.5="};
    private final String serialNumber;
    private final AuthenticationDNIeFilter authenticationDnieCertFilter;
    private final SignatureDNIeFilter signatureDnieCertFilter;

    public SSLFilter(String string) {
        this.serialNumber = SSLFilter.prepareSerialNumber(string);
        this.authenticationDnieCertFilter = new AuthenticationDNIeFilter();
        this.signatureDnieCertFilter = new SignatureDNIeFilter();
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return SSLFilter.prepareSerialNumber(SSLFilter.getCertificateSN(x509Certificate)).equalsIgnoreCase(this.serialNumber);
    }

    @Override
    public String[] matches(String[] stringArray, AOKeyStoreManager aOKeyStoreManager) {
        X509Certificate[] x509CertificateArray = new X509Certificate[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            x509CertificateArray[i] = aOKeyStoreManager.getCertificate(stringArray[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block3: for (int i = 0; i < stringArray.length; ++i) {
            X509Certificate x509Certificate = aOKeyStoreManager.getCertificate(stringArray[i]);
            try {
                if (!this.matches(x509Certificate)) continue;
                if (this.isAuthenticationDnieCert(x509Certificate)) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        X509Certificate x509Certificate2;
                        if (i == j || !this.isSignatureDnieCert(x509Certificate2 = aOKeyStoreManager.getCertificate(stringArray[j])) || SSLFilter.getSubjectSN(x509Certificate2) == null || !SSLFilter.getSubjectSN(x509Certificate2).equalsIgnoreCase(SSLFilter.getSubjectSN(x509Certificate)) || !SSLFilter.getExpiredDate(x509Certificate2).equals(SSLFilter.getExpiredDate(x509Certificate))) continue;
                        arrayList.add(stringArray[j]);
                        continue block3;
                    }
                    continue;
                }
                arrayList.add(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("Error en la verificacion del certificado '" + x509Certificate.getSerialNumber() + "': " + exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isAuthenticationDnieCert(X509Certificate x509Certificate) {
        return this.authenticationDnieCertFilter.matches(x509Certificate);
    }

    private boolean isSignatureDnieCert(X509Certificate x509Certificate) {
        return this.signatureDnieCertFilter.matches(x509Certificate);
    }

    private static String getSubjectSN(X509Certificate x509Certificate) {
        List<Rdn> list;
        String string = x509Certificate.getSubjectX500Principal().getName();
        try {
            list = new LdapName(string).getRdns();
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
        if (list != null && !list.isEmpty()) {
            for (Rdn rdn : list) {
                String string2 = rdn.toString();
                for (String string3 : SUBJECT_SN_PREFIX) {
                    if (!string2.startsWith(string3)) continue;
                    return string2.substring(string3.length()).replace("#", "");
                }
            }
        }
        return null;
    }

    private static String getExpiredDate(X509Certificate x509Certificate) {
        return new SimpleDateFormat("yyyy-MM-dd").format(x509Certificate.getNotAfter());
    }

    private static String getCertificateSN(X509Certificate x509Certificate) {
        return SSLFilter.bigIntegerToHex(x509Certificate.getSerialNumber());
    }

    private static String bigIntegerToHex(BigInteger bigInteger) {
        return AOUtil.hexify(bigInteger.toByteArray(), "");
    }

    private static String prepareSerialNumber(String string) {
        int n;
        String string2 = string.trim().replace(" ", "").replace("#", "");
        for (n = 0; n < string2.length() && string2.charAt(n) == '0'; ++n) {
        }
        return string2.substring(n);
    }
}

