/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.keystores.filters;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.AuthenticationDNIeFilter;
import es.gob.afirma.miniapplet.keystores.filters.KeyUsagesPattern;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class QualifiedCertificatesFilter
extends CertificateFilter {
    private static final String[] SUBJECT_SN_PREFIX = new String[]{"serialnumber=", "SERIALNUMBER=", "2.5.4.5="};
    private final String serialNumber;

    public QualifiedCertificatesFilter(String string) {
        this.serialNumber = QualifiedCertificatesFilter.prepareSerialNumber(string);
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return QualifiedCertificatesFilter.prepareSerialNumber(QualifiedCertificatesFilter.getCertificateSN(x509Certificate)).equalsIgnoreCase(this.serialNumber);
    }

    @Override
    public String[] matches(String[] stringArray, AOKeyStoreManager aOKeyStoreManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            X509Certificate x509Certificate = aOKeyStoreManager.getCertificate(string);
            if (x509Certificate == null) {
                Logger.getLogger("es.gob.afirma").warning("No se pudo recuperar el certificado: " + string);
                continue;
            }
            try {
                if (!this.matches(x509Certificate)) continue;
                if (QualifiedCertificatesFilter.isSignatureCert(x509Certificate)) {
                    arrayList.add(string);
                    continue;
                }
                String string2 = QualifiedCertificatesFilter.searchQualifiedSignatureCertificate(x509Certificate, aOKeyStoreManager, stringArray);
                if (string2 == null) {
                    if (new AuthenticationDNIeFilter().matches(x509Certificate)) continue;
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string2);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("Error en la verificacion del certificado '" + x509Certificate.getSerialNumber() + "': " + exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String searchQualifiedSignatureCertificate(X509Certificate x509Certificate, AOKeyStoreManager aOKeyStoreManager, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("El certificado al que corresponde el numero de serie no es un certificado ").append("de firma, se mostrara su informacion ademas de la del resto de certificados ").append("del almacen:\n").append("Certificado original:\n").append("\t- Numero de serie: ").append(x509Certificate.getSerialNumber()).append('\n').append("\t- Issuer: ").append(x509Certificate.getIssuerDN()).append('\n').append("\t- Fecha de caducidad: ").append(QualifiedCertificatesFilter.getExpiredDate(x509Certificate)).append('\n');
        if (x509Certificate.getKeyUsage() != null) {
            stringBuilder.append("\t- KeyUsages:\n").append("\t\t+ digitalSignature: ").append(x509Certificate.getKeyUsage()[0]).append('\n').append("\t\t+ nonRepudiation: ").append(x509Certificate.getKeyUsage()[1]).append('\n').append("\t\t+ keyEncipherment: ").append(x509Certificate.getKeyUsage()[2]).append('\n').append("\t\t+ dataEncipherment: ").append(x509Certificate.getKeyUsage()[3]).append('\n').append("\t\t+ keyAgreement: ").append(x509Certificate.getKeyUsage()[4]).append('\n').append("\t\t+ keyCertSign: ").append(x509Certificate.getKeyUsage()[5]).append('\n').append("\t\t+ cRLSign: ").append(x509Certificate.getKeyUsage()[6]).append('\n').append("\t\t+ encipherOnly: ").append(x509Certificate.getKeyUsage()[7]).append('\n').append("\t\t+ decipherOnly: ").append(x509Certificate.getKeyUsage()[8]).append('\n');
        } else {
            stringBuilder.append("\t- El certificado no tiene definidos KeyUsages\n");
        }
        stringBuilder.append(" -----\n");
        for (String string : stringArray) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            X509Certificate x509Certificate2 = aOKeyStoreManager.getCertificate(string);
            if (x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber())) continue;
            stringBuilder.append("Certificado:\n").append("\t- Numero de serie: ").append(x509Certificate2.getSerialNumber()).append('\n').append("\t- Issuer: ").append(x509Certificate2.getIssuerDN()).append('\n').append("\t- Fecha de caducidad: ").append(QualifiedCertificatesFilter.getExpiredDate(x509Certificate2)).append('\n');
            if (x509Certificate2.getKeyUsage() != null) {
                stringBuilder.append("\t- KeyUsages:\n").append("\t\t+ digitalSignature: ").append(x509Certificate2.getKeyUsage()[0]).append('\n').append("\t\t+ nonRepudiation: ").append(x509Certificate2.getKeyUsage()[1]).append('\n').append("\t\t+ keyEncipherment: ").append(x509Certificate2.getKeyUsage()[2]).append('\n').append("\t\t+ dataEncipherment: ").append(x509Certificate2.getKeyUsage()[3]).append('\n').append("\t\t+ keyAgreement: ").append(x509Certificate2.getKeyUsage()[4]).append('\n').append("\t\t+ keyCertSign: ").append(x509Certificate2.getKeyUsage()[5]).append('\n').append("\t\t+ cRLSign: ").append(x509Certificate2.getKeyUsage()[6]).append('\n').append("\t\t+ encipherOnly: ").append(x509Certificate2.getKeyUsage()[7]).append('\n').append("\t\t+ decipherOnly: ").append(x509Certificate2.getKeyUsage()[8]).append('\n');
            } else {
                stringBuilder.append("\t- El certificado no tiene definidos KeyUsages\n");
            }
            stringBuilder.append(" -----\n");
            boolean bl4 = x509Certificate.getIssuerDN() == null ? x509Certificate2.getIssuerDN() == null : (bl3 = x509Certificate.getIssuerDN().equals(x509Certificate2.getIssuerDN()));
            boolean bl5 = QualifiedCertificatesFilter.getSubjectSN(x509Certificate) == null ? QualifiedCertificatesFilter.getSubjectSN(x509Certificate2) == null : (bl2 = QualifiedCertificatesFilter.getSubjectSN(x509Certificate).equals(QualifiedCertificatesFilter.getSubjectSN(x509Certificate2)));
            boolean bl6 = QualifiedCertificatesFilter.getExpiredDate(x509Certificate) == null ? QualifiedCertificatesFilter.getExpiredDate(x509Certificate2) == null : (bl = QualifiedCertificatesFilter.getExpiredDate(x509Certificate).equals(QualifiedCertificatesFilter.getExpiredDate(x509Certificate2)));
            if (!QualifiedCertificatesFilter.isSignatureCert(x509Certificate2) || !bl3 || !bl2 || !bl) continue;
            stringBuilder.append("Se ha elegido el certificado recien mostrado como pareja del original");
            Logger.getLogger("es.gob.afirma").info(stringBuilder.toString());
            return string;
        }
        stringBuilder.append("NO se ha elegido ningun certificado como pareja del original");
        Logger.getLogger("es.gob.afirma").info(stringBuilder.toString());
        return null;
    }

    private static boolean isSignatureCert(X509Certificate x509Certificate) {
        if (x509Certificate.getKeyUsage() == null) {
            return false;
        }
        KeyUsagesPattern keyUsagesPattern = new KeyUsagesPattern(x509Certificate.getIssuerDN());
        return QualifiedCertificatesFilter.checkKeyUsages(x509Certificate.getKeyUsage(), keyUsagesPattern.getSignaturePattern());
    }

    private static boolean checkKeyUsages(boolean[] blArray, Boolean[] booleanArray) {
        for (int i = 0; i < booleanArray.length; ++i) {
            if (booleanArray[i] == null || booleanArray[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    private static String getSubjectSN(X509Certificate x509Certificate) {
        List<Rdn> list;
        String string = x509Certificate.getSubjectX500Principal().getName();
        try {
            list = new LdapName(string).getRdns();
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
        if (list != null && !list.isEmpty()) {
            for (Rdn rdn : list) {
                String string2 = rdn.toString();
                for (String string3 : SUBJECT_SN_PREFIX) {
                    if (!string2.startsWith(string3)) continue;
                    return string2.substring(string3.length()).replace("#", "");
                }
            }
        }
        return null;
    }

    private static String getExpiredDate(X509Certificate x509Certificate) {
        return new SimpleDateFormat("yyyy-MM-dd").format(x509Certificate.getNotAfter());
    }

    private static String getCertificateSN(X509Certificate x509Certificate) {
        return x509Certificate.getSerialNumber() == null ? null : QualifiedCertificatesFilter.bigIntegerToHex(x509Certificate.getSerialNumber());
    }

    private static String bigIntegerToHex(BigInteger bigInteger) {
        return AOUtil.hexify(bigInteger.toByteArray(), "");
    }

    private static String prepareSerialNumber(String string) {
        int n;
        String string2 = string.trim().replace(" ", "").replace("#", "");
        for (n = 0; n < string2.length() && string2.charAt(n) == '0'; ++n) {
        }
        return string2.substring(n);
    }
}

