/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.distintivos.core;

import es.gob.afirma.miniapplet.ExtraParamsProcessor;
import es.gob.afirma.miniapplet.HttpDownloadAction;
import es.gob.afirma.miniapplet.HttpsDownloadAction;
import es.gob.afirma.miniapplet.MiniAfirmaApplet;
import es.gob.afirma.miniapplet.distintivos.listeners.PrintersListener;
import es.gob.afirma.miniapplet.distintivos.models.EnvDisJob;
import es.gob.afirma.miniapplet.distintivos.models.GroupJob;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.util.Matrix;

public class Printers {
    public static String[] NOT_PRINTERS = new String[]{"MICROSOFT PRINT TO PDF", "PDFCREATOR", "SEND TO ONENOTE", "ENVIAR A ONENOTE", "ONENOTE", "MICROSOFT XPS DOCUMENT WRITER"};
    private static Printers SINGLETON;
    private KeyStore.PrivateKeyEntry privateKey;
    private final List listeners = new ArrayList();
    private final HashMap jobs = new HashMap();
    private Properties params;

    public static Printers instance() {
        if (SINGLETON == null) {
            SINGLETON = new Printers();
        }
        return SINGLETON;
    }

    private Printers() {
    }

    public void configure(String string, KeyStore.PrivateKeyEntry privateKeyEntry) {
        this.privateKey = privateKeyEntry;
        this.params = ExtraParamsProcessor.convertToProperties(string);
    }

    private boolean canPrint(String string) {
        String string2 = string.toUpperCase();
        if (string2.startsWith("SEND TO ONENOTE") || string2.startsWith("ENVIAR A ONENOTE")) {
            return false;
        }
        return !Arrays.asList(NOT_PRINTERS).contains(string2);
    }

    public synchronized void addJob(String string, String string2) {
        string2 = string2.toUpperCase();
        System.out.println(string + "::" + string2);
        if (!this.jobs.containsKey(string2)) {
            this.jobs.put(string2, new GroupJob(string2));
        }
        ((GroupJob)this.jobs.get(string2)).getJobs().add(new EnvDisJob(string, string2));
    }

    public synchronized GroupJob getGroup(String string) {
        if (!this.jobs.containsKey(string)) {
            return new GroupJob(string);
        }
        return (GroupJob)this.jobs.get(string);
    }

    public synchronized List getGroups() {
        return new ArrayList(this.jobs.values());
    }

    public boolean print(PrinterJob printerJob, String string, byte[] byArray) {
        try {
            PDDocument pDDocument = this.transformPDF(string, byArray);
            printerJob.setPageable(new PDFPageable(pDDocument));
            printerJob.print();
            pDDocument.close();
            return true;
        }
        catch (PrinterException printerException) {
            Logger.getLogger(Printers.class.getName()).log(Level.SEVERE, null, printerException);
        }
        catch (IOException iOException) {
            Logger.getLogger(Printers.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return false;
    }

    public PDDocument transformPDF(String string, byte[] byArray) throws IOException {
        PDDocument pDDocument = PDDocument.load(byArray);
        int n = this.params.getProperty("pdfbox.offsetX") != null && this.params.getProperty("pdfbox.offsetX").isEmpty() ? 0 : Integer.parseInt(this.params.getProperty("pdfbox.offsetX"));
        int n2 = this.params.getProperty("pdfbox.offsetY") != null && this.params.getProperty("pdfbox.offsetY").isEmpty() ? 0 : Integer.parseInt(this.params.getProperty("pdfbox.offsetY"));
        int n3 = this.params.getProperty("pdfbox.rotation") != null && this.params.getProperty("pdfbox.rotation").isEmpty() ? 0 : Integer.parseInt(this.params.getProperty("pdfbox.rotation"));
        float f = this.params.getProperty("pdfbox.scale") != null && this.params.getProperty("pdfbox.scale").isEmpty() ? 1.0f : Float.parseFloat(this.params.getProperty("pdfbox.scale"));
        String string2 = this.params.getProperty("pdfbox.paper");
        System.out.println("offsetX: " + n);
        System.out.println("offsetY: " + n2);
        System.out.println("rotation: " + n3);
        System.out.println("scale: " + f);
        System.out.println("paper: " + n);
        PDPage pDPage = pDDocument.getDocumentCatalog().getPages().get(0);
        PDPageContentStream pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.PREPEND, false, false);
        if (string.equals("L0") || string.equals("LE") || string.equals("LC") || string.equals("LB")) {
            n -= 7;
            n2 += 3;
        } else if (string.equals("0") || string.equals("E") || string.equals("C") || string.equals("B")) {
            ++n2;
        }
        Matrix matrix = new Matrix();
        matrix.rotate(Math.toRadians(n3));
        matrix.translate(n, n2);
        matrix.scale(f, f);
        pDPageContentStream.transform(matrix);
        pDPageContentStream.close();
        if (string2 == null) {
            pDPage.setCropBox(PDRectangle.A4);
        } else if (string2.equals("A0")) {
            pDPage.setCropBox(PDRectangle.A0);
        } else if (string2.equals("A1")) {
            pDPage.setCropBox(PDRectangle.A1);
        } else if (string2.equals("A2")) {
            pDPage.setCropBox(PDRectangle.A2);
        } else if (string2.equals("A3")) {
            pDPage.setCropBox(PDRectangle.A3);
        } else if (string2.equals("A4")) {
            pDPage.setCropBox(PDRectangle.A4);
        } else if (string2.equals("A5")) {
            pDPage.setCropBox(PDRectangle.A5);
        } else if (string2.equals("A6")) {
            pDPage.setCropBox(PDRectangle.A6);
        } else if (string2.equals("LETTER")) {
            pDPage.setCropBox(PDRectangle.LETTER);
        } else if (string2.equals("LEGAL")) {
            pDPage.setCropBox(PDRectangle.LEGAL);
        } else {
            pDPage.setCropBox(PDRectangle.A4);
        }
        return pDDocument;
    }

    private PrintService[] getAvaliableServices() {
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!this.canPrint(printServiceArray[i].getName())) continue;
            arrayList.add(printServiceArray[i]);
        }
        if (arrayList.size() > 0) {
            PrintService[] printServiceArray2 = new PrintService[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                printServiceArray2[i] = (PrintService)arrayList.get(i);
            }
            return printServiceArray2;
        }
        return null;
    }

    public synchronized void printJobs(final String string) {
        GroupJob groupJob;
        if (this.jobs.containsKey(string) && !(groupJob = (GroupJob)this.jobs.get(string)).isPrinting()) {
            groupJob.setPrinting(true);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n = 0;
                        int n2 = 0;
                        int n3 = 0;
                        PrinterJob printerJob = PrinterJob.getPrinterJob();
                        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                        hashPrintRequestAttributeSet.add(DialogTypeSelection.NATIVE);
                        PrintService[] printServiceArray = Printers.this.getAvaliableServices();
                        if (printServiceArray.length > 0 && printerJob.printDialog(hashPrintRequestAttributeSet)) {
                            if (hashPrintRequestAttributeSet.get(Destination.class) == null) {
                                int n4;
                                groupJob.setService(printerJob.getPrintService());
                                for (n4 = 0; n4 < Printers.this.listeners.size(); ++n4) {
                                    ((PrintersListener)Printers.this.listeners.get(n4)).startJob(string);
                                    ((PrintersListener)Printers.this.listeners.get(n4)).printProgress(string, 0, groupJob.getJobs().size(), 0);
                                }
                                for (n4 = 0; n4 < groupJob.getJobs().size(); ++n4) {
                                    EnvDisJob envDisJob = (EnvDisJob)groupJob.getJobs().get(n4);
                                    if (!envDisJob.isPrinted()) {
                                        byte[] byArray = Printers.this.downloadPDFData(envDisJob.getUrl());
                                        if (byArray != null && Printers.this.print(printerJob, string, byArray)) {
                                            envDisJob.setPrinted(true);
                                            ++n2;
                                        } else {
                                            ++n;
                                            String string2 = envDisJob + ": No se pudo realizar el trabajo.";
                                            Logger.getLogger(Printers.class.getName()).log(Level.SEVERE, string2);
                                        }
                                    }
                                    ++n3;
                                    for (int i = 0; i < Printers.this.listeners.size(); ++i) {
                                        ((PrintersListener)Printers.this.listeners.get(i)).printProgress(string, n3, groupJob.getJobs().size(), n2);
                                    }
                                }
                                for (n4 = groupJob.getJobs().size() - 1; n4 >= 0; --n4) {
                                    if (!((EnvDisJob)groupJob.getJobs().get(n4)).isPrinted()) continue;
                                    groupJob.getJobs().remove(n4);
                                }
                                groupJob.setPrinting(false);
                                if (groupJob.getJobs().isEmpty()) {
                                    Printers.this.jobs.remove(string);
                                    if (Printers.this.jobs.isEmpty()) {
                                        for (n4 = 0; n4 < Printers.this.listeners.size(); ++n4) {
                                            ((PrintersListener)Printers.this.listeners.get(n4)).endJobs();
                                        }
                                    }
                                }
                                for (n4 = 0; n4 < Printers.this.listeners.size(); ++n4) {
                                    ((PrintersListener)Printers.this.listeners.get(n4)).endJob(string);
                                }
                                if (n > 0) {
                                    for (n4 = 0; n4 < Printers.this.listeners.size(); ++n4) {
                                        ((PrintersListener)Printers.this.listeners.get(n4)).error("No se han podido realizar " + n + " trabajo/s");
                                    }
                                }
                            } else {
                                for (int i = 0; i < Printers.this.listeners.size(); ++i) {
                                    ((PrintersListener)Printers.this.listeners.get(i)).error("No se permite el env\u00edo a fichero.");
                                }
                            }
                        }
                        groupJob.setPrinting(false);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(Printers.class.getName()).log(Level.SEVERE, null, exception);
                    }
                }
            };
            thread.start();
        }
    }

    private byte[] downloadPDFData(String string) {
        this.params.setProperty("filter", this.params.getProperty("https"));
        try {
            HttpDownloadAction httpDownloadAction = string.startsWith("https") ? new HttpsDownloadAction(this.privateKey) : new HttpDownloadAction();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            httpDownloadAction.setConnection(string, this.params.getProperty("SessionName"), this.params.getProperty("SessionId"), this.params.getProperty("UserAgent"), this.params.getProperty("LastRefresh"), this.params.getProperty("LastRefreshName"));
            httpDownloadAction.setOutputStream(byteArrayOutputStream);
            AccessController.doPrivileged(httpDownloadAction);
            return byteArrayOutputStream.toByteArray();
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
        }
        catch (IOException iOException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return null;
    }

    public synchronized PrintService findPrinter(String string) {
        PrintService[] printServiceArray;
        for (PrintService printService : printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().trim().equals(string)) continue;
            return printService;
        }
        return null;
    }

    public synchronized void addListener(PrintersListener printersListener) {
        this.listeners.add(printersListener);
    }

    public synchronized void removeListener(PrintersListener printersListener) {
        this.listeners.remove(printersListener);
    }

    public synchronized List<PrintersListener> getListeners() {
        return this.listeners;
    }
}

