/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.distintivos.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int vgap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public VerticalLayout() {
        this(4);
    }

    public VerticalLayout(int n) {
        this.vgap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    private void setSizes(Container container) {
        int n = container.getComponentCount();
        this.preferredWidth = 0;
        this.preferredHeight = container.getMinimumSize().width;
        this.minWidth = 0;
        this.minHeight = container.getMinimumSize().width;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            int n2 = 0;
            this.preferredHeight += dimension.height + n2 + this.vgap;
            this.minHeight = this.preferredHeight;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        this.setSizes(container);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = insets.left;
        int n3 = insets.top;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            int n4 = 0;
            component.setBounds(n2, n3 + n4, container.getWidth() - insets.left - insets.right, dimension.height);
            n3 += dimension.height + n4 + this.vgap;
        }
    }

    public String toString() {
        String string = "";
        return this.getClass().getName() + "[vgap=" + this.vgap + string + "]";
    }
}

