/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.distintivos.components;

import es.gob.afirma.miniapplet.distintivos.components.JJob;
import es.gob.afirma.miniapplet.distintivos.components.VerticalLayout;
import es.gob.afirma.miniapplet.distintivos.core.Printers;
import es.gob.afirma.miniapplet.distintivos.listeners.PrintersListener;
import es.gob.afirma.miniapplet.distintivos.models.GroupJob;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JJobList
extends JPanel {
    private final HashMap components = new HashMap();

    public JJobList() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new VerticalLayout());
        this.addGroups();
        Printers.instance().addListener(new PrintersListener(){

            @Override
            public void startJob(String string) {
                JJobList.this.refreshGroup(string);
            }

            @Override
            public void endJob(String string) {
                JJobList.this.refreshGroup(string);
            }

            @Override
            public void printProgress(String string, int n, int n2, int n3) {
                JJobList.this.setProgressValue(string, n, n2);
            }

            @Override
            public void error(String string) {
                JOptionPane.showMessageDialog(JJobList.this, string, "Error", 0);
            }
        });
    }

    private void addGroups() {
        List list = Printers.instance().getGroups();
        for (GroupJob groupJob : list) {
            JJob jJob = new JJob(groupJob);
            this.components.put(groupJob.getTipo(), jJob);
            this.add(jJob);
        }
    }

    private void setProgressValue(final String string, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JJob jJob = JJobList.this.components.getOrDefault(string, null);
                if (jJob != null) {
                    jJob.setProgressValue(n, n2);
                    JJobList.this.revalidate();
                    JJobList.this.repaint();
                }
            }
        });
    }

    private void refreshGroup(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JJob jJob = JJobList.this.components.getOrDefault(string, null);
                if (jJob != null) {
                    GroupJob groupJob = Printers.instance().getGroup(string);
                    if (groupJob.getJobs().isEmpty()) {
                        JJobList.this.components.remove(string);
                        JJobList.this.remove(jJob);
                    } else {
                        jJob.refresh();
                    }
                    JJobList.this.revalidate();
                    JJobList.this.repaint();
                }
            }
        });
    }
}

