/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet.distintivos.components;

import es.gob.afirma.miniapplet.distintivos.core.Printers;
import es.gob.afirma.miniapplet.distintivos.models.GroupJob;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JJob
extends JPanel {
    private GroupJob job;
    private final JLabel lblTipo = new JLabel();
    private final JLabel lblDistintivos = new JLabel();
    private final JButton btPrint = new JButton();
    private final JProgressBar progressBar = new JProgressBar();

    public JJob(GroupJob groupJob) {
        this.job = groupJob;
        this.initComponents();
    }

    private void initComponents() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        try {
            serializable = JJob.class.getResource("/images/" + this.job.getTipo().toUpperCase() + ".jpg");
            this.lblTipo.setIcon(new ImageIcon((URL)serializable));
        }
        catch (Exception exception) {
            Logger.getLogger(JJob.class.getName()).log(Level.SEVERE, null, exception);
        }
        jPanel.add(this.lblTipo);
        this.add((Component)jPanel, "West");
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.add((Component)serializable, "Center");
        ((Container)serializable).add(this.lblDistintivos, "North");
        this.btPrint.setText("Imprimir");
        this.btPrint.setEnabled(false);
        this.btPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Printers.instance().printJobs(JJob.this.job.getTipo());
            }
        });
        ((Container)serializable).add(this.btPrint, "Center");
        ((Container)serializable).add(this.progressBar, "South");
        this.refresh();
    }

    public void setProgressValue(int n, int n2) {
        this.progressBar.setValue(n);
        this.progressBar.setMaximum(n2);
    }

    private String getName(GroupJob groupJob) {
        String string = groupJob.getTipo();
        String string2 = "Distintivo medioambiental ";
        String string3 = "desconocido";
        String string4 = "";
        if (string != null) {
            if (string.length() > 1 && string.substring(0, 1).equals("L")) {
                string4 = " (Motos)";
                string3 = string.substring(1, 2);
            } else if (string.length() == 1) {
                string3 = string;
            }
            if (string3.equals("E")) {
                string3 = "ECO";
            }
        }
        string2 = string2 + string3 + string4 + ": " + groupJob.getJobs().size() + " ud.";
        return string2;
    }

    public void refresh() {
        this.lblDistintivos.setText(this.getName(this.job));
        this.btPrint.setEnabled(!this.job.isPrinting());
    }
}

