/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.xml.bind.DatatypeConverter;

public class MiniAfirmaWindow
extends JFrame {
    private final AfirmaPanel panel = new AfirmaPanel();
    private final SystemTray tray = SystemTray.getSystemTray();
    private TrayIcon trayIcon = null;
    private int counter = 0;
    private int size = 0;
    private String messageString = "PROCESANDO (%index / %size)";
    protected boolean enableErrors = false;
    private final ArrayList<ErrorList> errores = new ArrayList();

    public void open() {
        this.setType(Window.Type.UTILITY);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(3);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setSize(this.panel.getWidth(), this.panel.getHeight());
        this.setLocationRelativeTo(null);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setVisible(true);
        if (SystemTray.isSupported() && this.trayIcon != null) {
            try {
                this.trayIcon.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        MiniAfirmaWindow.this.setVisible(true);
                    }
                });
                this.tray.add(this.trayIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (SystemTray.isSupported()) {
            try {
                this.tray.remove(this.trayIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.errores.size() > 0) {
            String string = "";
            for (ErrorList errorList : this.errores) {
                string = string + "- Errores en el elemento " + (errorList.index + 1) + ":\n  " + String.join((CharSequence)"\n  ", errorList.errors) + "\n\n";
            }
            JOptionPane.showMessageDialog(this, string, "Error", 0);
        }
        this.dispose();
    }

    public int getCurrentIndex() {
        return this.counter;
    }

    public void addError(String string) {
        this.addError(string, false);
    }

    public void addError(String string, boolean bl) {
        if (this.enableErrors) {
            int n;
            for (n = 0; n < this.errores.size() && this.errores.get((int)n).index != this.counter; ++n) {
            }
            if (n < this.errores.size()) {
                if (!bl || this.errores.get((int)n).errors.indexOf(string) < 0) {
                    this.errores.get((int)n).errors.add(string);
                }
            } else {
                ErrorList errorList = new ErrorList();
                errorList.index = this.counter;
                errorList.errors.add(string);
                this.errores.add(errorList);
            }
        }
        System.out.println("! " + this.counter + " => " + string);
    }

    public void setMessage(String string) {
        this.panel.setMessage(string);
    }

    public void setProgress(int n) {
        this.panel.setProgress(n);
    }

    public void setProgress(int n, String string) {
        this.panel.setProgress(n, string);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip(string);
        }
    }

    public void setBackground(Image image) {
        this.panel.setBackground(image);
    }

    public void setBackground(String string) {
        this.panel.setBackground(string);
    }

    public void setBackgroundB64(String string) {
        BufferedImage bufferedImage = MiniAfirmaWindow.decodeToImage(string);
        if (bufferedImage != null) {
            this.panel.setBackground(bufferedImage);
        } else {
            this.panel.setBackground(new ImageIcon().getImage());
        }
    }

    public void setTrayIcon(Image image) {
        try {
            this.trayIcon = new TrayIcon(image);
            this.trayIcon.setToolTip(this.getTitle());
        }
        catch (Exception exception) {
            this.trayIcon = null;
        }
    }

    public void setTrayIcon(String string) {
        try {
            this.trayIcon = new TrayIcon(new ImageIcon(this.getClass().getResource(string)).getImage());
            this.trayIcon.setToolTip(this.getTitle());
        }
        catch (Exception exception) {
            this.trayIcon = null;
        }
    }

    public void setTrayIconB64(String string) {
        BufferedImage bufferedImage = MiniAfirmaWindow.decodeToImage(string);
        if (bufferedImage != null) {
            this.setTrayIcon(bufferedImage);
        } else {
            this.setTrayIcon(new ImageIcon().getImage());
        }
    }

    private static BufferedImage decodeToImage(String string) {
        try {
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
            return ImageIO.read(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setProgressBarBounds(int n, int n2, int n3, int n4) {
        this.panel.setProgressBarBounds(n, n2, n3, n4);
    }

    public void setProgressMax(int n) {
        this.panel.setProgressMax(n);
    }

    public int getElementsSize() {
        return this.size;
    }

    public void setElementsSize(int n) {
        this.counter = 0;
        this.size = n;
    }

    public void startProcess(int n) {
        this.startProcess(n, null);
    }

    public void startProcess(int n, String string) {
        this.counter = 0;
        this.size = n;
        if (string != null) {
            this.messageString = string;
        }
        String string2 = this.messageString;
        string2 = string2.replaceAll("%index", "0");
        string2 = string2.replaceAll("%size", "" + n);
        this.setProgress(0, string2);
    }

    public boolean finishElement() {
        ++this.counter;
        int n = this.counter * 100 / this.size;
        String string = this.messageString;
        string = string.replaceAll("%index", "" + this.counter);
        string = string.replaceAll("%size", "" + this.size);
        this.setProgress(n, string);
        return this.counter == this.size;
    }

    public void nextElement() {
        if (this.finishElement()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.close();
        }
    }

    public void previousElement() {
        --this.counter;
        int n = this.counter * 100 / this.size;
        String string = this.messageString;
        string = string.replaceAll("%index", "" + this.counter);
        string = string.replaceAll("%size", "" + this.size);
        this.setProgress(n, string);
    }

    private class ErrorList {
        public int index = 0;
        public final ArrayList<String> errors = new ArrayList();

        private ErrorList() {
        }
    }

    public class AfirmaPanel
    extends JPanel {
        private final Color COLOR_PB_BACKGROUND = new Color(251, 247, 241);
        private int progress = 0;
        private String message = "";
        private ImageIcon originalBG = null;
        private final ImageFilter filter = new RGBImageFilter(){
            int transparentColor = Color.white.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.transparentColor) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        private ImageProducer filteredImgProd;
        private Image transparentImg;
        private final Font font = new Font("Arial Bold", 0, 12);
        private final JProgressBar progressBar = new JProgressBar(0, 100);

        public AfirmaPanel() {
            this.init();
        }

        private void init() {
            this.setOpaque(true);
            this.progressBar.setBackground(this.COLOR_PB_BACKGROUND);
            this.progressBar.setStringPainted(true);
            if (this.originalBG == null) {
                this.progressBar.setBounds(0, 0, 300, 20);
                this.setPreferredSize(new Dimension(this.progressBar.getWidth(), this.progressBar.getHeight()));
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setBackground(new Color(255, 255, 255, 0));
            }
            graphics.clearRect(0, 0, n, n2);
            if (this.originalBG != null) {
                graphics.drawImage(this.transparentImg, 0, 0, this);
            }
            if (this.progress < 0) {
                if (this.message != null && this.message.length() > 0) {
                    if (graphics instanceof Graphics2D) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.setFont(this.font);
                        graphics2D.drawString(this.message, this.progressBar.getX(), this.progressBar.getY());
                    } else {
                        graphics.setFont(this.font);
                        graphics.drawString(this.message, this.progressBar.getX(), this.progressBar.getY());
                    }
                }
            } else {
                graphics.translate(this.progressBar.getX(), this.progressBar.getY());
                this.progressBar.setValue(this.progress);
                this.progressBar.setString(this.message);
                this.progressBar.paint(graphics);
            }
        }

        public void setMessage(String string) {
            this.message = string;
            this.revalidate();
            this.repaint();
        }

        public void setProgress(int n) {
            this.progress = n;
            if (this.progress > 100) {
                this.progress = 0;
            }
            this.revalidate();
            this.repaint();
        }

        public void setProgress(int n, String string) {
            this.progress = n;
            if (this.progress > 100) {
                this.progress = 0;
            }
            this.message = string;
            this.revalidate();
            this.repaint();
        }

        public void setBackground(Image image) {
            this.originalBG = new ImageIcon(image);
            this.filteredImgProd = new FilteredImageSource(this.originalBG.getImage().getSource(), this.filter);
            this.transparentImg = Toolkit.getDefaultToolkit().createImage(this.filteredImgProd);
            this.setPreferredSize(new Dimension(this.originalBG.getIconWidth(), this.originalBG.getIconHeight()));
            this.revalidate();
            this.repaint();
        }

        public void setBackground(String string) {
            try {
                this.setBackground(new ImageIcon(this.getClass().getResource(string)).getImage());
            }
            catch (Exception exception) {
                this.setBackground(new ImageIcon().getImage());
            }
        }

        public void setProgressBarBounds(int n, int n2, int n3, int n4) {
            this.progressBar.setBounds(n, n2, n3, n4);
        }

        public void setProgressMax(int n) {
            this.progressBar.setMaximum(n);
        }
    }
}

